/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BaseTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected static final Insets NULL_BORDER_INSETS = new Insets(0, 0, 0, 0);
    protected static final int GAP = 5;
    protected JTabbedPane tabPane;
    protected Color tabAreaBackground;
    protected Color selectedColor;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected FocusListener focusListener;
    private ContainerListener containerListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    private TabContainer tabContainer;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int tabCount;
    protected int oldRolloverIndex = -1;
    protected int rolloverIndex = -1;
    protected boolean roundedTabs = true;
    protected boolean simpleButtonBorder = false;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (JTattooUtilities.getJavaVersion() >= 1.4 && this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    protected boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
            this.tabPane.add(this.tabScroller.popupMenuButton);
            this.tabScroller.tabPanel.setBackground(this.tabAreaBackground);
        }
        this.installTabContainer();
    }

    private void installTabContainer() {
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                Component component = this.tabPane.getTabComponentAt(i);
                if (component == null) continue;
                if (this.tabContainer == null) {
                    this.tabContainer = new TabContainer();
                }
                this.tabContainer.add(component);
            }
            if (this.tabContainer == null) {
                return;
            }
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.add(this.tabContainer);
            } else {
                this.tabPane.add(this.tabContainer);
            }
        }
    }

    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabPane.remove(this.tabScroller.popupMenuButton);
            this.tabScroller = null;
        }
    }

    private void uninstallTabContainer() {
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            if (this.tabContainer == null) {
                return;
            }
            this.tabContainer.notifyTabbedPane = false;
            this.tabContainer.removeAll();
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.remove(this.tabContainer);
            } else {
                this.tabPane.remove(this.tabContainer);
            }
            this.tabContainer = null;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabPane.setBorder(UIManager.getBorder("TabbedPane.boder"));
    }

    protected void uninstallDefaults() {
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
            } else {
                this.tabPane.addMouseListener(this.mouseListener);
            }
        }
        if ((this.mouseMotionListener = this.createMouseMotionListener()) != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.addMouseMotionListener(this.mouseMotionListener);
            } else {
                this.tabPane.addMouseMotionListener(this.mouseMotionListener);
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        if ((this.containerListener = new ContainerHandler()) != null) {
            this.tabPane.addContainerListener(this.containerListener);
            if (this.tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            } else {
                this.tabPane.removeMouseListener(this.mouseListener);
            }
            this.mouseListener = null;
        }
        if (this.mouseMotionListener != null) {
            if (this.scrollableTabLayoutEnabled()) {
                this.tabScroller.tabPanel.removeMouseMotionListener(this.mouseMotionListener);
            } else {
                this.tabPane.removeMouseMotionListener(this.mouseMotionListener);
            }
            this.mouseMotionListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new MouseMotionHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, actionMap);
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.scrollForwardButton.setAction(actionMap.get("scrollTabsForwardAction"));
            this.tabScroller.scrollBackwardButton.setAction(actionMap.get("scrollTabsBackwardAction"));
            this.tabScroller.popupMenuButton.setAction(actionMap.get("scrollTabsPopupMenuAction"));
        }
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("TabbedPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateNext", new NextAction());
        actionMapUIResource.put("navigatePrevious", new PreviousAction());
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        actionMapUIResource.put("navigatePageUp", new PageUpAction());
        actionMapUIResource.put("navigatePageDown", new PageDownAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        actionMapUIResource.put("setSelectedIndex", new SetSelectedIndexAction());
        actionMapUIResource.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        actionMapUIResource.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        actionMapUIResource.put("scrollTabsPopupMenuAction", new ScrollTabsPopupMenuAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            this.resetMnemonics();
            for (int i = this.tabPane.getTabCount() - 1; i >= 0; --i) {
                int n = this.tabPane.getMnemonicAt(i);
                if (n <= 0) continue;
                this.addMnemonic(i, n);
            }
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n, int n2) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n2, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(n2), new Integer(n));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    protected Color[] getTabColors(int n, boolean bl) {
        Color[] colorArray = AbstractLookAndFeel.getTheme().getTabColors();
        if (n >= 0 && n < this.tabPane.getTabCount()) {
            boolean bl2 = this.tabPane.isEnabledAt(n);
            Color color = this.tabPane.getBackgroundAt(n);
            colorArray = color instanceof UIResource ? (bl ? AbstractLookAndFeel.getTheme().getSelectedColors() : (n == this.rolloverIndex && bl2 ? AbstractLookAndFeel.getTheme().getRolloverColors() : AbstractLookAndFeel.getTheme().getTabColors())) : (bl ? AbstractLookAndFeel.getTheme().getSelectedColors() : (n == this.rolloverIndex && bl2 ? AbstractLookAndFeel.getTheme().getRolloverColors() : ColorHelper.createColorArr(ColorHelper.brighter(color, 40.0), ColorHelper.darker(color, 10.0), 20)));
        }
        return colorArray;
    }

    protected Color getSelectedBorderColor(int n) {
        return this.getLoBorderColor(n);
    }

    protected Color getLoBorderColor(int n) {
        return AbstractLookAndFeel.getControlDarkShadow();
    }

    protected Color getHiBorderColor(int n) {
        if (this.tabPane.getBackgroundAt(n) instanceof ColorUIResource) {
            return AbstractLookAndFeel.getControlHighlight();
        }
        if (n == this.tabPane.getSelectedIndex() || n == this.rolloverIndex) {
            return AbstractLookAndFeel.getControlHighlight();
        }
        return ColorHelper.brighter(this.tabPane.getBackgroundAt(n), 20.0);
    }

    protected Color[] getContentBorderColors(int n) {
        int n2 = this.tabAreaInsets.bottom;
        Color[] colorArray = AbstractLookAndFeel.getTheme().getSelectedColors();
        Color color = colorArray[colorArray.length - 1];
        Color color2 = ColorHelper.darker(color, 20.0);
        return ColorHelper.createColorArr(color, color2, n2);
    }

    protected Color getContentBorderColor() {
        return AbstractLookAndFeel.getFrameColor();
    }

    protected Color getGapColor(int n) {
        if (n >= 0 && n < this.tabPane.getTabCount()) {
            boolean bl = this.tabPane.isEnabledAt(n);
            Color color = this.tabPane.getBackgroundAt(n);
            Color[] colorArray = null;
            colorArray = color instanceof UIResource ? (n == this.tabPane.getSelectedIndex() ? AbstractLookAndFeel.getTheme().getSelectedColors() : AbstractLookAndFeel.getTheme().getTabColors()) : (n == this.tabPane.getSelectedIndex() ? AbstractLookAndFeel.getTheme().getSelectedColors() : ColorHelper.createColorArr(ColorHelper.brighter(color, 40.0), ColorHelper.darker(color, 10.0), 20));
            return colorArray[colorArray.length - 1];
        }
        return this.tabAreaBackground;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getTabCount();
        if (this.tabCount != n) {
            this.tabCount = n;
            this.updateMnemonics();
        }
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        this.paintContentBorder(graphics, n3, n2, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n3, n2);
        }
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Shape shape = graphics.getClip();
        Rectangle rectangle3 = graphics.getClipBounds();
        if (this.scrollableTabLayoutEnabled() && this.tabScroller.scrollBackwardButton.isVisible()) {
            if (n == 1 || n == 3) {
                graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width + 1, rectangle3.height);
            } else {
                graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height + 1);
            }
        }
        for (int i = this.runCount - 1; i >= 0; --i) {
            int n4 = this.tabRuns[i];
            int n5 = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int n6 = n5 != 0 ? n5 - 1 : n3 - 1;
            for (int j = n4; j <= n6; ++j) {
                if (!this.rects[j].intersects(rectangle3)) continue;
                this.paintTab(graphics, n, this.rects, j, rectangle, rectangle2);
            }
        }
        if (n2 >= 0 && n2 < this.rects.length && this.getRunForTab(n3, n2) == 0 && this.rects[n2].intersects(rectangle3)) {
            this.paintTab(graphics, n, this.rects, n2, rectangle, rectangle2);
        }
        graphics.setClip(shape);
    }

    protected Font getTabFont(boolean bl) {
        return this.tabPane.getFont();
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n4 = 0;
        int n5 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            Rectangle rectangle4 = this.tabScroller.viewport.getViewRect();
            switch (n) {
                case 2: 
                case 4: {
                    int n6 = rectangle4.y + rectangle4.height;
                    if (rectangle3.y >= n6 || rectangle3.y + rectangle3.height <= n6) break;
                    polygon = this.createCroppedTabClip(n, rectangle3, n6);
                    n4 = rectangle3.x;
                    n5 = n6 - 1;
                    break;
                }
                default: {
                    int n6 = rectangle4.x + rectangle4.width;
                    if (rectangle3.x >= n6 || rectangle3.x + rectangle3.width <= n6) break;
                    polygon = this.createCroppedTabClip(n, rectangle3, n6);
                    n4 = n6 - 1;
                    n5 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics2D.getClip();
                graphics2D.clip(polygon);
            }
        }
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        try {
            boolean bl2 = true;
            if (JTattooUtilities.getJavaVersion() >= 1.6) {
                boolean bl3 = bl2 = this.tabPane.getTabComponentAt(n2) == null;
            }
            if (bl2) {
                String string = this.tabPane.getTitleAt(n2);
                Font font = this.getTabFont(bl);
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                Icon icon = this.getIconForTab(n2);
                this.layoutLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
                this.paintText(graphics, n, font, fontMetrics, n2, string, rectangle2, bl);
                this.paintIcon(graphics, n, n2, icon, rectangle, bl);
            }
            this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n, n2, n4, n5);
            graphics2D.setClip(shape);
        }
    }

    private Polygon createCroppedTabClip(int n, Rectangle rectangle, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n) {
            case 2: 
            case 4: {
                n3 = rectangle.width;
                n4 = rectangle.x;
                n5 = rectangle.x + rectangle.width;
                n6 = rectangle.y;
                break;
            }
            default: {
                n3 = rectangle.height;
                n4 = rectangle.y;
                n5 = rectangle.y + rectangle.height;
                n6 = rectangle.x;
            }
        }
        int n7 = n3 / 12;
        if (n3 % 12 > 0) {
            ++n7;
        }
        int n8 = 2 + n7 * 8;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        int n9 = 0;
        nArray[n9] = n6;
        nArray2[n9++] = n5;
        nArray[n9] = n6;
        nArray2[n9++] = n4;
        block3: for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < this.xCropLen.length; ++j) {
                nArray[n9] = n2 - this.xCropLen[j];
                nArray2[n9] = n4 + i * 12 + this.yCropLen[j];
                if (nArray2[n9] >= n5) {
                    nArray2[n9] = n5;
                    ++n9;
                    continue block3;
                }
                ++n9;
            }
        }
        if (n == 1 || n == 3) {
            return new Polygon(nArray, nArray2, n9);
        }
        return new Polygon(nArray2, nArray, n9);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.gray);
        switch (n) {
            case 2: 
            case 4: {
                for (int i = n3; i <= n3 + this.rects[n2].width; i += 12) {
                    for (int j = 0; j < this.xCropLen.length; j += 2) {
                        graphics.drawLine(i + this.yCropLen[j], n4 - this.xCropLen[j], i + this.yCropLen[j + 1] - 1, n4 - this.xCropLen[j + 1]);
                    }
                }
                break;
            }
            default: {
                for (int i = n4; i <= n4 + this.rects[n2].height; i += 12) {
                    for (int j = 0; j < this.xCropLen.length; j += 2) {
                        graphics.drawLine(n3 - this.xCropLen[j], i + this.yCropLen[j], n3 - this.xCropLen[j + 1], i + this.yCropLen[j + 1] - 1);
                    }
                }
            }
        }
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        if (!bl) {
            if (n == 1) {
                return 1;
            }
            if (n == 3) {
                return -1;
            }
        }
        return 0;
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            view.paint(graphics, rectangle);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        } else {
            int n3 = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                if (bl) {
                    graphics.setColor(AbstractLookAndFeel.getSelectionForegroundColor());
                } else {
                    graphics.setColor(this.tabPane.getForegroundAt(n2));
                }
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.tabPane.hasFocus() && bl) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFocusColor());
            BasicGraphicsUtils.drawDashedRect(graphics, rectangle2.x - 4, rectangle2.y + 1, rectangle2.width + 8, rectangle2.height);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n3 + n5;
        int n8 = n4 + n6;
        switch (n) {
            case 2: {
                this.paintLeftTabBorder(n2, graphics, n3, n4, n7, n8, bl);
                break;
            }
            case 4: {
                this.paintRightTabBorder(n2, graphics, n3, n4, n7, n8, bl);
                break;
            }
            case 3: {
                if (this.roundedTabs) {
                    this.paintRoundedBottomTabBorder(n2, graphics, n3, n4, n7, n8 - 1, bl);
                    break;
                }
                this.paintBottomTabBorder(n2, graphics, n3, n4, n7, n8 - 1, bl);
                break;
            }
            default: {
                if (this.roundedTabs) {
                    this.paintRoundedTopTabBorder(n2, graphics, n3, n4, n7, n8, bl);
                    break;
                }
                this.paintTopTabBorder(n2, graphics, n3, n4, n7, n8, bl);
            }
        }
    }

    protected void paintRoundedTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = this.tabPane.getTabCount();
        int n7 = this.getRunForTab(n6, n);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.getLoBorderColor(n);
        if (bl) {
            color = this.getSelectedBorderColor(n);
        }
        graphics.setColor(color);
        int n8 = 10;
        if (bl) {
            graphics.drawLine(n2 + 5, n3, n4 - 5, n3);
            graphics.drawArc(n2, n3, n8, n8, 90, 90);
            graphics.drawArc(n4 - n8, n3, n8, n8, 0, 90);
            graphics.drawLine(n2, n3 + 5 + 1, n2, n5);
            graphics.drawLine(n4, n3 + 5 + 1, n4, n5);
        } else {
            graphics.drawLine(n2 + 5, n3, n4 - 5, n3);
            graphics.drawArc(n2, n3, n8, n8, 90, 90);
            graphics.drawArc(n4 - n8, n3, n8, n8, 0, 90);
            graphics.drawLine(n2, n3 + 5 + 1, n2, n5 - 1);
            graphics.drawLine(n4, n3 + 5 + 1, n4, n5 - 1);
        }
        if (n7 == this.runCount - 1) {
            graphics.setColor(this.tabAreaBackground);
            graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1);
            graphics.drawLine(n4 - 1, n3 + 1, n4 - 1, n3 + 1);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void paintTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = this.tabPane.getTabCount();
        int n7 = this.getRunForTab(n6, n);
        int n8 = this.lastTabInRun(n6, n7);
        int n9 = this.tabRuns[n7];
        boolean bl2 = JTattooUtilities.isLeftToRight(this.tabPane);
        Color color = this.getLoBorderColor(n);
        Color color2 = this.getHiBorderColor(n);
        if (bl) {
            graphics.setColor(this.getSelectedBorderColor(n));
        } else {
            graphics.setColor(color);
        }
        graphics.drawLine(n2 + 5, n3, n4, n3);
        graphics.drawLine(n2 + 5, n3, n2, n3 + 5);
        graphics.drawLine(n2, n3 + 5 + 1, n2, n5);
        graphics.drawLine(n4, n3, n4, n5);
        graphics.setColor(color2);
        graphics.drawLine(n2 + 5 + 1, n3 + 1, n4 - 1, n3 + 1);
        graphics.drawLine(n2 + 5 + 1, n3 + 1, n2 + 1, n3 + 5 + 1);
        graphics.drawLine(n2 + 1, n3 + 5 + 1, n2 + 1, n5 - 1);
        int n10 = this.getTabAtLocation(n2 + 2, n3 - 2);
        Color color3 = this.getGapColor(n10);
        graphics.setColor(color3);
        for (int i = 0; i < 5; ++i) {
            graphics.drawLine(n2, n3 + i, n2 + 5 - i - 1, n3 + i);
        }
        if (bl2) {
            if (n != n9 || n7 != this.runCount - 1) {
                graphics.setColor(color);
                graphics.drawLine(n2, n3, n2, n3 + 5);
            }
            if (!bl && n == n9 && n7 != this.runCount - 1) {
                graphics.setColor(color2);
                graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + 5 - 2);
            }
        } else if (n != n8 || n7 != this.runCount - 1) {
            graphics.setColor(color);
            graphics.drawLine(n2, n3, n2, n3 + 5);
        }
    }

    protected void paintLeftTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = this.tabPane.getTabCount();
        int n7 = this.getRunForTab(n6, n);
        int n8 = this.lastTabInRun(n6, n7);
        int n9 = this.tabRuns[n7];
        Color color = this.getLoBorderColor(n);
        Color color2 = this.getHiBorderColor(n);
        if (bl) {
            graphics.setColor(this.getSelectedBorderColor(n));
        } else {
            graphics.setColor(color);
        }
        graphics.drawLine(n2 + 5, n3, n4 - 1, n3);
        graphics.drawLine(n2 + 5, n3, n2, n3 + 5);
        graphics.setColor(color);
        graphics.drawLine(n2, n3 + 5, n2, n5);
        graphics.drawLine(n2 + 5, n5, n4 - 1, n5);
        if (n == n8) {
            graphics.drawLine(n2, n5, n2 + 5, n5);
        }
        graphics.setColor(color2);
        graphics.drawLine(n2 + 5, n3 + 1, n4 - 1, n3 + 1);
        graphics.drawLine(n2 + 5, n3 + 1, n2 + 1, n3 + 5);
        graphics.drawLine(n2 + 1, n3 + 5 + 1, n2 + 1, n5 - 1);
        int n10 = this.getTabAtLocation(n2 + 2, n3 - 2);
        Color color3 = this.getGapColor(n10);
        graphics.setColor(color3);
        for (int i = 0; i < 5; ++i) {
            graphics.drawLine(n2, n3 + i, n2 + 5 - i - 1, n3 + i);
        }
        if (n != n9 || n7 != this.runCount - 1) {
            graphics.setColor(color);
            graphics.drawLine(n2, n3, n2, n3 + 5);
            if (n != n9) {
                graphics.setColor(this.getHiBorderColor(n - 1));
                graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + 5 - 2);
            }
        }
    }

    protected void paintRoundedBottomTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = this.tabPane.getTabCount();
        int n7 = this.getRunForTab(n6, n);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.getLoBorderColor(n);
        if (bl) {
            color = this.getSelectedBorderColor(n);
        }
        int n8 = 10;
        graphics.setColor(color);
        graphics.drawLine(n2 + 5, n5, n4 - 5, n5);
        graphics.drawArc(n2, n5 - n8, n8, n8, 180, 90);
        graphics.drawArc(n4 - n8, n5 - n8, n8, n8, -90, 90);
        graphics.drawLine(n2, n3, n2, n5 - 5 - 1);
        graphics.drawLine(n4, n3, n4, n5 - 5 - 1);
        if (n7 == this.runCount - 1) {
            graphics.setColor(this.tabAreaBackground);
            graphics.drawLine(n2 + 1, n5 - 1, n2 + 1, n5 - 1);
            graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, n5 - 1);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void paintBottomTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = this.tabPane.getTabCount();
        int n7 = this.getRunForTab(n6, n);
        int n8 = this.lastTabInRun(n6, n7);
        int n9 = this.tabRuns[n7];
        boolean bl2 = JTattooUtilities.isLeftToRight(this.tabPane);
        Color color = this.getLoBorderColor(n);
        Color color2 = this.getHiBorderColor(n);
        if (bl) {
            graphics.setColor(this.getSelectedBorderColor(n));
        } else {
            graphics.setColor(color);
        }
        graphics.drawLine(n2, n3, n2, n5 - 5);
        graphics.drawLine(n2, n5 - 5, n2 + 5, n5);
        graphics.drawLine(n2 + 5, n5, n4, n5);
        graphics.drawLine(n4, n5, n4, n3);
        graphics.setColor(color2);
        graphics.drawLine(n2 + 1, n3, n2 + 1, n5 - 5 - 1);
        graphics.drawLine(n2 + 1, n5 - 5, n2 + 5, n5 - 1);
        int n10 = this.getTabAtLocation(n2 + 2, n5 + 2);
        Color color3 = this.getGapColor(n10);
        graphics.setColor(color3);
        for (int i = 0; i < 5; ++i) {
            graphics.drawLine(n2, n5 - i, n2 + 5 - i - 1, n5 - i);
        }
        if (bl2) {
            if (n != n9 || n7 != this.runCount - 1) {
                graphics.setColor(color);
                graphics.drawLine(n2, n5 - 5, n2, n5);
            }
        } else if (n != n8 || n7 != this.runCount - 1) {
            graphics.setColor(color);
            graphics.drawLine(n2, n5 - 5, n2, n5);
        }
    }

    protected void paintRightTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = this.tabPane.getTabCount();
        int n7 = this.getRunForTab(n6, n);
        int n8 = this.lastTabInRun(n6, n7);
        int n9 = this.tabRuns[n7];
        Color color = this.getLoBorderColor(n);
        Color color2 = this.getHiBorderColor(n);
        if (bl) {
            graphics.setColor(this.getSelectedBorderColor(n));
        } else {
            graphics.setColor(color);
        }
        graphics.drawLine(n2, n3, n4 - 5, n3);
        graphics.drawLine(n4 - 5, n3, n4, n3 + 5);
        graphics.drawLine(n4, n3 + 5, n4, n5);
        if (bl && n != n8) {
            graphics.drawLine(n4 - 5, n5, n2, n5);
        } else {
            graphics.drawLine(n4, n5, n2, n5);
        }
        graphics.setColor(color2);
        graphics.drawLine(n2 + 1, n3 + 1, n4 - 5, n3 + 1);
        graphics.drawLine(n4 - 5, n3 + 1, n4 - 1, n3 + 5);
        int n10 = this.getTabAtLocation(n2 + 2, n3 - 2);
        Color color3 = this.getGapColor(n10);
        graphics.setColor(color3);
        for (int i = 0; i < 5; ++i) {
            graphics.drawLine(n4 - 5 + i + 1, n3 + i, n4, n3 + i);
        }
        if (n != n9 || n7 != this.runCount - 1) {
            graphics.setColor(color);
            graphics.drawLine(n4, n3, n4, n3 + 5);
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color[] colorArray = this.getTabColors(n2, bl);
        switch (n) {
            default: {
                if (bl) {
                    JTattooUtilities.fillHorGradient(graphics, colorArray, n3 + 1, n4 + 1, n5 - 1, n6);
                    break;
                }
                JTattooUtilities.fillHorGradient(graphics, colorArray, n3 + 1, n4 + 1, n5 - 1, n6 - 1);
                break;
            }
            case 2: {
                if (bl) {
                    JTattooUtilities.fillHorGradient(graphics, colorArray, n3 + 1, n4 + 1, n5, n6 - 1);
                    break;
                }
                JTattooUtilities.fillHorGradient(graphics, colorArray, n3 + 1, n4 + 1, n5 - 1, n6 - 1);
                break;
            }
            case 3: {
                if (bl) {
                    JTattooUtilities.fillHorGradient(graphics, colorArray, n3 + 1, n4 - 1, n5 - 1, n6);
                    break;
                }
                JTattooUtilities.fillHorGradient(graphics, colorArray, n3 + 1, n4, n5 - 1, n6 - 1);
                break;
            }
            case 4: {
                if (bl) {
                    JTattooUtilities.fillHorGradient(graphics, colorArray, n3, n4 + 1, n5, n6 - 1);
                    break;
                }
                JTattooUtilities.fillHorGradient(graphics, colorArray, n3 + 1, n4 + 1, n5 - 1, n6 - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.tabAreaInsets.bottom;
        graphics.setColor(this.tabAreaBackground);
        graphics.fillRect(0, 0, this.tabPane.getWidth(), this.tabPane.getHeight());
        if (n7 > 0) {
            int n8 = this.tabPane.getBorder() != null ? 1 : 0;
            switch (n) {
                case 1: {
                    int n9 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                    if (n7 > 1) {
                        Color[] colorArray = this.getContentBorderColors(n);
                        for (int i = 0; i < colorArray.length; ++i) {
                            graphics.setColor(colorArray[i]);
                            graphics.drawLine(n3, n4 + n9 - n7 + i + n8, n3 + n5, n4 + n9 - n7 + i + n8);
                        }
                    } else {
                        graphics.setColor(this.getContentBorderColors(n)[0]);
                        graphics.drawLine(n3, n4 + n9, n5, n4 + n9);
                    }
                    if (this.tabPane.getBorder() == null) break;
                    graphics.setColor(this.getContentBorderColor());
                    graphics.drawRect(n3, n4 + n9, n3 + n5 - 1, n6 - n9 - 1);
                    break;
                }
                case 2: {
                    int n10 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                    if (n7 > 1) {
                        Color[] colorArray = this.getContentBorderColors(n);
                        for (int i = 0; i < colorArray.length; ++i) {
                            graphics.setColor(colorArray[i]);
                            graphics.drawLine(n3 + n10 - n7 + i + n8, n4, n3 + n10 - n7 + i + n8, n4 + n6);
                        }
                    } else {
                        graphics.setColor(this.getContentBorderColors(n)[0]);
                        graphics.drawLine(n3 + n10, n4, n3 + n10, n6);
                    }
                    if (this.tabPane.getBorder() == null) break;
                    graphics.setColor(this.getContentBorderColor());
                    graphics.drawRect(n3 + n10, n4, n5 - n10 - 1, n4 + n6 - 1);
                    break;
                }
                case 3: {
                    int n11 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                    if (n7 > 1) {
                        Color[] colorArray = this.getContentBorderColors(n);
                        for (int i = 0; i < colorArray.length; ++i) {
                            graphics.setColor(colorArray[i]);
                            graphics.drawLine(n3, n4 + n6 - n11 + i, n3 + n5, n4 + n6 - n11 + i);
                        }
                    } else {
                        graphics.setColor(this.getContentBorderColors(n)[0]);
                        graphics.drawLine(n3, n4 + n6 - n11, n5, n4 + n6 - n11);
                    }
                    if (this.tabPane.getBorder() == null) break;
                    graphics.setColor(this.getContentBorderColor());
                    graphics.drawRect(n3, n4, n3 + n5 - 1, n6 - n11);
                    break;
                }
                case 4: {
                    int n12 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                    if (n7 > 1) {
                        Color[] colorArray = this.getContentBorderColors(n);
                        for (int i = 0; i < colorArray.length; ++i) {
                            graphics.setColor(colorArray[i]);
                            graphics.drawLine(n3 + n5 - n12 + i + 1 - n8, n4, n3 + n5 - n12 + i + 1 - n8, n4 + n6);
                        }
                    } else {
                        graphics.setColor(this.getContentBorderColors(n)[0]);
                        graphics.drawLine(n3 + n5 - n12, n4, n3 + n5 - n12, n6);
                    }
                    if (this.tabPane.getBorder() == null) break;
                    graphics.setColor(this.getContentBorderColor());
                    graphics.drawRect(n3, n4, n5 - n12, n4 + n6 - 1);
                    break;
                }
            }
        }
    }

    protected void paintScrollContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.tabPane.getBorder() != null) {
            insets = this.tabPane.getBorder().getBorderInsets(this.tabPane);
        }
        if (this.tabPane.getTabPlacement() == 1) {
            this.paintContentBorder(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex(), n3, n4 - insets.top, n5, n6);
        } else if (this.tabPane.getTabPlacement() == 3) {
            this.paintContentBorder(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex(), n3, n4 + insets.bottom, n5, n6);
        } else if (this.tabPane.getTabPlacement() == 2) {
            this.paintContentBorder(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex(), n3 - insets.left, n4, n5, n6);
        } else if (this.tabPane.getTabPlacement() == 4) {
            this.paintContentBorder(graphics, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex(), n3 + insets.right, n4, n5, n6);
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n, rectangle);
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        Point point = new Point(n, n2);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n, n2, point);
        }
        int n3 = this.tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(point.x, point.y)) continue;
            return i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.width = this.rects[n].width;
        rectangle.height = this.rects[n].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n].x + point.x - point2.x;
            rectangle.y = this.rects[n].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n].x;
            rectangle.y = this.rects[n].y;
        }
        return rectangle;
    }

    protected int getTabAtLocation(int n, int n2) {
        this.ensureCurrentLayout();
        int n3 = this.tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    protected int getClosestTab(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = n4 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n7 = this.tabPane.getTabPlacement();
        boolean bl = n7 == 1 || n7 == 3;
        int n8 = n3 = bl ? n : n2;
        while (n5 != n6) {
            int n9;
            int n10;
            int n11 = (n6 + n5) / 2;
            if (bl) {
                n10 = this.rects[n11].x;
                n9 = n10 + this.rects[n11].width;
            } else {
                n10 = this.rects[n11].y;
                n9 = n10 + this.rects[n11].height;
            }
            if (n3 < n10) {
                n6 = n11;
                if (n5 != n6) continue;
                return Math.max(0, n11 - 1);
            }
            if (n3 >= n9) {
                n5 = n11;
                if (n6 - n5 > 1) continue;
                return Math.max(n11 + 1, n4 - 1);
            }
            return n11;
        }
        return n5;
    }

    private Point translatePointToTabPanel(int n, int n2, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n - point2.x + point3.x;
        point.y = n2 - point2.y + point3.y;
        return point;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n) {
        int n2 = this.rects.length;
        if (n != n2) {
            Rectangle[] rectangleArray = new Rectangle[n];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n2, n));
            this.rects = rectangleArray;
            for (int i = n2; i < n; ++i) {
                this.rects[i] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int n = this.tabRuns.length;
        int[] nArray = new int[n + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    protected int getRunForTab(int n, int n2) {
        for (int i = 0; i < this.runCount; ++i) {
            int n3 = this.tabRuns[i];
            int n4 = this.lastTabInRun(n, i);
            if (n2 < n3 || n2 > n4) continue;
            return i;
        }
        return 0;
    }

    protected int lastTabInRun(int n, int n2) {
        int n3;
        if (this.runCount == 1) {
            return n - 1;
        }
        int n4 = n3 = n2 == this.runCount - 1 ? 0 : n2 + 1;
        if (this.tabRuns[n3] == 0) {
            return n - 1;
        }
        return this.tabRuns[n3] - 1;
    }

    protected int getTabRunOverlay(int n) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected Icon getIconForTab(int n) {
        if (n >= 0 && n < this.tabCount) {
            return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n) ? this.tabPane.getDisabledIconAt(n) : this.tabPane.getIconAt(n);
        }
        return null;
    }

    protected View getTextViewForTab(int n) {
        if (this.htmlViews != null && this.htmlViews.size() > n) {
            return (View)this.htmlViews.elementAt(n);
        }
        return null;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        Object object;
        int n4 = 0;
        Component component = null;
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            component = this.tabPane.getTabComponentAt(n2);
        }
        if (component != null) {
            n4 = component.getPreferredSize().height;
        } else {
            object = this.getTextViewForTab(n2);
            n4 = object != null ? (n4 += (int)((View)object).getPreferredSpan(1)) : (n4 += n3);
            Icon icon = this.getIconForTab(n2);
            if (icon != null) {
                n4 = Math.max(n4, icon.getIconHeight());
            }
        }
        object = this.getTabInsets(n, n2);
        return n4 += ((Insets)object).top + ((Insets)object).bottom + 2;
    }

    protected int calculateMaxTabHeight(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        int n4 = fontMetrics.getHeight();
        for (int i = 0; i < n2; ++i) {
            n3 = Math.max(this.calculateTabHeight(n, i, n4), n3);
        }
        return n3;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        Insets insets = this.getTabInsets(n, n2);
        int n3 = insets.left + insets.right + 3;
        Component component = null;
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            component = this.tabPane.getTabComponentAt(n2);
        }
        if (component != null) {
            n3 += component.getPreferredSize().width;
        } else {
            View view;
            Icon icon = this.getIconForTab(n2);
            if (icon != null) {
                n3 += icon.getIconWidth() + this.textIconGap;
            }
            if ((view = this.getTextViewForTab(n2)) != null) {
                n3 += (int)view.getPreferredSpan(0);
            } else {
                String string = this.tabPane.getTitleAt(n2);
                n3 += SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        return n3;
    }

    protected int calculateMaxTabWidth(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = this.tabPane.getTabCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = Math.max(this.calculateTabWidth(n, i, fontMetrics), n3);
        }
        return n3;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        if (n == 1 || n == 3) {
            Insets insets = this.getTabAreaInsets(n);
            int n4 = this.getTabRunOverlay(n);
            return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.top + insets.bottom : 0;
        }
        return this.tabPane.getHeight();
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        if (n == 2 || n == 4) {
            Insets insets = this.getTabAreaInsets(n);
            int n4 = this.getTabRunOverlay(n);
            return n2 > 0 ? n2 * (n3 - n4) + n4 + insets.left + insets.right : 0;
        }
        return this.tabPane.getWidth();
    }

    protected Insets getTabInsets(int n, int n2) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        BaseTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, n);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n) {
        BaseTabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, n);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int n) {
        if (this.tabPane.getBorder() == null) {
            return NULL_BORDER_INSETS;
        }
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont().deriveFont(1);
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n) {
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getSelectedIndex();
        int n4 = this.tabPane.getTabCount();
        boolean bl = JTattooUtilities.isLeftToRight(this.tabPane);
        if (n4 <= 0) {
            return;
        }
        block0 : switch (n2) {
            case 12: {
                this.selectNextTab(n3);
                break;
            }
            case 13: {
                this.selectPreviousTab(n3);
                break;
            }
            case 2: 
            case 4: {
                switch (n) {
                    case 1: {
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        int n5 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n5);
                        break block0;
                    }
                    case 3: {
                        int n6 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n6);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n) {
                    case 1: {
                        int n7 = this.getTabRunOffset(n2, n4, n3, false);
                        this.selectAdjacentRunTab(n2, n3, n7);
                        break block0;
                    }
                    case 5: {
                        int n8 = this.getTabRunOffset(n2, n4, n3, true);
                        this.selectAdjacentRunTab(n2, n3, n8);
                        break block0;
                    }
                    case 3: {
                        if (bl) {
                            this.selectNextTabInRun(n3);
                            break block0;
                        }
                        this.selectPreviousTabInRun(n3);
                        break block0;
                    }
                    case 7: {
                        if (bl) {
                            this.selectPreviousTabInRun(n3);
                            break block0;
                        }
                        this.selectNextTabInRun(n3);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int n) {
        int n2 = this.tabPane.getTabCount();
        int n3 = this.getNextTabIndexInRun(n2, n);
        while (n3 != n && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndexInRun(n2, n3);
        }
        this.tabPane.setSelectedIndex(n3);
    }

    protected void selectPreviousTabInRun(int n) {
        int n2 = this.tabPane.getTabCount();
        int n3 = this.getPreviousTabIndexInRun(n2, n);
        while (n3 != n && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndexInRun(n2, n3);
        }
        this.tabPane.setSelectedIndex(n3);
    }

    protected void selectNextTab(int n) {
        int n2 = this.getNextTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getNextTabIndex(n2);
        }
        this.tabPane.setSelectedIndex(n2);
    }

    protected void selectPreviousTab(int n) {
        int n2 = this.getPreviousTabIndex(n);
        while (n2 != n && !this.tabPane.isEnabledAt(n2)) {
            n2 = this.getPreviousTabIndex(n2);
        }
        this.tabPane.setSelectedIndex(n2);
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n2];
        switch (n) {
            case 2: 
            case 4: {
                n4 = this.getTabAtLocation(rectangle.x + rectangle.width / 2 + n3, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n4 = this.getTabAtLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n3);
            }
        }
        if (n4 != -1) {
            while (!this.tabPane.isEnabledAt(n4) && n4 != n2) {
                n4 = this.getNextTabIndex(n4);
            }
            this.tabPane.setSelectedIndex(n4);
        }
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.getRunForTab(n2, n3);
        switch (n) {
            case 2: {
                if (n5 == 0) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabWidth : this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n4 = bl ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n5 == 0) {
                    n4 = bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n5 == this.runCount - 1) {
                    n4 = bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n4 = bl ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n4 = n5 == 0 ? (bl ? -(this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n5 == this.runCount - 1 ? (bl ? this.maxTabHeight : this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n4;
    }

    protected int getPreviousTabIndex(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.tabPane.getTabCount() - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabIndex(int n) {
        return (n + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        int n4 = this.getNextTabIndex(n2);
        if (n4 == this.tabRuns[this.getNextTabRun(n3)]) {
            return this.tabRuns[n3];
        }
        return n4;
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(n2);
        }
        int n3 = this.getRunForTab(n, n2);
        if (n2 == this.tabRuns[n3]) {
            int n4 = this.tabRuns[this.getNextTabRun(n3)] - 1;
            return n4 != -1 ? n4 : n - 1;
        }
        return this.getPreviousTabIndex(n2);
    }

    protected int getPreviousTabRun(int n) {
        int n2 = n - 1 >= 0 ? n - 1 : this.runCount - 1;
        return n2 >= 0 ? n2 : 0;
    }

    protected int getNextTabRun(int n) {
        return (n + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    protected boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector<View> vector = new Vector<View>();
        int n = this.tabPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            String string = this.tabPane.getTitleAt(i);
            if (BasicHTML.isHTMLString(string)) {
                vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                continue;
            }
            vector.addElement(null);
        }
        return vector;
    }

    private class TabContainer
    extends JPanel
    implements UIResource {
        private boolean notifyTabbedPane = true;

        public TabContainer() {
            super(null);
            this.setOpaque(false);
        }

        public void remove(Component component) {
            int n = BaseTabbedPaneUI.this.tabPane.indexOfTabComponent(component);
            super.remove(component);
            if (this.notifyTabbedPane && n != -1) {
                BaseTabbedPaneUI.this.tabPane.setTabComponentAt(n, null);
            }
        }

        private void removeUnusedTabComponents() {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                int n;
                Component component = this.getComponent(i);
                if (component instanceof UIResource || (n = BaseTabbedPaneUI.this.tabPane.indexOfTabComponent(component)) != -1) continue;
                super.remove(component);
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)jTabbedPane.getLayout();
            tabbedPaneLayout.layoutContainer(jTabbedPane);
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n = jTabbedPane.indexOfComponent(component);
            String string = jTabbedPane.getTitleAt(n);
            boolean bl = BasicHTML.isHTMLString(string);
            if (bl) {
                if (BaseTabbedPaneUI.this.htmlViews == null) {
                    BaseTabbedPaneUI.this.htmlViews = BaseTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    BaseTabbedPaneUI.this.htmlViews.insertElementAt(view, n);
                }
            } else if (BaseTabbedPaneUI.this.htmlViews != null) {
                BaseTabbedPaneUI.this.htmlViews.insertElementAt(null, n);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            Integer n = (Integer)jTabbedPane.getClientProperty("__index_to_remove__");
            if (n != null) {
                int n2 = n;
                if (BaseTabbedPaneUI.this.htmlViews != null && BaseTabbedPaneUI.this.htmlViews.size() >= n2) {
                    BaseTabbedPaneUI.this.htmlViews.removeElementAt(n2);
                }
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == BaseTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BaseTabbedPaneUI.this.getTabBounds(jTabbedPane, n2));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == BaseTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BaseTabbedPaneUI.this.getTabBounds(jTabbedPane, n2));
            }
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseMotionListener[] mouseMotionListenerArray = BaseTabbedPaneUI.this.tabPane.getMouseMotionListeners();
                for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                    mouseMotionListenerArray[i].mouseDragged(mouseEvent);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseMotionListener[] mouseMotionListenerArray = BaseTabbedPaneUI.this.tabPane.getMouseMotionListeners();
                for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                    mouseMotionListenerArray[i].mouseMoved(mouseEvent);
                }
            }
            BaseTabbedPaneUI.this.rolloverIndex = BaseTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (BaseTabbedPaneUI.this.rolloverIndex != BaseTabbedPaneUI.this.oldRolloverIndex) {
                if (BaseTabbedPaneUI.this.oldRolloverIndex >= 0 && BaseTabbedPaneUI.this.oldRolloverIndex < BaseTabbedPaneUI.this.tabPane.getTabCount()) {
                    BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, BaseTabbedPaneUI.this.oldRolloverIndex));
                }
                if (BaseTabbedPaneUI.this.rolloverIndex >= 0 && BaseTabbedPaneUI.this.rolloverIndex < BaseTabbedPaneUI.this.tabPane.getTabCount()) {
                    BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, BaseTabbedPaneUI.this.rolloverIndex));
                }
                BaseTabbedPaneUI.this.oldRolloverIndex = BaseTabbedPaneUI.this.rolloverIndex;
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] mouseListenerArray = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    mouseListenerArray[i].mouseClicked(mouseEvent);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] mouseListenerArray = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    mouseListenerArray[i].mousePressed(mouseEvent);
                }
            }
            if (!BaseTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = BaseTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && BaseTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                if (n == BaseTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (BaseTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        BaseTabbedPaneUI.this.tabPane.requestFocus();
                        BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, n));
                    }
                } else {
                    BaseTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] mouseListenerArray = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    mouseListenerArray[i].mouseReleased(mouseEvent);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] mouseListenerArray = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    mouseListenerArray[i].mouseEntered(mouseEvent);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                MouseListener[] mouseListenerArray = BaseTabbedPaneUI.this.tabPane.getMouseListeners();
                for (int i = 0; i < mouseListenerArray.length; ++i) {
                    mouseListenerArray[i].mouseExited(mouseEvent);
                }
            }
            BaseTabbedPaneUI.this.rolloverIndex = -1;
            if (BaseTabbedPaneUI.this.rolloverIndex != BaseTabbedPaneUI.this.oldRolloverIndex) {
                if (BaseTabbedPaneUI.this.oldRolloverIndex >= 0 && BaseTabbedPaneUI.this.oldRolloverIndex < BaseTabbedPaneUI.this.tabPane.getTabCount()) {
                    BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, BaseTabbedPaneUI.this.oldRolloverIndex));
                }
                if (BaseTabbedPaneUI.this.rolloverIndex >= 0 && BaseTabbedPaneUI.this.rolloverIndex < BaseTabbedPaneUI.this.tabPane.getTabCount()) {
                    BaseTabbedPaneUI.this.tabPane.repaint(BaseTabbedPaneUI.this.getTabBounds(BaseTabbedPaneUI.this.tabPane, BaseTabbedPaneUI.this.rolloverIndex));
                }
                BaseTabbedPaneUI.this.oldRolloverIndex = BaseTabbedPaneUI.this.rolloverIndex;
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            if (JTattooUtilities.getJavaVersion() >= 1.4 && jTabbedPane.getTabLayoutPolicy() == 1 && (n = jTabbedPane.getSelectedIndex()) >= 0) {
                BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
                baseTabbedPaneUI.tabScroller.scrollTabToVisible(jTabbedPane.getTabPlacement(), n);
            }
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            boolean bl = BaseTabbedPaneUI.this.scrollableTabLayoutEnabled();
            if ("mnemonicAt".equals(string)) {
                BaseTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(string)) {
                jTabbedPane.repaint();
            } else if ("indexForTitle".equals(string)) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                String string2 = BaseTabbedPaneUI.this.tabPane.getTitleAt(n);
                if (BasicHTML.isHTMLString(string2)) {
                    if (BaseTabbedPaneUI.this.htmlViews == null) {
                        BaseTabbedPaneUI.this.htmlViews = BaseTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View view = BasicHTML.createHTMLView(BaseTabbedPaneUI.this.tabPane, string2);
                        BaseTabbedPaneUI.this.htmlViews.setElementAt(view, n);
                    }
                } else if (BaseTabbedPaneUI.this.htmlViews != null && BaseTabbedPaneUI.this.htmlViews.elementAt(n) != null) {
                    BaseTabbedPaneUI.this.htmlViews.setElementAt(null, n);
                }
                BaseTabbedPaneUI.this.updateMnemonics();
            } else if ("tabLayoutPolicy".equals(string)) {
                BaseTabbedPaneUI.this.uninstallUI(jTabbedPane);
                BaseTabbedPaneUI.this.installUI(jTabbedPane);
            } else if ("opaque".equals(string) && bl) {
                boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.tabPanel.setOpaque(bl2);
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.viewport.setOpaque(bl2);
            } else if ("background".equals(string) && bl) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.tabPanel.setBackground(color);
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.viewport.setBackground(color);
                Color color2 = BaseTabbedPaneUI.this.selectedColor == null ? color : BaseTabbedPaneUI.this.selectedColor;
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.scrollForwardButton.setBackground(color2);
                ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.scrollBackwardButton.setBackground(color2);
            } else if ("indexForTabComponent".equals(string)) {
                if (BaseTabbedPaneUI.this.tabContainer != null) {
                    BaseTabbedPaneUI.this.tabContainer.removeUnusedTabComponents();
                }
                try {
                    Component component = BaseTabbedPaneUI.this.tabPane.getTabComponentAt((Integer)propertyChangeEvent.getNewValue());
                    if (component != null) {
                        if (BaseTabbedPaneUI.this.tabContainer == null) {
                            BaseTabbedPaneUI.this.installTabContainer();
                        } else {
                            BaseTabbedPaneUI.this.tabContainer.add(component);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BaseTabbedPaneUI.this.tabPane.revalidate();
                BaseTabbedPaneUI.this.tabPane.repaint();
            } else if ("componentOrientation".equals(string)) {
                jTabbedPane.revalidate();
                jTabbedPane.repaint();
            } else if ("tabAreaBackground".equals(string)) {
                BaseTabbedPaneUI.this.tabAreaBackground = (Color)propertyChangeEvent.getNewValue();
                jTabbedPane.revalidate();
                jTabbedPane.repaint();
            }
        }
    }

    private class ScrollablePopupMenuTabButton
    extends ArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollablePopupMenuTabButton() {
            super(5);
        }
    }

    private class ScrollableTabButton
    extends ArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n) {
            super(n);
        }

        public boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }
    }

    public class ArrowButton
    extends JButton
    implements SwingConstants {
        protected int direction;

        public ArrowButton(int n) {
            this.setRequestFocusEnabled(false);
            this.setDirection(n);
            if (BaseTabbedPaneUI.this.simpleButtonBorder) {
                this.setBorder(BorderFactory.createEtchedBorder(AbstractLookAndFeel.getControlHighlight(), AbstractLookAndFeel.getControlDarkShadow()));
            }
        }

        public int getDirection() {
            return this.direction;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
            n3 = Math.max(n3, 2);
            this.paintTriangle(graphics, (n - n3) / 2 + 1, (n2 - n3) / 2 + 1, n3);
        }

        public Dimension getPreferredSize() {
            return new Dimension(17, 17);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paintTriangle(Graphics graphics, int n, int n2, int n3) {
            Color color = graphics.getColor();
            int n4 = 0;
            n3 = Math.max(n3, 2);
            int n5 = n3 / 2 - 1;
            Color color2 = Color.black;
            Color color3 = new Color(200, 200, 200);
            graphics.translate(n, n2);
            if (this.isEnabled()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color3);
            }
            switch (this.direction) {
                case 1: {
                    int n6;
                    for (n6 = 0; n6 < n3; ++n6) {
                        graphics.drawLine(n5 - n6, n6, n5 + n6, n6);
                    }
                    if (this.isEnabled()) break;
                    graphics.setColor(Color.white);
                    graphics.drawLine(n5 - n6 + 2, n6, n5 + n6, n6);
                    break;
                }
                case 5: {
                    int n7;
                    if (!this.isEnabled()) {
                        graphics.translate(1, 1);
                        graphics.setColor(Color.white);
                        for (n7 = n3 - 1; n7 >= 0; --n7) {
                            graphics.drawLine(n5 - n7, n4, n5 + n7, n4);
                            ++n4;
                        }
                        graphics.translate(-1, -1);
                        graphics.setColor(color3);
                    }
                    n4 = 0;
                    for (n7 = n3 - 1; n7 >= 0; --n7) {
                        graphics.drawLine(n5 - n7, n4, n5 + n7, n4);
                        ++n4;
                    }
                    break;
                }
                case 7: {
                    int n8;
                    for (n8 = 0; n8 < n3; ++n8) {
                        graphics.drawLine(n8, n5 - n8, n8, n5 + n8);
                    }
                    if (this.isEnabled()) break;
                    graphics.setColor(Color.white);
                    graphics.drawLine(n8, n5 - n8 + 2, n8, n5 + n8);
                    break;
                }
                case 3: {
                    int n9;
                    if (!this.isEnabled()) {
                        graphics.translate(1, 1);
                        graphics.setColor(Color.white);
                        for (n9 = n3 - 1; n9 >= 0; --n9) {
                            graphics.drawLine(n4, n5 - n9, n4, n5 + n9);
                            ++n4;
                        }
                        graphics.translate(-1, -1);
                        graphics.setColor(color3);
                    }
                    n4 = 0;
                    for (n9 = n3 - 1; n9 >= 0; --n9) {
                        graphics.drawLine(n4, n5 - n9, n4, n5 + n9);
                        ++n4;
                    }
                    break;
                }
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            BaseTabbedPaneUI.this.paintScrollContentBorder(graphics, BaseTabbedPaneUI.this.tabPane.getTabPlacement(), BaseTabbedPaneUI.this.tabPane.getSelectedIndex(), 0, 0, this.getWidth(), this.getHeight());
            BaseTabbedPaneUI.this.paintTabArea(graphics, BaseTabbedPaneUI.this.tabPane.getTabPlacement(), BaseTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        public void doLayout() {
            if (this.getComponentCount() > 0) {
                Component component = this.getComponent(0);
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setScrollMode(0);
        }
    }

    private class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public ScrollablePopupMenuTabButton popupMenuButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            if (n == 1 || n == 3) {
                this.scrollForwardButton = new ScrollableTabButton(3);
                this.scrollBackwardButton = new ScrollableTabButton(7);
            } else {
                this.scrollForwardButton = new ScrollableTabButton(5);
                this.scrollBackwardButton = new ScrollableTabButton(1);
            }
            this.popupMenuButton = new ScrollablePopupMenuTabButton();
        }

        public void scrollForward(int n) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n == 1 || n == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n, this.leadingTabIndex - 1);
        }

        public void scrollTabToVisible(int n, int n2) {
            if (n2 <= this.leadingTabIndex) {
                this.setLeadingTabIndex(n, n2);
            } else {
                Dimension dimension = this.viewport.getViewSize();
                Rectangle rectangle = this.viewport.getViewRect();
                switch (n) {
                    case 1: 
                    case 3: {
                        int n3 = n2;
                        int n4 = rectangle.width - BaseTabbedPaneUI.this.rects[n2].width;
                        while (n3 > 0 && n4 - BaseTabbedPaneUI.this.rects[n3 - 1].width > 0) {
                            n4 -= BaseTabbedPaneUI.this.rects[--n3].width;
                        }
                        if (this.leadingTabIndex >= n3) break;
                        this.setLeadingTabIndex(n, n3);
                        break;
                    }
                    case 2: 
                    case 4: {
                        int n5 = n2;
                        int n6 = rectangle.height - BaseTabbedPaneUI.this.rects[n2].height;
                        while (n5 > 0 && n6 - BaseTabbedPaneUI.this.rects[n5 - 1].height > 0) {
                            n6 -= BaseTabbedPaneUI.this.rects[--n5].height;
                        }
                        if (this.leadingTabIndex >= n5) break;
                        this.setLeadingTabIndex(n, n5);
                        break;
                    }
                }
            }
        }

        public void setLeadingTabIndex(int n, int n2) {
            this.leadingTabIndex = n2;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n) {
                case 1: 
                case 3: {
                    int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BaseTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n4 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BaseTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = BaseTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = BaseTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex >= BaseTabbedPaneUI.this.rects.length) {
                return;
            }
            if (this.leadingTabIndex + 1 < n2) {
                switch (n) {
                    case 1: 
                    case 3: {
                        if (BaseTabbedPaneUI.this.rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BaseTabbedPaneUI.this.rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = BaseTabbedPaneUI.this.getContentBorderInsets(n);
            switch (n) {
                case 2: {
                    BaseTabbedPaneUI.this.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    BaseTabbedPaneUI.this.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    BaseTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    BaseTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            return BaseTabbedPaneUI.this.calculateMaxTabHeight(n);
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            return BaseTabbedPaneUI.this.calculateMaxTabWidth(n);
        }

        public void layoutContainer(Container container) {
            int n = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
            int n2 = BaseTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            int n3 = BaseTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BaseTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component component2 = null;
            if (n3 < 0) {
                if (component != null) {
                    BaseTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                try {
                    component2 = BaseTabbedPaneUI.this.tabPane.getComponentAt(n3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl = false;
            if (component2 != null) {
                if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                    bl = true;
                }
                BaseTabbedPaneUI.this.setVisibleComponent(component2);
            }
            Insets insets2 = BaseTabbedPaneUI.this.getContentBorderInsets(n);
            Rectangle rectangle = BaseTabbedPaneUI.this.tabPane.getBounds();
            int n4 = BaseTabbedPaneUI.this.tabPane.getComponentCount();
            int n5 = 60;
            if (n4 > 0 && n2 > 0) {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                switch (n) {
                    case 2: {
                        n13 = BaseTabbedPaneUI.this.calculateTabAreaWidth(n, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabWidth);
                        n12 = rectangle.height - insets.top - insets.bottom;
                        n11 = insets.left;
                        n10 = insets.top;
                        n9 = n11 + n13 + insets2.left;
                        n8 = n10 + insets2.top;
                        n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                        n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                        break;
                    }
                    case 4: {
                        n13 = BaseTabbedPaneUI.this.calculateTabAreaWidth(n, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabWidth);
                        n12 = rectangle.height - insets.top - insets.bottom;
                        n11 = rectangle.width - insets.right - n13;
                        n10 = insets.top;
                        n9 = insets.left + insets2.left;
                        n8 = insets.top + insets2.top;
                        n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                        n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                        break;
                    }
                    case 3: {
                        n13 = rectangle.width - insets.left - insets.right;
                        n12 = BaseTabbedPaneUI.this.calculateTabAreaHeight(n, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabHeight);
                        n11 = insets.left;
                        n10 = rectangle.height - insets.bottom - n12;
                        n9 = insets.left + insets2.left;
                        n8 = insets.top + insets2.top;
                        n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                        n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                        break;
                    }
                    default: {
                        n13 = rectangle.width - insets.left - insets.right;
                        n12 = BaseTabbedPaneUI.this.calculateTabAreaHeight(n, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabHeight);
                        n11 = insets.left;
                        n10 = insets.top;
                        n9 = n11 + insets2.left;
                        n8 = n10 + n12 + insets2.top;
                        n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                        n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                    }
                }
                for (int i = 0; i < n4; ++i) {
                    int n14;
                    int n15;
                    boolean bl2;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    Cloneable cloneable;
                    JComponent jComponent;
                    Component component3 = BaseTabbedPaneUI.this.tabPane.getComponent(i);
                    if (component3 instanceof ScrollableTabViewport) {
                        jComponent = (JViewport)component3;
                        cloneable = ((JViewport)jComponent).getViewRect();
                        n19 = n13;
                        n18 = n12;
                        switch (n) {
                            case 2: 
                            case 4: {
                                n17 = BaseTabbedPaneUI.this.rects[n2 - 1].y + BaseTabbedPaneUI.this.rects[n2 - 1].height;
                                if (n17 <= n12 || n17 - cloneable.y > (n18 = Math.max(n12 - n5, n5))) break;
                                n18 = n17 - cloneable.y;
                                break;
                            }
                            default: {
                                n16 = BaseTabbedPaneUI.this.rects[n2 - 1].x + BaseTabbedPaneUI.this.rects[n2 - 1].width;
                                if (n16 <= n13 || n16 - cloneable.x > (n19 = Math.max(n13 - n5, n5))) break;
                                n19 = n16 - cloneable.x;
                            }
                        }
                        component3.setBounds(n11, n10, n19, n18);
                        continue;
                    }
                    if (component3 instanceof ScrollableTabButton) {
                        jComponent = (ScrollableTabButton)component3;
                        cloneable = ((ArrowButton)jComponent).getPreferredSize();
                        n19 = 0;
                        n18 = 0;
                        n17 = ((Dimension)cloneable).width;
                        n16 = ((Dimension)cloneable).height;
                        bl2 = false;
                        switch (n) {
                            case 2: 
                            case 4: {
                                n15 = BaseTabbedPaneUI.this.rects[n2 - 1].y + BaseTabbedPaneUI.this.rects[n2 - 1].height;
                                if (n15 <= n12) break;
                                n14 = ((ScrollableTabButton)jComponent).scrollsForward() ? 5 : 1;
                                ((ArrowButton)jComponent).setDirection(n14);
                                bl2 = true;
                                n19 = n == 2 ? n13 - insets.left - BaseTabbedPaneUI.this.tabAreaInsets.bottom - ((Dimension)cloneable).width : rectangle.width - insets.left - ((Dimension)cloneable).width;
                                n18 = n14 == 5 ? rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height - 2 : rectangle.height - insets.bottom - 3 * ((Dimension)cloneable).height - 2;
                                break;
                            }
                            default: {
                                n14 = BaseTabbedPaneUI.this.rects[n2 - 1].x + BaseTabbedPaneUI.this.rects[n2 - 1].width;
                                if (n14 <= n13) break;
                                int n20 = ((ScrollableTabButton)jComponent).scrollsForward() ? 3 : 7;
                                ((ArrowButton)jComponent).setDirection(n20);
                                bl2 = true;
                                n19 = n20 == 3 ? rectangle.width - insets.left - 2 * ((Dimension)cloneable).width - 2 : rectangle.width - insets.left - 3 * ((Dimension)cloneable).width - 2;
                                n18 = n10 + (n12 - ((Dimension)cloneable).height - BaseTabbedPaneUI.this.tabAreaInsets.bottom) / 2;
                                if (n == 3) {
                                    n18 += BaseTabbedPaneUI.this.tabAreaInsets.bottom;
                                    break;
                                }
                                ++n18;
                            }
                        }
                        component3.setVisible(bl2);
                        if (!bl2) continue;
                        component3.setBounds(n19, n18, n17, n16);
                        continue;
                    }
                    if (component3 instanceof ScrollablePopupMenuTabButton) {
                        jComponent = (ScrollablePopupMenuTabButton)component3;
                        cloneable = ((ArrowButton)jComponent).getPreferredSize();
                        n19 = 0;
                        n18 = 0;
                        n17 = ((Dimension)cloneable).width;
                        n16 = ((Dimension)cloneable).height;
                        bl2 = false;
                        switch (n) {
                            case 2: 
                            case 4: {
                                n15 = BaseTabbedPaneUI.this.rects[n2 - 1].y + BaseTabbedPaneUI.this.rects[n2 - 1].height;
                                if (n15 <= n12) break;
                                bl2 = true;
                                n19 = n == 2 ? n13 - insets.left - BaseTabbedPaneUI.this.tabAreaInsets.bottom - ((Dimension)cloneable).width : rectangle.width - insets.left - ((Dimension)cloneable).width;
                                n18 = rectangle.height - insets.bottom - ((Dimension)cloneable).height;
                                break;
                            }
                            default: {
                                n14 = BaseTabbedPaneUI.this.rects[n2 - 1].x + BaseTabbedPaneUI.this.rects[n2 - 1].width;
                                if (n14 <= n13) break;
                                bl2 = true;
                                n19 = rectangle.width - insets.left - ((Dimension)cloneable).width;
                                n18 = n10 + (n12 - ((Dimension)cloneable).height - BaseTabbedPaneUI.this.tabAreaInsets.bottom) / 2;
                                if (n == 3) {
                                    n18 += BaseTabbedPaneUI.this.tabAreaInsets.bottom;
                                    break;
                                }
                                ++n18;
                            }
                        }
                        component3.setVisible(bl2);
                        if (!bl2) continue;
                        component3.setBounds(n19, n18, n17, n16);
                        continue;
                    }
                    component3.setBounds(n9, n8, n7, n6);
                }
                ((TabbedPaneLayout)this).layoutTabComponents();
                if (bl && !BaseTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BaseTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            FontMetrics fontMetrics = BaseTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BaseTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BaseTabbedPaneUI.this.getTabAreaInsets(n);
            int n4 = fontMetrics.getHeight();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = JTattooUtilities.isLeftToRight(BaseTabbedPaneUI.this.tabPane);
            int n5 = insets2.left;
            int n6 = insets2.top;
            int n7 = 0;
            int n8 = 0;
            switch (n) {
                case 2: 
                case 4: {
                    BaseTabbedPaneUI.this.maxTabWidth = BaseTabbedPaneUI.this.calculateMaxTabWidth(n);
                    break;
                }
                default: {
                    BaseTabbedPaneUI.this.maxTabHeight = BaseTabbedPaneUI.this.calculateMaxTabHeight(n);
                }
            }
            BaseTabbedPaneUI.this.runCount = 0;
            BaseTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            BaseTabbedPaneUI.this.selectedRun = 0;
            BaseTabbedPaneUI.this.runCount = 1;
            for (n3 = 0; n3 < n2; ++n3) {
                Rectangle rectangle = BaseTabbedPaneUI.this.rects[n3];
                if (!bl) {
                    if (n3 > 0) {
                        rectangle.x = BaseTabbedPaneUI.this.rects[n3 - 1].x + BaseTabbedPaneUI.this.rects[n3 - 1].width;
                    } else {
                        BaseTabbedPaneUI.this.tabRuns[0] = 0;
                        BaseTabbedPaneUI.this.maxTabWidth = 0;
                        n8 += BaseTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n5;
                    }
                    rectangle.width = BaseTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
                    n7 = rectangle.x + rectangle.width;
                    BaseTabbedPaneUI.this.maxTabWidth = Math.max(BaseTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n6;
                    rectangle.height = BaseTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (n3 > 0) {
                    rectangle.y = BaseTabbedPaneUI.this.rects[n3 - 1].y + BaseTabbedPaneUI.this.rects[n3 - 1].height;
                } else {
                    BaseTabbedPaneUI.this.tabRuns[0] = 0;
                    BaseTabbedPaneUI.this.maxTabHeight = 0;
                    n7 = BaseTabbedPaneUI.this.maxTabWidth;
                    rectangle.y = n6;
                }
                rectangle.height = BaseTabbedPaneUI.this.calculateTabHeight(n, n3, n4);
                n8 = rectangle.y + rectangle.height;
                BaseTabbedPaneUI.this.maxTabHeight = Math.max(BaseTabbedPaneUI.this.maxTabHeight, rectangle.height);
                rectangle.x = n5;
                rectangle.width = BaseTabbedPaneUI.this.maxTabWidth;
            }
            if (!bl2 && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                for (int i = 0; i < n2; ++i) {
                    BaseTabbedPaneUI.this.rects[i].x = n3 - BaseTabbedPaneUI.this.rects[i].x - BaseTabbedPaneUI.this.rects[i].width;
                }
            }
            ((BaseTabbedPaneUI)BaseTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(n7, n8));
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean bl) {
            int n;
            int n2 = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BaseTabbedPaneUI.this.getContentBorderInsets(n2);
            Insets insets3 = BaseTabbedPaneUI.this.getTabAreaInsets(n2);
            Dimension dimension = new Dimension(0, 0);
            int n3 = insets2.top + insets2.bottom;
            int n4 = insets2.left + insets2.right;
            int n5 = 0;
            int n6 = 0;
            for (n = 0; n < BaseTabbedPaneUI.this.tabPane.getTabCount(); ++n) {
                Component component = BaseTabbedPaneUI.this.tabPane.getComponentAt(n);
                if (component == null) continue;
                Dimension dimension2 = dimension;
                Dimension dimension3 = dimension2 = bl ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension2 == null) continue;
                n6 = Math.max(dimension2.height, n6);
                n5 = Math.max(dimension2.width, n5);
            }
            n4 += n5;
            n3 += n6;
            n = 0;
            switch (n2) {
                case 2: 
                case 4: {
                    n3 = Math.max(n3, BaseTabbedPaneUI.this.calculateMaxTabHeight(n2) + insets3.top + insets3.bottom);
                    n = this.preferredTabAreaWidth(n2, n3);
                    n4 += n;
                    break;
                }
                default: {
                    n4 = Math.max(n4, BaseTabbedPaneUI.this.calculateMaxTabWidth(n2) + insets3.left + insets3.right);
                    n = this.preferredTabAreaHeight(n2, n4);
                    n3 += n;
                }
            }
            return new Dimension(n4 + insets.left + insets.right, n3 + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            FontMetrics fontMetrics = BaseTabbedPaneUI.this.getFontMetrics();
            int n3 = BaseTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = BaseTabbedPaneUI.this.calculateMaxTabHeight(n);
                for (int i = 0; i < n3; ++i) {
                    int n8 = BaseTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                    if (n6 != 0 && n6 + n8 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n8;
                }
                n4 = BaseTabbedPaneUI.this.calculateTabAreaHeight(n, n5, n7);
            }
            return n4;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            FontMetrics fontMetrics = BaseTabbedPaneUI.this.getFontMetrics();
            int n3 = BaseTabbedPaneUI.this.tabPane.getTabCount();
            int n4 = 0;
            if (n3 > 0) {
                int n5 = 1;
                int n6 = 0;
                int n7 = fontMetrics.getHeight();
                BaseTabbedPaneUI.this.maxTabWidth = BaseTabbedPaneUI.this.calculateMaxTabWidth(n);
                for (int i = 0; i < n3; ++i) {
                    int n8 = BaseTabbedPaneUI.this.calculateTabHeight(n, i, n7);
                    if (n6 != 0 && n6 + n8 > n2) {
                        ++n5;
                        n6 = 0;
                    }
                    n6 += n8;
                }
                n4 = BaseTabbedPaneUI.this.calculateTabAreaWidth(n, n5, BaseTabbedPaneUI.this.maxTabWidth);
            }
            return n4;
        }

        public void layoutContainer(Container container) {
            int n = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            int n2 = BaseTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BaseTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component component2 = null;
            if (n2 < 0) {
                if (component != null) {
                    BaseTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                try {
                    component2 = BaseTabbedPaneUI.this.tabPane.getComponentAt(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n3 = 0;
            int n4 = 0;
            Insets insets2 = BaseTabbedPaneUI.this.getContentBorderInsets(n);
            boolean bl = false;
            if (component2 != null) {
                if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                    bl = true;
                }
                BaseTabbedPaneUI.this.setVisibleComponent(component2);
            }
            Rectangle rectangle = BaseTabbedPaneUI.this.tabPane.getBounds();
            int n5 = BaseTabbedPaneUI.this.tabPane.getComponentCount();
            if (n5 > 0) {
                int n6;
                int n7;
                switch (n) {
                    case 2: {
                        n3 = BaseTabbedPaneUI.this.calculateTabAreaWidth(n, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabWidth);
                        n7 = insets.left + n3 + insets2.left;
                        n6 = insets.top + insets2.top;
                        break;
                    }
                    case 4: {
                        n3 = BaseTabbedPaneUI.this.calculateTabAreaWidth(n, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabWidth);
                        n7 = insets.left + insets2.left;
                        n6 = insets.top + insets2.top;
                        break;
                    }
                    case 3: {
                        n4 = BaseTabbedPaneUI.this.calculateTabAreaHeight(n, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabHeight);
                        n7 = insets.left + insets2.left;
                        n6 = insets.top + insets2.top;
                        break;
                    }
                    default: {
                        n4 = BaseTabbedPaneUI.this.calculateTabAreaHeight(n, BaseTabbedPaneUI.this.runCount, BaseTabbedPaneUI.this.maxTabHeight);
                        n7 = insets.left + insets2.left;
                        n6 = insets.top + n4 + insets2.top;
                    }
                }
                int n8 = rectangle.width - n3 - insets.left - insets.right - insets2.left - insets2.right;
                int n9 = rectangle.height - n4 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                for (int i = 0; i < n5; ++i) {
                    Component component3 = BaseTabbedPaneUI.this.tabPane.getComponent(i);
                    if (component3 == BaseTabbedPaneUI.this.tabContainer) {
                        int n10 = n3 == 0 ? n8 : n3;
                        int n11 = n4 == 0 ? n9 : n4;
                        int n12 = 0;
                        int n13 = 0;
                        if (n == 3) {
                            n13 = rectangle.height - n11;
                        } else if (n == 4) {
                            n12 = rectangle.width - n10;
                        }
                        component3.setBounds(n12, n13, n10, n11);
                        continue;
                    }
                    component3.setBounds(n7, n6, n8, n9);
                }
            }
            this.layoutTabComponents();
            if (bl && !BaseTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                BaseTabbedPaneUI.this.tabPane.requestFocus();
            }
        }

        public void calculateLayoutInfo() {
            int n = BaseTabbedPaneUI.this.tabPane.getTabCount();
            BaseTabbedPaneUI.this.assureRectsCreated(n);
            this.calculateTabRects(BaseTabbedPaneUI.this.tabPane.getTabPlacement(), n);
        }

        private void layoutTabComponents() {
            if (JTattooUtilities.getJavaVersion() >= 1.6) {
                if (BaseTabbedPaneUI.this.tabContainer == null) {
                    return;
                }
                Rectangle rectangle = new Rectangle();
                Point point = new Point(-BaseTabbedPaneUI.this.tabContainer.getX(), -BaseTabbedPaneUI.this.tabContainer.getY());
                if (BaseTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    BaseTabbedPaneUI.this.translatePointToTabPanel(0, 0, point);
                }
                for (int i = 0; i < BaseTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                    Component component = BaseTabbedPaneUI.this.tabPane.getTabComponentAt(i);
                    if (component == null) continue;
                    BaseTabbedPaneUI.this.getTabBounds(i, rectangle);
                    Dimension dimension = component.getPreferredSize();
                    Insets insets = BaseTabbedPaneUI.this.getTabInsets(BaseTabbedPaneUI.this.tabPane.getTabPlacement(), i);
                    int n = rectangle.x + insets.left + point.x;
                    int n2 = rectangle.y + insets.top + point.y;
                    int n3 = rectangle.width - insets.left - insets.right;
                    int n4 = rectangle.height - insets.top - insets.bottom;
                    int n5 = n + (n3 - dimension.width) / 2;
                    int n6 = n2 + (n4 - dimension.height) / 2;
                    int n7 = BaseTabbedPaneUI.this.tabPane.getTabPlacement();
                    boolean bl = i == BaseTabbedPaneUI.this.tabPane.getSelectedIndex();
                    component.setBounds(n5 + BaseTabbedPaneUI.this.getTabLabelShiftX(n7, i, bl), n6 + BaseTabbedPaneUI.this.getTabLabelShiftY(n7, i, bl), dimension.width, dimension.height);
                }
            }
        }

        protected void calculateTabRects(int n, int n2) {
            int n3;
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            int n7;
            FontMetrics fontMetrics = BaseTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BaseTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BaseTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BaseTabbedPaneUI.this.getTabAreaInsets(n);
            int n8 = fontMetrics.getHeight();
            int n9 = BaseTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl = n == 2 || n == 4;
            boolean bl2 = JTattooUtilities.isLeftToRight(BaseTabbedPaneUI.this.tabPane);
            switch (n) {
                case 2: {
                    BaseTabbedPaneUI.this.maxTabWidth = BaseTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BaseTabbedPaneUI.this.maxTabWidth = BaseTabbedPaneUI.this.calculateMaxTabWidth(n);
                    n7 = dimension.width - insets.right - insets2.right - BaseTabbedPaneUI.this.maxTabWidth;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BaseTabbedPaneUI.this.maxTabHeight = BaseTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n7 = insets.left + insets2.left;
                    n6 = dimension.height - insets.bottom - insets2.bottom - BaseTabbedPaneUI.this.maxTabHeight;
                    n5 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BaseTabbedPaneUI.this.maxTabHeight = BaseTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n10 = BaseTabbedPaneUI.this.getTabRunOverlay(n);
            BaseTabbedPaneUI.this.runCount = 0;
            BaseTabbedPaneUI.this.selectedRun = -1;
            if (n2 == 0) {
                return;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                rectangle = BaseTabbedPaneUI.this.rects[n4];
                if (!bl) {
                    if (n4 > 0) {
                        rectangle.x = BaseTabbedPaneUI.this.rects[n4 - 1].x + BaseTabbedPaneUI.this.rects[n4 - 1].width;
                    } else {
                        BaseTabbedPaneUI.this.tabRuns[0] = 0;
                        BaseTabbedPaneUI.this.runCount = 1;
                        BaseTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n7;
                    }
                    rectangle.width = BaseTabbedPaneUI.this.calculateTabWidth(n, n4, fontMetrics);
                    BaseTabbedPaneUI.this.maxTabWidth = Math.max(BaseTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n5) {
                        if (BaseTabbedPaneUI.this.runCount > BaseTabbedPaneUI.this.tabRuns.length - 1) {
                            BaseTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BaseTabbedPaneUI.this.tabRuns[BaseTabbedPaneUI.this.runCount] = n4;
                        ++BaseTabbedPaneUI.this.runCount;
                        rectangle.x = n7;
                    }
                    rectangle.y = n6;
                    rectangle.height = BaseTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n4 > 0) {
                        rectangle.y = BaseTabbedPaneUI.this.rects[n4 - 1].y + BaseTabbedPaneUI.this.rects[n4 - 1].height;
                    } else {
                        BaseTabbedPaneUI.this.tabRuns[0] = 0;
                        BaseTabbedPaneUI.this.runCount = 1;
                        BaseTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n6;
                    }
                    rectangle.height = BaseTabbedPaneUI.this.calculateTabHeight(n, n4, n8);
                    BaseTabbedPaneUI.this.maxTabHeight = Math.max(BaseTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n5) {
                        if (BaseTabbedPaneUI.this.runCount > BaseTabbedPaneUI.this.tabRuns.length - 1) {
                            BaseTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BaseTabbedPaneUI.this.tabRuns[BaseTabbedPaneUI.this.runCount] = n4;
                        ++BaseTabbedPaneUI.this.runCount;
                        rectangle.y = n6;
                    }
                    rectangle.x = n7;
                    rectangle.width = BaseTabbedPaneUI.this.maxTabWidth;
                }
                if (n4 != n9) continue;
                BaseTabbedPaneUI.this.selectedRun = BaseTabbedPaneUI.this.runCount - 1;
            }
            if (BaseTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n, n2, bl ? n6 : n7, n5);
                BaseTabbedPaneUI.this.selectedRun = BaseTabbedPaneUI.this.getRunForTab(n2, n9);
                if (BaseTabbedPaneUI.this.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, BaseTabbedPaneUI.this.selectedRun);
                }
            }
            for (n4 = BaseTabbedPaneUI.this.runCount - 1; n4 >= 0; --n4) {
                int n11;
                int n12;
                n3 = BaseTabbedPaneUI.this.tabRuns[n4];
                int n13 = BaseTabbedPaneUI.this.tabRuns[n4 == BaseTabbedPaneUI.this.runCount - 1 ? 0 : n4 + 1];
                int n14 = n12 = n13 != 0 ? n13 - 1 : n2 - 1;
                if (!bl) {
                    for (n11 = n3; n11 <= n12; ++n11) {
                        rectangle = BaseTabbedPaneUI.this.rects[n11];
                        rectangle.y = n6;
                        rectangle.x += BaseTabbedPaneUI.this.getTabRunIndent(n, n4);
                    }
                    if (BaseTabbedPaneUI.this.shouldPadTabRun(n, n4)) {
                        this.padTabRun(n, n3, n12, n5);
                    }
                    if (n == 3) {
                        n6 -= BaseTabbedPaneUI.this.maxTabHeight - n10;
                        continue;
                    }
                    n6 += BaseTabbedPaneUI.this.maxTabHeight - n10;
                    continue;
                }
                for (n11 = n3; n11 <= n12; ++n11) {
                    rectangle = BaseTabbedPaneUI.this.rects[n11];
                    rectangle.x = n7;
                    rectangle.y += BaseTabbedPaneUI.this.getTabRunIndent(n, n4);
                }
                if (BaseTabbedPaneUI.this.shouldPadTabRun(n, n4)) {
                    this.padTabRun(n, n3, n12, n5);
                }
                if (n == 4) {
                    n7 -= BaseTabbedPaneUI.this.maxTabWidth - n10;
                    continue;
                }
                n7 += BaseTabbedPaneUI.this.maxTabWidth - n10;
            }
            this.padSelectedTab(n, n9);
            if (!bl2 && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n2; ++n4) {
                    BaseTabbedPaneUI.this.rects[n4].x = n3 - BaseTabbedPaneUI.this.rects[n4].x - BaseTabbedPaneUI.this.rects[n4].width;
                }
            }
        }

        protected void rotateTabRuns(int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                int n3 = BaseTabbedPaneUI.this.tabRuns[0];
                for (int j = 1; j < BaseTabbedPaneUI.this.runCount; ++j) {
                    BaseTabbedPaneUI.this.tabRuns[j - 1] = BaseTabbedPaneUI.this.tabRuns[j];
                }
                BaseTabbedPaneUI.this.tabRuns[BaseTabbedPaneUI.this.runCount - 1] = n3;
            }
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                int n5 = BaseTabbedPaneUI.this.runCount - 1;
                boolean bl = true;
                double d = 1.25;
                while (bl) {
                    int n6 = BaseTabbedPaneUI.this.lastTabInRun(n2, n5);
                    int n7 = BaseTabbedPaneUI.this.lastTabInRun(n2, n5 - 1);
                    int n8 = BaseTabbedPaneUI.this.rects[n6].x + BaseTabbedPaneUI.this.rects[n6].width;
                    int n9 = (int)((double)BaseTabbedPaneUI.this.maxTabWidth * d);
                    if (n4 - n8 > n9) {
                        BaseTabbedPaneUI.this.tabRuns[n5] = n7;
                        BaseTabbedPaneUI.this.rects[n7].x = n3;
                        for (int i = n7 + 1; i <= n6; ++i) {
                            BaseTabbedPaneUI.this.rects[i].x = BaseTabbedPaneUI.this.rects[i - 1].x + BaseTabbedPaneUI.this.rects[i - 1].width;
                        }
                    } else if (n5 == BaseTabbedPaneUI.this.runCount - 1) {
                        bl = false;
                    }
                    if (n5 - 1 > 0) {
                        --n5;
                        continue;
                    }
                    n5 = BaseTabbedPaneUI.this.runCount - 1;
                    d += 0.25;
                }
            }
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            Rectangle rectangle = BaseTabbedPaneUI.this.rects[n3];
            if (n == 1 || n == 3) {
                int n5 = rectangle.x + rectangle.width - BaseTabbedPaneUI.this.rects[n2].x;
                int n6 = n4 - (rectangle.x + rectangle.width);
                float f = (float)n6 / (float)n5;
                for (int i = n2; i <= n3; ++i) {
                    Rectangle rectangle2 = BaseTabbedPaneUI.this.rects[i];
                    if (i > n2) {
                        rectangle2.x = BaseTabbedPaneUI.this.rects[i - 1].x + BaseTabbedPaneUI.this.rects[i - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f);
                }
                rectangle.width = n4 - rectangle.x;
            } else {
                int n7 = rectangle.y + rectangle.height - BaseTabbedPaneUI.this.rects[n2].y;
                int n8 = n4 - (rectangle.y + rectangle.height);
                float f = (float)n8 / (float)n7;
                for (int i = n2; i <= n3; ++i) {
                    Rectangle rectangle3 = BaseTabbedPaneUI.this.rects[i];
                    if (i > n2) {
                        rectangle3.y = BaseTabbedPaneUI.this.rects[i - 1].y + BaseTabbedPaneUI.this.rects[i - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f);
                }
                rectangle.height = n4 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n, int n2) {
        }
    }

    private static class ScrollTabsPopupMenuAction
    extends AbstractAction {
        private JTabbedPane tabbedPane = null;

        private ScrollTabsPopupMenuAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                this.tabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollablePopupMenuTabButton) {
                this.tabbedPane = (JTabbedPane)((ScrollablePopupMenuTabButton)object).getParent();
            } else {
                return;
            }
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)this.tabbedPane.getUI();
            if (baseTabbedPaneUI.scrollableTabLayoutEnabled()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                    JMenuItem jMenuItem = new JMenuItem(this.tabbedPane.getTitleAt(i));
                    jMenuItem.addActionListener(new ScrollTabsPopupMenuItemAction(this.tabbedPane, i));
                    jPopupMenu.add(jMenuItem);
                }
                jPopupMenu.show(((BaseTabbedPaneUI)baseTabbedPaneUI).tabScroller.popupMenuButton, 0, 0);
                Point point = ((BaseTabbedPaneUI)baseTabbedPaneUI).tabScroller.popupMenuButton.getLocationOnScreen();
                int n = -jPopupMenu.getWidth() + ((BaseTabbedPaneUI)baseTabbedPaneUI).tabScroller.popupMenuButton.getWidth();
                int n2 = ((BaseTabbedPaneUI)baseTabbedPaneUI).tabScroller.popupMenuButton.getHeight() - 1;
                jPopupMenu.setLocation(point.x + n, point.y + n2);
            }
        }
    }

    private static class ScrollTabsPopupMenuItemAction
    extends AbstractAction {
        private JTabbedPane tabbedPane = null;
        private int selectIndex = 0;

        public ScrollTabsPopupMenuItemAction(JTabbedPane jTabbedPane, int n) {
            this.tabbedPane = jTabbedPane;
            this.selectIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tabbedPane.setSelectedIndex(this.selectIndex);
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            if (baseTabbedPaneUI.scrollableTabLayoutEnabled()) {
                baseTabbedPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof ScrollableTabButton) {
                jTabbedPane = (JTabbedPane)((ScrollableTabButton)object).getParent();
            } else {
                return;
            }
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            if (baseTabbedPaneUI.scrollableTabLayoutEnabled()) {
                baseTabbedPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof BaseTabbedPaneUI) {
                BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n;
                    int n2 = actionEvent.getActionCommand().charAt(0);
                    if (n2 >= 97 && n2 <= 122) {
                        n2 -= 32;
                    }
                    if ((n = (Integer)baseTabbedPaneUI.mnemonicToIndexMap.get(new Integer(n2))) != null && jTabbedPane.isEnabledAt(n)) {
                        jTabbedPane.setSelectedIndex(n);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            baseTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.requestFocus();
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                baseTabbedPaneUI.navigateSelectedTab(3);
            } else {
                baseTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getTabPlacement();
            if (n == 1 || n == 3) {
                baseTabbedPaneUI.navigateSelectedTab(7);
            } else {
                baseTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            baseTabbedPaneUI.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            baseTabbedPaneUI.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            baseTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            baseTabbedPaneUI.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            baseTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BaseTabbedPaneUI baseTabbedPaneUI = (BaseTabbedPaneUI)jTabbedPane.getUI();
            baseTabbedPaneUI.navigateSelectedTab(3);
        }
    }
}

