/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRadioButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.hifi.HiFiUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class HiFiRadioButtonUI
extends BaseRadioButtonUI {
    private static HiFiRadioButtonUI radioButtonUI = null;

    public static ComponentUI createUI(JComponent jComponent) {
        if (radioButtonUI == null) {
            radioButtonUI = new HiFiRadioButtonUI();
        }
        return radioButtonUI;
    }

    protected void paintText(Graphics graphics, JComponent jComponent, String string, Rectangle rectangle) {
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            ButtonModel buttonModel = abstractButton.getModel();
            int n = -1;
            n = JTattooUtilities.getJavaVersion() >= 1.4 ? abstractButton.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(abstractButton.getText(), buttonModel.getMnemonic());
            Font font = jComponent.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (buttonModel.isEnabled()) {
                Color color = abstractButton.getForeground();
                if (ColorHelper.getGrayValue(color) > 128) {
                    graphics.setColor(Color.black);
                    JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
                }
                graphics.setColor(color);
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(Color.black);
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
                graphics.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                JTattooUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        }
    }

    public void paintBackground(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            if (jComponent.getBackground().equals(AbstractLookAndFeel.getBackgroundColor()) && jComponent.getBackground() instanceof ColorUIResource) {
                HiFiUtils.fillComponent(graphics, jComponent);
            } else {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }
    }
}

