/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.impl;

import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinEdge;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import java.util.EnumSet;
import java.util.Objects;

public class PinImpl
implements Pin {
    private final int address;
    private final String name;
    private final String provider;
    private final EnumSet<PinPullResistance> supportedPinPullResistance;
    private final EnumSet<PinMode> supportedPinModes;
    private final EnumSet<PinEdge> supportedPinEdges;

    public PinImpl(String provider, int address, String name, EnumSet<PinMode> modes, EnumSet<PinPullResistance> pullResistance, EnumSet<PinEdge> pinEdges) {
        this.provider = provider;
        this.address = address;
        this.name = name;
        this.supportedPinModes = modes;
        this.supportedPinPullResistance = pullResistance;
        this.supportedPinEdges = pinEdges;
    }

    public PinImpl(String provider, int address, String name, EnumSet<PinMode> modes, EnumSet<PinPullResistance> pullResistance) {
        this(provider, address, name, modes, pullResistance, EnumSet.allOf(PinEdge.class));
    }

    public PinImpl(String provider, int address, String name, EnumSet<PinMode> modes) {
        this(provider, address, name, modes, null);
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public EnumSet<PinMode> getSupportedPinModes() {
        if (this.supportedPinModes == null) {
            return EnumSet.noneOf(PinMode.class);
        }
        return this.supportedPinModes;
    }

    @Override
    public EnumSet<PinPullResistance> getSupportedPinPullResistance() {
        if (this.supportedPinPullResistance == null) {
            return EnumSet.noneOf(PinPullResistance.class);
        }
        return this.supportedPinPullResistance;
    }

    @Override
    public boolean supportsPinPullResistance() {
        return this.supportedPinPullResistance != null && !this.supportedPinPullResistance.isEmpty();
    }

    @Override
    public EnumSet<PinEdge> getSupportedPinEdges() {
        if (this.supportedPinEdges == null) {
            return EnumSet.allOf(PinEdge.class);
        }
        return this.supportedPinEdges;
    }

    @Override
    public boolean supportsPinEdges() {
        return this.supportedPinEdges != null && !this.supportedPinEdges.isEmpty();
    }

    @Override
    public boolean supportsPinEvents() {
        return this.supportsPinEdges();
    }

    @Override
    public int compareTo(Pin o) {
        if (this.getAddress() < o.getAddress()) {
            return -1;
        }
        if (this.getAddress() > o.getAddress()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Pin)) {
            return false;
        }
        Pin pin = (Pin)obj;
        return pin.getProvider().equals(this.getProvider()) && Objects.equals(pin.getName(), this.getName()) && pin.getAddress() == this.getAddress();
    }
}

