/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial;

import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialDataReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EventObject;

public class SerialDataEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final Serial serial;
    private byte[] cachedData = null;
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public SerialDataEvent(Serial serial) {
        super(serial);
        this.serial = serial;
    }

    public SerialDataEvent(Serial serial, byte[] data) {
        this(serial);
        this.cachedData = data;
    }

    public Serial getSerial() {
        return this.serial;
    }

    public SerialDataReader getReader() {
        return this.serial;
    }

    public int length() throws IOException {
        if (this.cachedData != null) {
            return this.cachedData.length;
        }
        return this.getReader().available();
    }

    public byte[] getBytes() throws IOException {
        if (this.cachedData == null) {
            this.cachedData = this.getReader().available() > 0 ? this.getReader().read() : new byte[0];
        }
        return this.cachedData;
    }

    public ByteBuffer getByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.getBytes());
    }

    public String getString(Charset charset) throws IOException {
        return this.getCharBuffer(charset).toString();
    }

    public String getAsciiString() throws IOException {
        return this.getCharBuffer(StandardCharsets.US_ASCII).toString();
    }

    public String getHexByteString() throws IOException {
        return this.getHexByteString(null, ",", null);
    }

    public String getHexByteString(CharSequence prefix, CharSequence separator, CharSequence suffix) throws IOException {
        byte[] data = this.getBytes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            int v = data[i] & 0xFF;
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(hexArray[v >> 4]);
            sb.append(hexArray[v & 0xF]);
            if (suffix == null) continue;
            sb.append(suffix);
        }
        return sb.toString();
    }

    public CharBuffer getCharBuffer(Charset charset) throws IOException {
        return charset.decode(this.getByteBuffer());
    }

    public void discardData() throws IllegalStateException, IOException {
        this.getReader().discardData();
    }
}

