/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system.impl;

import com.pi4j.system.SystemInfoProvider;
import com.pi4j.system.impl.SystemInfoProviderBase;
import com.pi4j.util.ExecUtil;
import com.pi4j.util.StringUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DefaultSystemInfoProvider
extends SystemInfoProviderBase
implements SystemInfoProvider {
    private static Map<String, String> cpuInfo;

    protected String getCpuInfo(String target) throws IOException, InterruptedException, UnsupportedOperationException {
        if (cpuInfo == null) {
            cpuInfo = new HashMap<String, String>();
            try (BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] parts = line.split(":", 2);
                    if (parts.length < 2 || parts[0].trim().isEmpty() || parts[1].trim().isEmpty()) continue;
                    String cpuKey = parts[0].trim();
                    cpuInfo.put(cpuKey, parts[1].trim());
                }
            }
        }
        if (cpuInfo.containsKey(target)) {
            return cpuInfo.get(target);
        }
        throw new UnsupportedOperationException("Invalid target: " + target);
    }

    protected String getBashVersionInfo() {
        String versionInfo = "";
        try {
            String[] result;
            for (String line : result = ExecUtil.execute("bash --version")) {
                if (line.isEmpty()) continue;
                versionInfo = line;
                break;
            }
        }
        catch (IOException | InterruptedException ioe) {
            ioe.printStackTrace();
        }
        return versionInfo;
    }

    protected boolean hasReadElfTag(String tag) {
        String tagValue = this.getReadElfTag(tag);
        return tagValue != null && !tagValue.isEmpty();
    }

    protected String getReadElfTag(String tag) {
        String tagValue;
        block4: {
            tagValue = null;
            try {
                String[] result = ExecUtil.execute("/usr/bin/readelf -A /proc/self/exe");
                if (result == null) break block4;
                for (String line : result) {
                    if (!(line = line.trim()).startsWith(tag) || !line.contains(":")) continue;
                    String[] lineParts = line.split(":", 2);
                    if (lineParts.length > 1) {
                        tagValue = lineParts[1].trim();
                    }
                    break;
                }
            }
            catch (IOException | InterruptedException ioe) {
                ioe.printStackTrace();
            }
        }
        return tagValue;
    }

    protected List<Long> getMemory() throws IOException, InterruptedException {
        ArrayList<Long> values = new ArrayList<Long>();
        String[] result = ExecUtil.execute("free -b");
        if (result != null) {
            for (String line : result) {
                String[] parts;
                if (!line.startsWith("Mem:")) continue;
                for (String part : parts = line.split(" ")) {
                    if ((part = part.trim()).isEmpty() || part.equalsIgnoreCase("Mem:")) continue;
                    values.add(new Long(part));
                }
            }
        }
        return values;
    }

    @Override
    public String getProcessor() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("processor");
    }

    @Override
    public String getBogoMIPS() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("BogoMIPS");
    }

    @Override
    public String[] getCpuFeatures() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("Features").split(" ");
    }

    @Override
    public String getCpuImplementer() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("CPU implementer");
    }

    @Override
    public String getCpuArchitecture() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("CPU architecture");
    }

    @Override
    public String getCpuVariant() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("CPU variant");
    }

    @Override
    public String getCpuPart() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("CPU part");
    }

    @Override
    public String getCpuRevision() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("CPU revision");
    }

    @Override
    public String getHardware() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("Hardware");
    }

    @Override
    public String getRevision() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("Revision");
    }

    @Override
    public String getSerial() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("Serial");
    }

    @Override
    public String getOsName() throws UnsupportedOperationException {
        return System.getProperty("os.name");
    }

    @Override
    public String getOsVersion() throws UnsupportedOperationException {
        return System.getProperty("os.version");
    }

    @Override
    public String getOsArch() throws UnsupportedOperationException {
        return System.getProperty("os.arch");
    }

    @Override
    public String getJavaVendor() throws UnsupportedOperationException {
        return System.getProperty("java.vendor");
    }

    @Override
    public String getJavaVendorUrl() throws UnsupportedOperationException {
        return System.getProperty("java.vendor.url");
    }

    @Override
    public String getJavaVersion() throws UnsupportedOperationException {
        return System.getProperty("java.version");
    }

    @Override
    public String getJavaVirtualMachine() throws UnsupportedOperationException {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getJavaRuntime() throws UnsupportedOperationException {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    @Override
    public boolean isHardFloatAbi() throws UnsupportedOperationException {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            private final String[] gnueabihf = new String[]{"gnueabihf", "armhf"};

            @Override
            public Boolean run() {
                return StringUtil.contains(System.getProperty("sun.boot.library.path"), this.gnueabihf) || StringUtil.contains(System.getProperty("java.library.path"), this.gnueabihf) || StringUtil.contains(System.getProperty("java.home"), this.gnueabihf) || DefaultSystemInfoProvider.this.getBashVersionInfo().contains("gnueabihf") || DefaultSystemInfoProvider.this.hasReadElfTag("Tag_ABI_HardFP_use");
            }
        });
    }

    @Override
    public long getMemoryTotal() throws IOException, InterruptedException, UnsupportedOperationException {
        List<Long> values = this.getMemory();
        if (!values.isEmpty() && values.size() > 0) {
            return values.get(0);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMemoryUsed() throws IOException, InterruptedException, UnsupportedOperationException {
        List<Long> values = this.getMemory();
        if (!values.isEmpty() && values.size() > 1) {
            return values.get(1);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMemoryFree() throws IOException, InterruptedException, UnsupportedOperationException {
        List<Long> values = this.getMemory();
        if (!values.isEmpty() && values.size() > 2) {
            return values.get(2);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMemoryShared() throws IOException, InterruptedException, UnsupportedOperationException {
        List<Long> values = this.getMemory();
        if (!values.isEmpty() && values.size() > 3) {
            return values.get(3);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMemoryBuffers() throws IOException, InterruptedException, UnsupportedOperationException {
        List<Long> values = this.getMemory();
        if (!values.isEmpty() && values.size() > 4) {
            return values.get(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMemoryCached() throws IOException, InterruptedException, UnsupportedOperationException {
        List<Long> values = this.getMemory();
        if (!values.isEmpty() && values.size() > 5) {
            return values.get(5);
        }
        throw new UnsupportedOperationException();
    }
}

