/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public abstract class AbstractBarcodeBean
implements BarcodeGenerator {
    protected double height = 15.0;
    protected double moduleWidth;
    protected HumanReadablePlacement msgPos = HumanReadablePlacement.HRP_BOTTOM;
    protected double fontSize = UnitConv.pt2mm(8.0);
    protected String fontName = "Helvetica";
    protected boolean doQuietZone = true;
    protected double quietZone;
    protected Double quietZoneVertical;
    protected String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String v) {
        this.pattern = v;
    }

    protected boolean hasFontDescender() {
        return false;
    }

    public double getHumanReadableHeight() {
        if (this.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            double textHeight = this.fontSize;
            if (this.hasFontDescender()) {
                return 1.3 * textHeight;
            }
            return textHeight;
        }
        return 0.0;
    }

    public double getBarHeight() {
        return this.height;
    }

    public double getHeight() {
        return this.getBarHeight() + this.getHumanReadableHeight();
    }

    public void setBarHeight(double height) {
        this.height = height;
    }

    public void setHeight(double height) {
        this.height = height - this.getHumanReadableHeight();
    }

    public double getModuleWidth() {
        return this.moduleWidth;
    }

    public void setModuleWidth(double width) {
        this.moduleWidth = width;
    }

    public abstract double getBarWidth(int var1);

    public boolean hasQuietZone() {
        return this.doQuietZone;
    }

    public void doQuietZone(boolean value) {
        this.doQuietZone = value;
    }

    public double getQuietZone() {
        return this.quietZone;
    }

    public double getVerticalQuietZone() {
        if (this.quietZoneVertical != null) {
            return this.quietZoneVertical;
        }
        return this.getQuietZone();
    }

    public void setQuietZone(double width) {
        this.quietZone = width;
    }

    public void setVerticalQuietZone(double height) {
        this.quietZoneVertical = new Double(height);
    }

    public HumanReadablePlacement getMsgPosition() {
        return this.msgPos;
    }

    public void setMsgPosition(HumanReadablePlacement placement) {
        this.msgPos = placement;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(double size) {
        this.fontSize = size;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String name) {
        this.fontName = name;
    }

    @Override
    public abstract void generateBarcode(CanvasProvider var1, String var2);

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        throw new UnsupportedOperationException("NYI");
    }
}

