/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.int2of5;

import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode4j.impl.int2of5.ITF14Bean;
import org.krysalis.barcode4j.output.Canvas;

public class ITF14CanvasLogicHandler
extends DefaultCanvasLogicHandler {
    public ITF14CanvasLogicHandler(ITF14Bean bcBean, Canvas canvas) {
        super(bcBean, canvas);
    }

    private ITF14Bean getITF14Bean() {
        return (ITF14Bean)this.bcBean;
    }

    @Override
    public void startBarcode(String msg, String formattedMsg) {
        super.startBarcode(msg, formattedMsg);
        ITF14Bean bean = this.getITF14Bean();
        double bbw = bean.getBearerBarWidth();
        double w = this.dimensions.getWidthPlusQuiet();
        double h = bean.getBarHeight();
        double top = 0.0;
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            top += this.bcBean.getHumanReadableHeight();
        }
        this.canvas.drawRect(0.0, top, w, top + bbw);
        this.canvas.drawRect(0.0, top + bbw + h, w, top + bbw + h + bbw);
        if (bean.isBearerBox()) {
            this.canvas.drawRect(0.0, top + bbw, bbw, top + bbw + h);
            this.canvas.drawRect(w - bbw, top + bbw, w, top + bbw + h);
        }
    }

    @Override
    protected double getStartX() {
        ITF14Bean bean = this.getITF14Bean();
        return super.getStartX() + (bean.isBearerBox() ? bean.getBearerBarWidth() : 0.0);
    }

    @Override
    protected double getStartY() {
        double y = super.getStartY() + this.getITF14Bean().getBearerBarWidth();
        return y;
    }

    @Override
    protected double getTextBaselinePosition() {
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
            double ty = super.getTextBaselinePosition();
            return ty += 2.0 * this.getITF14Bean().getBearerBarWidth();
        }
        return super.getTextBaselinePosition();
    }
}

