/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.pdf417;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.impl.ConfigurableBarcodeGenerator;
import org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import org.krysalis.barcode4j.tools.Length;

public class PDF417
extends ConfigurableBarcodeGenerator
implements Configurable {
    public PDF417() {
        this.bean = new PDF417Bean();
    }

    @Override
    public void configure(Configuration cfg) throws ConfigurationException {
        String mws = cfg.getChild("module-width").getValue(null);
        if (mws != null) {
            Length mw = new Length(mws, "mm");
            this.getPDF417Bean().setModuleWidth(mw.getValueAsMillimeter());
        }
        super.configure(cfg);
        Configuration child = cfg.getChild("min-columns", false);
        if (child != null) {
            this.getPDF417Bean().setMinCols(child.getValueAsInteger());
        }
        if ((child = cfg.getChild("max-columns", false)) != null) {
            this.getPDF417Bean().setMaxCols(child.getValueAsInteger());
        }
        if ((child = cfg.getChild("min-rows", false)) != null) {
            this.getPDF417Bean().setMinRows(child.getValueAsInteger());
        }
        if ((child = cfg.getChild("max-rows", false)) != null) {
            this.getPDF417Bean().setMaxRows(child.getValueAsInteger());
        }
        if ((child = cfg.getChild("columns", false)) != null) {
            this.getPDF417Bean().setColumns(child.getValueAsInteger());
        }
        this.getPDF417Bean().setErrorCorrectionLevel(cfg.getChild("ec-level").getValueAsInteger(0));
        String rhs = cfg.getChild("row-height").getValue(null);
        if (rhs != null) {
            Length rh = new Length(rhs, "mw");
            if (rh.getUnit().equalsIgnoreCase("mw")) {
                this.getPDF417Bean().setRowHeight(rh.getValue() * this.getBean().getModuleWidth());
            } else {
                this.getPDF417Bean().setRowHeight(rh.getValueAsMillimeter());
            }
        } else {
            this.getPDF417Bean().setRowHeight(3.0 * this.getBean().getModuleWidth());
        }
        child = cfg.getChild("width-to-height-ratio", false);
        if (child != null) {
            this.getPDF417Bean().setWidthToHeightRatio(child.getValueAsFloat());
        }
        if ((child = cfg.getChild("encoding", false)) != null) {
            this.getPDF417Bean().setEncoding(child.getValue(null));
            this.getPDF417Bean().setECIEnabled(child.getAttributeAsBoolean("enable-eci", false));
        }
    }

    public PDF417Bean getPDF417Bean() {
        return (PDF417Bean)this.getBean();
    }
}

