/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output.eps;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.output.AbstractCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class EPSCanvasProvider
extends AbstractCanvasProvider {
    private Writer writer;
    private DecimalFormat df;
    private IOException firstError;
    private double height;

    public EPSCanvasProvider(OutputStream out, int orientation) throws IOException {
        super(orientation);
        try {
            this.writer = new OutputStreamWriter(out, "US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Incompatible VM: Need US-ASCII encoding. " + uee.getMessage());
        }
    }

    protected DecimalFormat getDecimalFormat() {
        if (this.df == null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            this.df = new DecimalFormat("0.####", dfs);
        }
        return this.df;
    }

    private String format(double coord) {
        return this.getDecimalFormat().format(coord);
    }

    private String formatmm(double coord) {
        return this.getDecimalFormat().format(UnitConv.mm2pt(coord));
    }

    private String formatmm(double x, double y) {
        return this.formatmm(x) + " " + this.formatmm(this.height - y);
    }

    private void writeHeader(double width, double height) throws IOException {
        this.writer.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        double widthpt = UnitConv.mm2pt(width);
        double heightpt = UnitConv.mm2pt(height);
        this.writer.write("%%BoundingBox: 0 0 " + Math.round(Math.ceil(widthpt)) + " " + Math.round(Math.ceil(heightpt)) + "\n");
        this.writer.write("%%HiResBoundingBox: 0 0 " + this.format(widthpt) + " " + this.format(heightpt) + "\n");
        this.writer.write("%%Creator: Barcode4J (http://barcode4j.krysalis.org)\n");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.writer.write("%%CreationDate: " + sdf.format(new Date()) + "\n");
        this.writer.write("%%LanguageLevel: 1\n");
        this.writer.write("%%EndComments\n");
        this.writer.write("%%BeginProlog\n");
        this.writer.write("%%BeginProcSet: barcode4j-procset 1.1\n");
        this.writer.write("/rf {\n");
        this.writer.write("newpath\n");
        this.writer.write("4 -2 roll moveto\n");
        this.writer.write("dup neg 0 exch rlineto\n");
        this.writer.write("exch 0 rlineto\n");
        this.writer.write("0 neg exch rlineto\n");
        this.writer.write("closepath fill\n");
        this.writer.write("} def\n");
        this.writer.write("/ct {\n");
        this.writer.write("moveto dup stringwidth\n");
        this.writer.write("2 div neg exch 2 div neg exch\n");
        this.writer.write("rmoveto show\n");
        this.writer.write("} def\n");
        this.writer.write("/rt {\n");
        this.writer.write("4 -1 roll dup stringwidth pop\n");
        this.writer.write("5 -2 roll 1 index sub\n");
        this.writer.write("3 -1 roll sub\n");
        this.writer.write("add\n");
        this.writer.write("3 -1 roll moveto show\n");
        this.writer.write("} def\n");
        this.writer.write("/jt {\n");
        this.writer.write("4 -1 roll dup stringwidth pop\n");
        this.writer.write("5 -2 roll 1 index sub\n");
        this.writer.write("3 -1 roll sub\n");
        this.writer.write("2 index length\n");
        this.writer.write("1 sub div\n");
        this.writer.write("0 4 -1 roll 4 -1 roll 5 -1 roll\n");
        this.writer.write("moveto ashow\n");
        this.writer.write("} def\n");
        this.writer.write("%%EndProcSet: barcode4j-procset 1.0\n");
        this.writer.write("%%EndProlog\n");
    }

    public void finish() throws IOException {
        if (this.firstError != null) {
            throw this.firstError;
        }
        this.writer.write("%%EOF\n");
        this.writer.flush();
    }

    @Override
    public void establishDimensions(BarcodeDimension dim) {
        super.establishDimensions(dim);
        int orientation = BarcodeDimension.normalizeOrientation(this.getOrientation());
        if (this.firstError != null) {
            return;
        }
        this.height = dim.getHeightPlusQuiet();
        try {
            this.writeHeader(dim.getWidthPlusQuiet(orientation), dim.getHeightPlusQuiet(orientation));
            String w = this.formatmm(dim.getWidthPlusQuiet());
            String h = this.formatmm(dim.getHeightPlusQuiet());
            switch (orientation) {
                case 90: {
                    this.writer.write("90 rotate 0 -" + h + " translate\n");
                    break;
                }
                case 180: {
                    this.writer.write("180 rotate -" + w + " -" + h + " translate\n");
                    break;
                }
                case 270: {
                    this.writer.write("270 rotate -" + w + " 0 translate\n");
                    break;
                }
            }
        }
        catch (IOException ioe) {
            this.firstError = ioe;
        }
    }

    @Override
    public void deviceFillRect(double x, double y, double w, double h) {
        if (this.firstError != null) {
            return;
        }
        try {
            this.writer.write(this.formatmm(x, y) + " " + this.formatmm(w) + " " + this.formatmm(h) + " rf\n");
        }
        catch (IOException ioe) {
            this.firstError = ioe;
        }
    }

    @Override
    public void deviceText(String text, double x1, double x2, double y1, String fontName, double fontSize, TextAlignment textAlign) {
        if (this.firstError != null) {
            return;
        }
        this.checkFontName(fontName);
        try {
            this.writer.write("/" + fontName + " findfont " + UnitConv.mm2pt(fontSize) + " scalefont setfont\n");
            if (textAlign == TextAlignment.TA_LEFT) {
                this.writer.write(this.formatmm(x1, y1) + " moveto (" + text + ") show\n");
            } else if (textAlign == TextAlignment.TA_RIGHT) {
                this.writer.write("(" + text + ") " + this.formatmm(x1) + " " + this.formatmm(x2) + " " + this.formatmm(this.height - y1) + " rt\n");
            } else if (textAlign == TextAlignment.TA_CENTER) {
                this.writer.write("(" + text + ") " + this.formatmm((x1 + x2) / 2.0, y1) + " ct\n");
            } else if (textAlign == TextAlignment.TA_JUSTIFY) {
                this.writer.write("(" + text + ") " + this.formatmm(x1) + " " + this.formatmm(x2) + " " + this.formatmm(this.height - y1) + " jt\n");
            }
        }
        catch (IOException ioe) {
            this.firstError = ioe;
        }
    }

    private void checkFontName(String fontName) {
        if (fontName.indexOf(32) >= 0) {
            throw new IllegalArgumentException("PostScript/EPS output does not support font names with spaces ('" + fontName + "'). Please use the PostScript name of the font!");
        }
    }
}

