/*
 * Decompiled with CFR 0.152.
 */
package com.saleculator.updater;

import com.saleculator.updater.UnzipUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Updater
extends JDialog {
    public static boolean flashupdate = false;
    public static String flashfilepath = "";
    private Thread worker;
    private final String root1 = System.getProperty("user.home");
    private final String root2 = System.getProperty("user.home") + File.separator + "update";
    private JTextArea outText;
    private JButton cancle;
    private JButton launch;
    private JScrollPane sp;
    private JPanel pan1;
    private JPanel pan2;

    public Updater(String filepath) {
        if (!filepath.equals("")) {
            flashfilepath = filepath;
            flashupdate = true;
        }
        this.initComponents();
        if (flashupdate) {
            this.outText.setText("Updating system from flash...");
        } else {
            this.outText.setText("Contacting download server...");
        }
        this.download();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Saleculator Update");
        this.pan1 = new JPanel();
        this.pan1.setLayout(new BorderLayout());
        this.pan2 = new JPanel();
        this.pan2.setLayout(new FlowLayout());
        this.outText = new JTextArea();
        this.outText.setEditable(false);
        this.outText.setRows(15);
        this.sp = new JScrollPane();
        this.sp.setViewportView(this.outText);
        this.launch = new JButton("Launch App");
        this.launch.setEnabled(false);
        this.launch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Updater.this.launch();
            }
        });
        this.pan2.add(this.launch);
        this.cancle = new JButton("Cancel Update");
        this.cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Updater.this.launch();
            }
        });
        this.pan2.add(this.cancle);
        this.pan1.add((Component)this.sp, "Center");
        this.pan1.add((Component)this.pan2, "South");
        this.add(this.pan1);
        this.pack();
        this.setSize(400, 350);
        this.setLocationRelativeTo(null);
    }

    private void download() {
        this.worker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (flashupdate) {
                        Updater.this.copy(flashfilepath, Updater.this.root1 + File.separator + "update.zip");
                    } else {
                        String downloadlink = Updater.this.getDownloadLinkFromHost();
                        if (downloadlink == null) {
                            Updater.this.outText.setText(Updater.this.outText.getText() + "\nUpdate error!");
                            Updater.this.launch.setEnabled(true);
                            return;
                        }
                        Updater.this.downloadFile(Updater.this.getDownloadLinkFromHost());
                    }
                    UnzipUtility unzipper = new UnzipUtility();
                    try {
                        String OS = System.getProperty("os.name").toLowerCase();
                        if (OS.contains("nix") || OS.contains("nux") || OS.contains("aix")) {
                            unzipper.unzip(Updater.this.root1 + File.separator + "update.zip", "/opt/Saleculator/");
                        } else {
                            unzipper.unzip(Updater.this.root1 + File.separator + "update.zip", new File("").getAbsolutePath() + "\\");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Updater.this.cleanup();
                    Updater.this.launch.setEnabled(true);
                    Updater.this.outText.setText(Updater.this.outText.getText() + "\nUpdate Finished!");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, "An error occured while preforming update!");
                }
            }
        });
        this.worker.start();
    }

    private void launch() {
        try {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-jar");
            String OS = System.getProperty("os.name").toLowerCase();
            if (OS.contains("nix") || OS.contains("nux") || OS.contains("aix")) {
                command.add("/opt/Saleculator/Saleculator.jar");
            } else {
                command.add(new File("").getAbsolutePath() + "\\Saleculator.jar");
            }
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void cleanup() {
        this.outText.setText(this.outText.getText() + "\nPreforming clean up...");
        try {
            File f = new File(this.root1 + File.separator + "update.zip");
            if (f.exists()) {
                f.delete();
            }
            new File(this.root2).delete();
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
    }

    private void remove(File f) {
        File[] files;
        for (File ff : files = f.listFiles()) {
            if (ff.isDirectory()) {
                this.remove(ff);
                ff.delete();
                continue;
            }
            ff.delete();
        }
    }

    public void copy(String srFile, String dtFile) throws FileNotFoundException, IOException {
        int len;
        File f1 = new File(srFile);
        File f2 = new File(dtFile);
        FileInputStream in = new FileInputStream(f1);
        FileOutputStream out = new FileOutputStream(f2);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void remountrw() throws IOException {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add("remountrw");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void downloadFile(String link) throws MalformedURLException, IOException {
        URL url = new URL(link);
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        long max = conn.getContentLength();
        this.outText.setText(this.outText.getText() + "\nUpdate Size: " + Updater.readableFileSize(max) + ". \nDownloading file...");
        BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(new File(this.root1 + File.separator + "update.zip")));
        byte[] buffer = new byte[32768];
        int bytesRead = 0;
        int in = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            in += bytesRead;
            fOut.write(buffer, 0, bytesRead);
        }
        fOut.flush();
        fOut.close();
        is.close();
        this.outText.setText(this.outText.getText() + "\nDownload Complete.");
    }

    private String getDownloadLinkFromHost() throws MalformedURLException, IOException {
        String path = "http://saleculator.com/sumup/update/geturl";
        String urlParameters = "/" + Updater.getMacAddress() + "/" + Updater.getSerialKey();
        URL url = new URL(path + urlParameters);
        InputStream html = null;
        html = url.openStream();
        int c = 0;
        StringBuilder buffer = new StringBuilder("");
        while (c != -1) {
            c = html.read();
            buffer.append((char)c);
        }
        if (buffer.substring(buffer.indexOf("[STATUS]") + 8, buffer.indexOf("[/STATUS]")).equals("1")) {
            return buffer.substring(buffer.indexOf("[URL]") + 5, buffer.indexOf("[/URL]"));
        }
        return null;
    }

    public void setFlashUpdate(String path) {
        flashupdate = true;
        flashfilepath = path;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            flashupdate = true;
            flashfilepath = args[0].toString();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Updater("").setVisible(true);
            }
        });
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
            StringBuffer macAddress = new StringBuffer();
            while (ni.hasMoreElements() && macAddress.toString().trim().length() == 0) {
                NetworkInterface nextElement = ni.nextElement();
                byte[] mac = nextElement.getHardwareAddress();
                if (mac == null) continue;
                macAddress = new StringBuffer();
                for (int i = 0; i < mac.length; ++i) {
                    macAddress.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "" : ""));
                }
                if (macAddress.toString().trim().length() <= 0) continue;
                return macAddress.toString();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String getSerialKey() {
        try {
            File f = new File(System.getProperty("user.home"), "license.sig");
            if (f.exists()) {
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                String s1 = br.readLine();
                if (s1 != null) {
                    String s2 = br.readLine();
                    if (s2 != null) {
                        return s2;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

