/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.components.headertoolbar.actions.MoveColumnData;
import net.sf.jasperreports.components.headertoolbar.actions.ResizeColumnCommand;
import net.sf.jasperreports.components.headertoolbar.actions.SimpleMoveColumnCommand;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.web.commands.Command;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandStack;

public class MoveColumnCommand
implements Command {
    private static final long serialVersionUID = 10200L;
    private StandardTable table;
    private MoveColumnData moveColumnData;
    private CommandStack individualResizeCommandStack;

    public MoveColumnCommand(StandardTable table, MoveColumnData moveColumnData) {
        this.table = table;
        this.moveColumnData = moveColumnData;
        this.individualResizeCommandStack = new CommandStack();
    }

    @Override
    public void execute() throws CommandException {
        this.moveColumns(this.moveColumnData);
    }

    private void moveColumns(MoveColumnData moveColumnData) throws CommandException {
        int srcColIndex = moveColumnData.getColumnToMoveIndex();
        int destColIndex = moveColumnData.getColumnToMoveNewIndex();
        List<BaseColumn> allColumns = TableUtil.getAllColumns(this.table);
        BaseColumn srcColumn = allColumns.get(srcColIndex);
        BaseColumn destColumn = allColumns.get(destColIndex);
        List<ResizeColumnCommand.ColumnGroupInfo> srcColParentColumnGroups = new ResizeColumnCommand.ColumnUtil(srcColIndex).getParentColumnGroups(this.table.getColumns());
        List<ResizeColumnCommand.ColumnGroupInfo> destColParentColumnGroups = new ResizeColumnCommand.ColumnUtil(destColIndex).getParentColumnGroups(this.table.getColumns());
        List<BaseColumn> srcSiblingColumns = srcColParentColumnGroups == null || srcColParentColumnGroups.isEmpty() ? this.table.getColumns() : srcColParentColumnGroups.get((int)(srcColParentColumnGroups.size() - 1)).columnGroup.getColumns();
        int srcSiblingColIndex = srcSiblingColumns.indexOf(srcColumn);
        int destSiblingColIndex = srcSiblingColumns.indexOf(destColumn);
        if (destSiblingColIndex < 0 && destColParentColumnGroups != null && !destColParentColumnGroups.isEmpty()) {
            Iterator<ResizeColumnCommand.ColumnGroupInfo> it = destColParentColumnGroups.iterator();
            while (destSiblingColIndex < 0 && it.hasNext()) {
                ResizeColumnCommand.ColumnGroupInfo columnGroupInfo = it.next();
                destSiblingColIndex = srcSiblingColumns.indexOf(columnGroupInfo.columnGroup);
            }
        }
        if (destSiblingColIndex >= 0 && srcSiblingColIndex != destSiblingColIndex) {
            this.individualResizeCommandStack.execute(new SimpleMoveColumnCommand(srcSiblingColumns, srcColumn, srcSiblingColIndex, destSiblingColIndex));
        }
    }

    @Override
    public void undo() {
        this.individualResizeCommandStack.undoAll();
    }

    @Override
    public void redo() {
        this.individualResizeCommandStack.redoAll();
    }
}

