/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRBigDecimalIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRByteIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultFirstIncrementer;
import net.sf.jasperreports.engine.fill.JRDefaultNothingIncrementer;
import net.sf.jasperreports.engine.fill.JRDefaultSystemIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFloatIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRIntegerIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRShortIncrementerFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class JRDefaultIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    private static JRDefaultIncrementerFactory mainInstance = new JRDefaultIncrementerFactory();

    private JRDefaultIncrementerFactory() {
    }

    public static JRDefaultIncrementerFactory getInstance() {
        return mainInstance;
    }

    @Override
    public JRExtendedIncrementer getExtendedIncrementer(CalculationEnum calculation) {
        JRAbstractExtendedIncrementer incrementer = null;
        switch (calculation) {
            case SYSTEM: {
                incrementer = JRDefaultSystemIncrementer.getInstance();
                break;
            }
            case FIRST: {
                incrementer = JRDefaultFirstIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultNothingIncrementer.getInstance();
            }
        }
        return incrementer;
    }

    public static JRExtendedIncrementerFactory getFactory(Class<?> valueClass) {
        JRAbstractExtendedIncrementerFactory factory = BigDecimal.class.equals(valueClass) ? JRBigDecimalIncrementerFactory.getInstance() : (Number.class.equals(valueClass) || Double.class.equals(valueClass) ? JRDoubleIncrementerFactory.getInstance() : (Float.class.equals(valueClass) ? JRFloatIncrementerFactory.getInstance() : (Long.class.equals(valueClass) ? JRLongIncrementerFactory.getInstance() : (Integer.class.equals(valueClass) ? JRIntegerIncrementerFactory.getInstance() : (Short.class.equals(valueClass) ? JRShortIncrementerFactory.getInstance() : (Byte.class.equals(valueClass) ? JRByteIncrementerFactory.getInstance() : (Comparable.class.isAssignableFrom(valueClass) ? JRComparableIncrementerFactory.getInstance() : JRDefaultIncrementerFactory.getInstance())))))));
        return factory;
    }
}

