/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.List;
import java.util.function.BiConsumer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.util.ElementalPropertiesHolder;
import net.sf.jasperreports.engine.util.UniformPrintElementVisitor;

public class PartPropertiesDetector
extends UniformPrintElementVisitor<Void> {
    private JRPropertiesUtil propertiesUtil;
    private BiConsumer<String, JRPropertiesHolder> partConsumer;

    public PartPropertiesDetector(JRPropertiesUtil propertiesUtil, BiConsumer<String, JRPropertiesHolder> partConsumer) {
        super(true);
        this.propertiesUtil = propertiesUtil;
        this.partConsumer = partConsumer;
    }

    @Override
    protected void visitElement(JRPrintElement element, Void arg) {
        String partName;
        if (element.hasProperties() && (partName = element.getPropertiesMap().getProperty("net.sf.jasperreports.print.part.name")) != null) {
            ElementalPropertiesHolder partProperties = new ElementalPropertiesHolder();
            this.propertiesUtil.transferProperties(element, (JRPropertiesHolder)partProperties, "net.sf.jasperreports.part.print.transfer.");
            this.partConsumer.accept(partName, partProperties);
        }
    }

    public void detect(List<JRPrintElement> elements) {
        for (JRPrintElement element : elements) {
            element.accept(this, null);
        }
    }
}

