/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.FileBufferedOutputStream;

public class FileBufferedWriter
extends Writer {
    private FileBufferedOutputStream fbos = new FileBufferedOutputStream();
    private Writer osw;
    private boolean isEmpty = true;

    public FileBufferedWriter() {
        try {
            this.osw = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fbos, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JRRuntimeException(e);
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void writeData(Writer writer) {
        Reader reader = null;
        try {
            this.close();
            reader = new InputStreamReader(this.fbos.getDataInputStream(), StandardCharsets.UTF_8);
            char[] chars = new char[10000];
            int ln = 0;
            while ((ln = reader.read(chars)) > 0) {
                writer.write(chars, 0, ln);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void dispose() {
        this.fbos.dispose();
    }

    @Override
    public void close() throws IOException {
        this.osw.close();
    }

    @Override
    public void flush() throws IOException {
        this.osw.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.isEmpty = false;
        }
        this.osw.write(cbuf, off, len);
    }
}

