/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader;

import java.lang.reflect.Constructor;
import jpos.JposException;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceManager;
import jpos.loader.simple.SimpleServiceManager;
import jpos.util.DefaultProperties;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public final class JposServiceLoader {
    private static Tracer tracer = TracerFactory.getInstance().createTracer("JposServiceLoader");
    private static JposServiceManager manager = null;

    public static JposServiceConnection findService(String string) throws JposException {
        if (manager == null) {
            String string2 = "Did not find a valid jpos.config.serviceManagerClass to create";
            tracer.println(string2);
            throw new JposException(104, string2);
        }
        tracer.println("findService: " + string);
        return manager.createConnection(string);
    }

    public static JposServiceManager getManager() {
        return manager;
    }

    static {
        DefaultProperties defaultProperties = new DefaultProperties();
        defaultProperties.loadJposProperties();
        boolean bl = false;
        String string = "";
        if (defaultProperties.isPropertyDefined("jpos.config.serviceManagerClass")) {
            bl = true;
            string = defaultProperties.getPropertyString("jpos.config.serviceManagerClass");
        } else if (defaultProperties.isPropertyDefined("jpos.loader.serviceManagerClass")) {
            bl = true;
            string = defaultProperties.getPropertyString("jpos.loader.serviceManagerClass");
        }
        if (bl) {
            tracer.println("Custom manager is defined: className= " + string);
            try {
                Class<?> clazz = Class.forName(string);
                Class<?> clazz2 = Class.forName("jpos.util.JposProperties");
                Class[] classArray = new Class[]{clazz2};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{defaultProperties};
                manager = (JposServiceManager)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                tracer.println("Error creating instance of specified jpos.config.serviceManagerClass class: " + string);
                tracer.println("Using default manager class: jpos.loader.simple.SimpleServiceManager");
                manager = new SimpleServiceManager(defaultProperties);
            }
        } else {
            manager = new SimpleServiceManager(defaultProperties);
        }
        manager.getEntryRegistry().load();
        tracer.println("manager.getEntryRegistry().load() OK");
    }
}

