/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.lcd.impl;

import com.pi4j.component.lcd.LCD;
import com.pi4j.component.lcd.LCDBase;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class I2CLcdDisplay
extends LCDBase
implements LCD {
    boolean backLightDesiredState = true;
    private boolean backlight = true;
    boolean rsFlag = false;
    boolean eFlag = false;
    private I2CDevice dev = null;
    private final int[] LCD_LINE_ADDRESS = new int[]{128, 192, 148, 212};
    private final boolean LCD_CHR = true;
    private final boolean LCD_CMD = false;
    private int pulseData = 0;
    int backlightBit;
    int rsBit;
    int rwBit;
    int eBit;
    int d7Bit;
    int d6Bit;
    int d5Bit;
    int d4Bit;
    protected int rows;
    protected int columns;

    public I2CLcdDisplay(int rows, int columns, int i2cBus, int i2cAddress, int backlightBit, int rsBit, int rwBit, int eBit, int d7, int d6, int d5, int d4) throws Exception {
        this.rows = rows;
        this.columns = columns;
        this.d7Bit = d7;
        this.d6Bit = d6;
        this.d5Bit = d5;
        this.d4Bit = d4;
        this.backlightBit = backlightBit;
        this.rsBit = rsBit;
        this.eBit = eBit;
        this.rows = rows;
        this.columns = columns;
        I2CBus bus = I2CFactory.getInstance((int)i2cBus);
        this.dev = bus.getDevice(i2cAddress);
        this.init();
    }

    @Override
    public void clear() {
        try {
            this.lcd_byte(1, false);
        }
        catch (Exception ex) {
            Logger.getLogger(I2CLcdDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void write(byte data) {
        try {
            this.lcd_byte(data, true);
        }
        catch (Exception ex) {
            Logger.getLogger(I2CLcdDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void write(String data) {
        for (int i = 0; i < data.length(); ++i) {
            try {
                this.lcd_byte(data.charAt(i), true);
                continue;
            }
            catch (Exception e) {
                System.out.println("Problems writing data");
            }
        }
    }

    public void lcd_byte(int val, boolean type) throws Exception {
        this.setRS(type);
        this.write(val >> 4);
        this.pulse_en(type, val >> 4);
        this.write(val & 0xF);
        this.pulse_en(type, val & 0xF);
    }

    public void diagnostics() {
        try {
            this.lcd_byte(1, true);
        }
        catch (Exception ex) {
            Logger.getLogger(I2CLcdDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static BitSet fromByte(byte b) {
        BitSet bits = new BitSet(8);
        for (int i = 0; i < 8; ++i) {
            bits.set(i, (b & 1) == 1);
            b = (byte)(b >> 1);
        }
        return bits;
    }

    private void init() throws Exception {
        this.lcd_byte(51, false);
        this.lcd_byte(50, false);
        this.lcd_byte(40, false);
        this.lcd_byte(8, false);
        this.lcd_byte(1, false);
        this.lcd_byte(6, false);
        this.lcd_byte(12, false);
    }

    private void pulse_en(boolean type, int val) throws Exception {
        this.setE(true);
        this.write(val);
        this.setE(false);
        this.write(val);
        if (!type) {
            Thread.sleep(1L);
        }
    }

    private void write(int incomingData) throws Exception {
        int tmpData = incomingData;
        BitSet bits = I2CLcdDisplay.fromByte((byte)tmpData);
        byte out = (byte)((bits.get(3) ? 1 << this.d7Bit : 0 << this.d7Bit) | (bits.get(2) ? 1 << this.d6Bit : 0 << this.d6Bit) | (bits.get(1) ? 1 << this.d5Bit : 0 << this.d5Bit) | (bits.get(0) ? 1 << this.d4Bit : 0 << this.d4Bit) | (this.isBacklight() ? 1 << this.backlightBit : 0 << this.backlightBit) | (this.rsFlag ? 1 << this.rsBit : 0 << this.rsBit) | (this.eFlag ? 1 << this.eBit : 0 << this.eBit));
        this.dev.write(out);
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public void setCursorHome() {
        try {
            this.lcd_byte(2, false);
        }
        catch (Exception ex) {
            Logger.getLogger(I2CLcdDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setCursorPosition(int row, int column) {
        this.validateCoordinates(row, column);
        try {
            this.lcd_byte(this.LCD_LINE_ADDRESS[row] + column, false);
        }
        catch (Exception ex) {
            Logger.getLogger(I2CLcdDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setBacklight(boolean backlight) {
        this.backlight = backlight;
    }

    public void setBacklight(boolean backlight, boolean immediate) throws IOException {
        this.setBacklight(backlight);
        if (immediate) {
            this.dev.write((byte)(backlight ? 1 << (byte)this.backlightBit : 0 << (byte)this.backlightBit));
        }
    }

    private void setRS(boolean val) {
        this.rsFlag = val;
    }

    private void setE(boolean val) {
        this.eFlag = val;
    }

    public boolean isBacklight() {
        return this.backlight;
    }
}

