/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.motor;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinState;

public class EasyDriver {
    public static final int FORWARD = 0;
    public static final int BACKWARD = 1;
    public static final int FULL_STEP = 0;
    public static final int HALF_STEP = 1;
    public static final int ONE_FOURTH_STEP = 2;
    public static final int ONE_EIGHTH_STEP = 3;
    private int mDrivingMode;
    private GpioPinDigitalOutput mStepPin;
    private GpioPinDigitalOutput mDirPin;
    private GpioPinDigitalOutput mSleepPin;
    private GpioPinDigitalOutput mEnablePin;
    private GpioPinDigitalOutput mMs1Pin;
    private GpioPinDigitalOutput mMs2Pin;
    private GpioPinDigitalOutput mResetPin;

    public EasyDriver(int drivingMode, Pin stepPin, Pin dirPin, Pin sleepPin, Pin enablePin, Pin ms1Pin, Pin ms2Pin, Pin resetPin) {
        this.mDrivingMode = drivingMode;
        GpioController gpio = GpioFactory.getInstance();
        this.mStepPin = gpio.provisionDigitalOutputPin(stepPin, "Step Pin", PinState.LOW);
        this.mDirPin = gpio.provisionDigitalOutputPin(dirPin, "Direction Pin", PinState.LOW);
        this.mSleepPin = gpio.provisionDigitalOutputPin(sleepPin, "Sleep Pin", PinState.HIGH);
        this.mEnablePin = gpio.provisionDigitalOutputPin(enablePin, "Enable Pin", PinState.LOW);
        this.mMs1Pin = gpio.provisionDigitalOutputPin(ms1Pin, "MS1 Pin", PinState.HIGH);
        this.mMs2Pin = gpio.provisionDigitalOutputPin(ms2Pin, "MS2 Pin", PinState.HIGH);
        this.mResetPin = gpio.provisionDigitalOutputPin(resetPin, "Reset Pin", PinState.HIGH);
        this.setDrivingMode(drivingMode);
        this.mStepPin.setShutdownOptions(Boolean.valueOf(true), PinState.LOW);
        this.mDirPin.setShutdownOptions(Boolean.valueOf(true), PinState.LOW);
        this.mSleepPin.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.mEnablePin.setShutdownOptions(Boolean.valueOf(true), PinState.LOW);
        this.mMs1Pin.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.mMs2Pin.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.mResetPin.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
    }

    public EasyDriver(Pin stepPin, Pin dirPin, Pin sleepPin, Pin enablePin, Pin ms1Pin, Pin ms2Pin, Pin resetPin) {
        new EasyDriver(3, stepPin, dirPin, sleepPin, enablePin, ms1Pin, ms2Pin, resetPin);
    }

    public EasyDriver(Pin stepPin) {
        this.mDrivingMode = 3;
        GpioController gpio = GpioFactory.getInstance();
        this.mStepPin = gpio.provisionDigitalOutputPin(stepPin, "MyLED", PinState.LOW);
    }

    public void setDrivingMode(int drivingMode) {
        switch (drivingMode) {
            case 0: {
                this.mMs1Pin.low();
                this.mMs2Pin.low();
                break;
            }
            case 1: {
                this.mMs1Pin.high();
                this.mMs2Pin.low();
                break;
            }
            case 2: {
                this.mMs1Pin.low();
                this.mMs2Pin.high();
                break;
            }
            case 3: {
                this.mMs1Pin.high();
                this.mMs2Pin.high();
            }
        }
    }

    public void rotate(double degrees, int interval, int drivingMode) throws InterruptedException {
        this.move(EasyDriver.getStepsFromDegrees(degrees, drivingMode), interval, drivingMode);
    }

    public void rotate(double degrees, int interval) throws InterruptedException {
        this.rotate(degrees, interval, this.mDrivingMode);
    }

    public void move(int distance, int interval, int drivingMode) throws InterruptedException {
        if (drivingMode != this.mDrivingMode) {
            this.setDrivingMode(drivingMode);
        }
        if (distance < 0) {
            this.setDirection(1);
        } else {
            this.setDirection(0);
        }
        for (int i = 0; i < Math.abs(distance); ++i) {
            this.mStepPin.high();
            Thread.sleep(interval);
            this.mStepPin.low();
            Thread.sleep(interval);
        }
    }

    public void move(int steps, int interval) throws InterruptedException {
        this.move(steps, interval, this.mDrivingMode);
    }

    public void sleep() {
        this.mSleepPin.low();
    }

    public void wake() {
        this.mSleepPin.high();
    }

    public void reset() {
        this.mResetPin.low();
    }

    public void enable() {
        this.mEnablePin.low();
    }

    public void disable() {
        this.mEnablePin.high();
    }

    public void shutdown() {
        GpioController gpio = GpioFactory.getInstance();
        gpio.shutdown();
    }

    public void setDirection(int direction) {
        if (direction == 0) {
            this.mDirPin.low();
        } else if (direction == 1) {
            this.mDirPin.high();
        }
    }

    public static double getDegreesFromStep(int steps, int drivingMode) {
        switch (drivingMode) {
            case 0: {
                return (double)steps * 1.8;
            }
            case 1: {
                return (double)steps * 0.9;
            }
            case 2: {
                return (double)steps * 0.45;
            }
            case 3: {
                return (double)steps * 0.225;
            }
        }
        return 0.0;
    }

    public static int getStepsFromDegrees(double degrees, int drivingMode) {
        switch (drivingMode) {
            case 0: {
                return (int)(degrees / 1.8);
            }
            case 1: {
                return (int)(degrees / 0.9);
            }
            case 2: {
                return (int)(degrees / 0.45);
            }
            case 3: {
                return (int)(degrees / 0.225);
            }
        }
        return 0;
    }
}

