/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.servo.impl;

import com.pi4j.component.ComponentBase;
import com.pi4j.component.servo.Servo;
import com.pi4j.component.servo.ServoDriver;
import com.pi4j.io.gpio.exception.ValidationException;
import java.util.Map;

public class GenericServo
extends ComponentBase
implements Servo {
    public static final float PWM_MIN = 900.0f;
    public static final float PWM_NEUTRAL = 1500.0f;
    public static final float PWM_MAX = 2100.0f;
    private ServoDriver servoDriver;
    private float position;
    private int pwmDuration;
    private float pwmDurationEndPointLeft = -1.0f;
    private float pwmDurationNeutral = -1.0f;
    private float pwmDurationEndPointRight = -1.0f;
    private boolean isReverse = false;

    public GenericServo(ServoDriver servoDriver, String name) {
        this(servoDriver, name, null);
    }

    public GenericServo(ServoDriver servoDriver, String name, Map<String, String> properties) {
        this.setServoDriver(servoDriver);
        this.setName(name);
        if (properties != null && !properties.isEmpty()) {
            for (String key : properties.keySet()) {
                this.setProperty(key, properties.get(key));
            }
        } else {
            this.init();
        }
    }

    protected void setServoDriver(ServoDriver servoDriver) {
        this.servoDriver = servoDriver;
    }

    @Override
    public ServoDriver getServoDriver() {
        return this.servoDriver;
    }

    @Override
    public void setPosition(float position) {
        this.position = this.validatePosition(position);
        this.pwmDuration = this.calculatePwmDuration(position);
        this.servoDriver.setServoPulseWidth(this.pwmDuration);
    }

    @Override
    public float getPosition() {
        return this.position;
    }

    @Override
    public void off() {
        this.servoDriver.setServoPulseWidth(0);
    }

    protected int getPwmDuration() {
        return this.pwmDuration;
    }

    @Override
    public void setProperty(String key, String value) {
        super.setProperty(key, value);
        this.init();
    }

    protected void init() {
        this.pwmDurationEndPointLeft = this.calculateEndPointPwmDuration(Orientation.LEFT);
        this.pwmDurationEndPointRight = this.calculateEndPointPwmDuration(Orientation.RIGHT);
        this.pwmDurationNeutral = this.calculateNeutralPwmDuration();
        this.isReverse = Boolean.parseBoolean(this.getProperty("isReverse", "false"));
    }

    float calculateEndPointPwmDuration(Orientation orientation) {
        String propertyName;
        if (orientation == Orientation.LEFT) {
            propertyName = "endPointLeft";
        } else if (orientation == Orientation.RIGHT) {
            propertyName = "endPointRight";
        } else {
            throw new UnsupportedOperationException("Unsupported orientation: " + orientation.toString());
        }
        float endPointValue = Float.parseFloat(this.getProperty(propertyName, "100.0"));
        this.validateEndPoint(endPointValue, propertyName);
        float calculatedPwmDuration = orientation == Orientation.LEFT ? this.calculateNeutralPwmDuration() - 4.0f * endPointValue : this.calculateNeutralPwmDuration() + 4.0f * endPointValue;
        float result = calculatedPwmDuration < 900.0f ? 900.0f : (calculatedPwmDuration > 2100.0f ? 2100.0f : calculatedPwmDuration);
        return result;
    }

    float calculateNeutralPwmDuration() {
        float subtrimValue = Float.parseFloat(this.getProperty("subtrim", PROP_SUBTRIM_DEFAULT));
        this.validateSubtrim(subtrimValue, "subtrim");
        return 1500.0f + subtrimValue;
    }

    int calculatePwmDuration(float position) {
        if (this.isReverse) {
            position = -position;
        }
        float result = position < 0.0f ? (float)((int)((double)this.pwmDurationNeutral + (double)((this.pwmDurationNeutral - this.pwmDurationEndPointLeft) * position) / 100.0)) : (position > 0.0f ? (float)((int)((double)this.pwmDurationNeutral + (double)((this.pwmDurationEndPointRight - this.pwmDurationNeutral) * position) / 100.0)) : (float)((int)this.pwmDurationNeutral));
        return (int)(result * (float)this.servoDriver.getServoPulseResolution() / 1000.0f);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Position [").append(this.position).append("]");
        for (Map.Entry<String, String> property : this.getProperties().entrySet()) {
            result.append(", ").append(property.getKey()).append(" [").append(property.getValue()).append("]");
        }
        return result.toString();
    }

    private float validateEndPoint(float endPoint, String propertyName) {
        if (endPoint < 0.0f || endPoint > 150.0f) {
            throw new ValidationException("Value of property [" + propertyName + "] must be between " + 0.0f + " and " + 150.0f + " but is [" + endPoint + "]");
        }
        return endPoint;
    }

    private float validateSubtrim(float subtrim, String propertyName) {
        if (subtrim < -200.0f || subtrim > 200.0f) {
            throw new ValidationException("Value of property [" + propertyName + "] must be between " + -200.0f + " and +" + 200.0f + " but is [" + subtrim + "]");
        }
        return subtrim;
    }

    private float validatePosition(float position) {
        if (position < -100.0f || position > 100.0f) {
            throw new ValidationException("Position [" + position + "] must be between " + -100.0f + "(%) and +" + 100.0f + "(%) but is [" + position + "]");
        }
        return position;
    }

    public static enum Orientation {
        LEFT,
        RIGHT;

    }
}

