/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.servo.impl;

import com.pi4j.component.servo.ServoDriver;
import com.pi4j.gpio.extension.pca.PCA9685GpioProvider;
import com.pi4j.io.gpio.Pin;
import java.math.BigDecimal;

public class PCA9685GpioServoDriver
implements ServoDriver {
    private PCA9685GpioProvider provider;
    private Pin pin;
    private int position;
    private int resolution;

    public PCA9685GpioServoDriver(PCA9685GpioProvider provider, Pin pin) {
        this.setProvider(provider);
        this.setPin(pin);
        this.updateResolution();
    }

    protected void setProvider(PCA9685GpioProvider provider) {
        this.provider = provider;
    }

    public PCA9685GpioProvider getProvider() {
        return this.provider;
    }

    protected void setPin(Pin pin) {
        this.pin = pin;
    }

    @Override
    public Pin getPin() {
        return this.pin;
    }

    @Override
    public int getServoPulseWidth() {
        return this.position;
    }

    @Override
    public void setServoPulseWidth(int position) {
        this.position = position;
        this.getProvider().setPwm(this.getPin(), position);
    }

    @Override
    public int getServoPulseResolution() {
        return this.resolution;
    }

    protected void updateResolution() {
        this.resolution = new BigDecimal(4096).divide(this.getProvider().getFrequency(), 5).intValue();
    }
}

