/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.temperature.impl;

import com.pi4j.component.temperature.TemperatureSensor;
import com.pi4j.component.temperature.TemperatureSensorBase;
import com.pi4j.io.w1.W1Device;
import com.pi4j.io.w1.W1DeviceType;
import com.pi4j.temperature.TemperatureScale;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TmpDS18B20DeviceType
implements W1DeviceType {
    public static final int FAMILY_CODE = 40;

    public int getDeviceFamilyCode() {
        return 40;
    }

    public Class<? extends W1Device> getDeviceClass() {
        return TmpDS18B20.class;
    }

    public TmpDS18B20 create(File deviceDir) {
        return new TmpDS18B20(deviceDir);
    }

    static class TmpDS18B20
    extends TemperatureSensorBase
    implements TemperatureSensor,
    W1Device {
        private final Logger log = Logger.getLogger(TmpDS18B20.class.getName());
        private final String id;
        private File deviceDir;
        private double lastGoodTemperature = Double.NaN;
        private final Pattern VALUE_PATTERN = Pattern.compile("(?s).*crc=[0-9a-f]+ (?<success>[A-Z]+).*t=(?<temp>-?[0-9]+)");

        public String getId() {
            return this.id;
        }

        public TmpDS18B20(File deviceDir) {
            String deviceName;
            try {
                deviceName = new String(Files.readAllBytes(new File(deviceDir, "name").toPath()));
            }
            catch (IOException e) {
                deviceName = deviceDir.getName();
            }
            if (deviceName.endsWith("\n")) {
                deviceName = deviceName.substring(0, deviceName.length() - 1);
            }
            this.id = deviceName;
            this.setName(deviceName);
            this.deviceDir = deviceDir;
        }

        @Override
        public double getTemperature() {
            double temperature = this.lastGoodTemperature;
            try {
                String value = this.getValue();
                temperature = this.parseValue(value);
            }
            catch (Exception e) {
                this.log.warning("Error reading temperature - returning last known temperature - " + e.toString());
            }
            return temperature;
        }

        private double parseValue(String value) throws Exception {
            double result = Double.NaN;
            Matcher matcher = this.VALUE_PATTERN.matcher(value.trim());
            if (matcher.matches()) {
                if (!matcher.group("success").equals("YES")) {
                    throw new Exception("temperature value is not valid: " + value);
                }
            } else {
                throw new Exception("value regex didn't match");
            }
            int tempValue = Integer.valueOf(matcher.group("temp"));
            BigDecimal bd = BigDecimal.valueOf(tempValue);
            bd = bd.movePointLeft(3);
            bd = bd.setScale(1, RoundingMode.HALF_UP);
            result = bd.doubleValue();
            return result;
        }

        @Override
        public TemperatureScale getScale() {
            return TemperatureScale.CELSIUS;
        }

        public int getFamilyId() {
            return 40;
        }

        public String getValue() throws IOException {
            return new String(Files.readAllBytes(new File(this.deviceDir, "w1_slave").toPath()));
        }

        public boolean equals(Object obj) {
            return obj instanceof W1Device && this.id.equals(((W1Device)obj).getId());
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

