/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device.pibrella.impl;

import com.pi4j.component.button.Button;
import com.pi4j.component.button.impl.GpioButtonComponent;
import com.pi4j.component.buzzer.Buzzer;
import com.pi4j.component.light.LED;
import com.pi4j.component.light.impl.GpioLEDComponent;
import com.pi4j.device.DeviceBase;
import com.pi4j.device.pibrella.Pibrella;
import com.pi4j.device.pibrella.PibrellaBuzzer;
import com.pi4j.device.pibrella.PibrellaInput;
import com.pi4j.device.pibrella.PibrellaLed;
import com.pi4j.device.pibrella.PibrellaOutput;
import com.pi4j.device.pibrella.impl.PibrellaBuzzerImpl;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.PinState;

public abstract class PibrellaBase
extends DeviceBase
implements Pibrella {
    private final GpioController gpio = GpioFactory.getInstance();
    private GpioPinDigitalInput[] inputPins = new GpioPinDigitalInput[]{this.gpio.provisionDigitalInputPin(PibrellaInput.A.getPin(), "INPUT A"), this.gpio.provisionDigitalInputPin(PibrellaInput.B.getPin(), "INPUT B"), this.gpio.provisionDigitalInputPin(PibrellaInput.C.getPin(), "INPUT C"), this.gpio.provisionDigitalInputPin(PibrellaInput.D.getPin(), "INPUT D"), this.gpio.provisionDigitalInputPin(PibrellaInput.Button.getPin(), "BUTTON")};
    private GpioPinDigitalOutput[] outputPins = new GpioPinDigitalOutput[]{this.gpio.provisionDigitalOutputPin(PibrellaOutput.E.getPin(), "OUTPUT E"), this.gpio.provisionDigitalOutputPin(PibrellaOutput.F.getPin(), "OUTPUT F"), this.gpio.provisionDigitalOutputPin(PibrellaOutput.G.getPin(), "OUTPUT G"), this.gpio.provisionDigitalOutputPin(PibrellaOutput.H.getPin(), "OUTPUT H"), this.gpio.provisionDigitalOutputPin(PibrellaOutput.LED_RED.getPin(), "RED LED"), this.gpio.provisionDigitalOutputPin(PibrellaOutput.LED_YELLOW.getPin(), "YELLOW LED"), this.gpio.provisionDigitalOutputPin(PibrellaOutput.LED_GREEN.getPin(), "GREEN LED")};
    private GpioPinPwmOutput pwmOutput = this.gpio.provisionPwmOutputPin(PibrellaBuzzer.BUZZER.getPin());
    private Button button;
    private LED[] leds;
    private Buzzer buzzer;

    public PibrellaBase() {
        this.gpio.setShutdownOptions(Boolean.valueOf(true), (GpioPin[])this.inputPins);
        this.gpio.setShutdownOptions(Boolean.valueOf(true), PinState.LOW, new GpioPin[]{this.pwmOutput});
        this.gpio.setShutdownOptions(Boolean.valueOf(true), PinState.LOW, (GpioPin[])this.outputPins);
        this.pwmOutput.setShutdownOptions(Boolean.valueOf(true));
        this.inputPins[4].setDebounce(20);
        this.button = new GpioButtonComponent(this.inputPins[4], PinState.LOW, PinState.HIGH);
        this.leds = new LED[]{new GpioLEDComponent(this.outputPins[4]), new GpioLEDComponent(this.outputPins[5]), new GpioLEDComponent(this.outputPins[6])};
        this.buzzer = new PibrellaBuzzerImpl(this.pwmOutput);
        this.buzzer.stop();
    }

    @Override
    public GpioController getGpio() {
        return this.gpio;
    }

    @Override
    public GpioController gpio() {
        return this.getGpio();
    }

    @Override
    public GpioPinDigitalInput[] getInputPins() {
        return this.inputPins;
    }

    @Override
    public GpioPinDigitalInput getInputPin(int index) {
        return this.inputPins[index];
    }

    @Override
    public GpioPinDigitalInput getInputPin(PibrellaInput input) {
        return this.getInputPin(input.getIndex());
    }

    @Override
    public GpioPinDigitalInput inputA() {
        return this.getInputPin(PibrellaInput.A);
    }

    @Override
    public GpioPinDigitalInput inputB() {
        return this.getInputPin(PibrellaInput.B);
    }

    @Override
    public GpioPinDigitalInput inputC() {
        return this.getInputPin(PibrellaInput.C);
    }

    @Override
    public GpioPinDigitalInput inputD() {
        return this.getInputPin(PibrellaInput.D);
    }

    @Override
    public GpioPinDigitalOutput[] getOutputPins() {
        return this.outputPins;
    }

    @Override
    public GpioPinDigitalOutput getOutputPin(int index) {
        return this.outputPins[index];
    }

    @Override
    public GpioPinDigitalOutput getOutputPin(PibrellaOutput output) {
        return this.getOutputPin(output.getIndex());
    }

    @Override
    public GpioPinDigitalOutput outputE() {
        return this.getOutputPin(PibrellaOutput.E);
    }

    @Override
    public GpioPinDigitalOutput outputF() {
        return this.getOutputPin(PibrellaOutput.F);
    }

    @Override
    public GpioPinDigitalOutput outputG() {
        return this.getOutputPin(PibrellaOutput.G);
    }

    @Override
    public GpioPinDigitalOutput outputH() {
        return this.getOutputPin(PibrellaOutput.H);
    }

    @Override
    public LED[] getLeds() {
        return this.leds;
    }

    @Override
    public LED getLed(int index) {
        return this.leds[index];
    }

    @Override
    public LED getLed(PibrellaLed led) {
        return this.leds[led.getIndex()];
    }

    @Override
    public LED ledRed() {
        return this.getLed(PibrellaLed.RED.getIndex());
    }

    @Override
    public LED ledYellow() {
        return this.getLed(PibrellaLed.YELLOW.getIndex());
    }

    @Override
    public LED ledGreen() {
        return this.getLed(PibrellaLed.GREEN.getIndex());
    }

    @Override
    public Button getButton() {
        return this.button;
    }

    @Override
    public Button button() {
        return this.getButton();
    }

    @Override
    public Buzzer getBuzzer() {
        return this.buzzer;
    }

    @Override
    public Buzzer buzzer() {
        return this.getBuzzer();
    }
}

