/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device.pibrella.impl;

import com.pi4j.component.buzzer.Buzzer;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.wiringpi.Gpio;

public class PibrellaBuzzerImpl
implements Buzzer {
    public static int STOP_FREQUENCY = 0;
    protected final GpioPinPwmOutput pwm;

    public PibrellaBuzzerImpl(GpioPinPwmOutput pwm) {
        this.pwm = pwm;
        Gpio.pwmSetMode((int)0);
    }

    @Override
    public void buzz(int frequency) {
        if (frequency == 0) {
            this.pwm.setPwm(frequency);
        } else {
            int range = 600000 / frequency;
            Gpio.pwmSetRange((int)range);
            this.pwm.setPwm(frequency / 2);
        }
    }

    @Override
    public void buzz(int frequency, int duration) {
        this.buzz(frequency);
        Gpio.delay((long)duration);
        this.stop();
    }

    @Override
    public void stop() {
        this.buzz(STOP_FREQUENCY);
    }
}

