/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import com.codeminders.hidapi.AD800;
import com.codeminders.hidapi.HIDDevice;
import com.codeminders.hidapi.HIDManager;
import com.codeminders.hidapi.LineMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.TimeUnit;

public class AD102
extends Observable
implements Runnable {
    public static final String TAG = "USBController";
    HIDDevice a;
    HIDManager b;
    private int iLineId = 0;
    public static AD800 channel;
    public static String DeviceSN;
    public static String DeviceVer;
    public List<byte[]> m_ReadBuffList = new ArrayList<byte[]>();
    public List<byte[]> m_WriteBuffList = new ArrayList<byte[]>();
    private static final Object[] sWriteLock;
    private static final Object[] sReadLock;
    public byte m_DataPackIndex = 0;
    private int m_MemBuffLen = 0;
    private byte[] m_MemBuffer = new byte[256];
    private UsbReadRunnable mReadLoop;
    private UsbWriteRunnable mWriteLoop;
    private UsbRunnable mLoop;
    private CountRunnable mCountLoop;
    private Thread mUsbThread;
    private Thread mUsbReadThread;
    private Thread mUsbWriteThread;
    private Thread mCountThread;
    private boolean mStop = false;

    public AD102(String string, int n2) {
        channel = new AD800(this);
        this.b = HIDManager.getInstance();
        this.a = this.b.openByPath(string);
        this.iLineId = n2;
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            while (!this.mStop) {
                try {
                    byte[] byArray;
                    block20: {
                        block19: {
                            try {
                                if (!this.IsThereAnyReceivedData()) {
                                    this.Sleep(1);
                                }
                                break block19;
                            }
                            catch (Exception exception) {
                                this.e("IsThereAnyReceivedData: " + exception.getMessage());
                                this.Sleep(1);
                            }
                            continue;
                        }
                        try {
                            byArray = this.GetReceivedDataFromQueue();
                            if (byArray == null) {
                                this.Sleep(1);
                            }
                            break block20;
                        }
                        catch (Exception exception) {
                            this.Sleep(1);
                        }
                        continue;
                    }
                    try {
                        n2 = byArray[1] - 4;
                        n4 = byArray[3] & 0x7F;
                        n3 = 6;
                        if (n4 < 0 || n4 >= 8 || n2 < 0) {
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        this.e("UsbRunnable Middle: " + exception.getMessage());
                    }
                    if (this.mStop) break;
                    try {
                        channel.GetVoltage((byArray[4] << 8) + byArray[5] & 0xFFFF);
                    }
                    catch (Exception exception) {
                        this.e("UsbRunnable Voltage: " + exception.getMessage());
                    }
                    try {
                        byte by;
                        while (n2 > 0 && (by = byArray[n3 + 1]) < n2) {
                            this.AnalyseCommand(n4, byArray, n3, by + 2);
                            n2 -= by + 2;
                            n3 += by + 2;
                        }
                    }
                    catch (Exception exception) {
                        this.e("UsbRunnable Analyze;" + exception.getLocalizedMessage());
                    }
                }
                catch (Exception exception) {
                    this.e("UsbRunnable Exception:" + exception.getLocalizedMessage());
                }
            }
            this.a.close();
            this.b.release();
            System.gc();
            return;
        }
        catch (Exception exception) {
            this.e("UsbRunnable out Exception:" + exception.getLocalizedMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsThereAnyReceivedData() {
        Object[] objectArray = sReadLock;
        synchronized (sReadLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !this.m_ReadBuffList.isEmpty();
        }
    }

    public AD800 getChannel() {
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsThereAnySentData() {
        Object[] objectArray = sWriteLock;
        synchronized (sWriteLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !this.m_WriteBuffList.isEmpty();
        }
    }

    public void SendDeviceCheckControlCmd() {
        byte[] byArray = new byte[64];
        for (int i2 = 0; i2 < 64; ++i2) {
            byArray[i2] = 0;
        }
        byArray[0] = 2;
        byArray[1] = 7;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 48;
        byArray[7] = 1;
        byArray[8] = -1;
        try {
            this.a.write(byArray);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] GetSentDataFromQueue() {
        try {
            Object[] objectArray = sWriteLock;
            synchronized (sWriteLock) {
                byte[] byArray = this.m_WriteBuffList.get(0);
                this.m_WriteBuffList.remove(0);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return byArray;
            }
        }
        catch (Exception exception) {
            this.e("GetWriteDataFromQueue exception " + exception.getLocalizedMessage());
            this.m_WriteBuffList.remove(0);
            return null;
        }
    }

    private void Sleep(int n2) {
        try {
            Thread.sleep(n2);
            return;
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
    }

    public void l(Object object) {
        System.out.println("USBController>==< " + object.toString() + " >==<");
    }

    public void e(Object object) {
        System.err.println("USBController>==< " + object.toString() + " >==<");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] GetReceivedDataFromQueue() {
        try {
            Object[] objectArray = sReadLock;
            synchronized (sReadLock) {
                byte[] byArray = this.m_ReadBuffList.get(0);
                this.m_ReadBuffList.remove(0);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return byArray;
            }
        }
        catch (Exception exception) {
            this.m_ReadBuffList.remove(0);
            return null;
        }
    }

    private void AnalyseCommand(int n2, byte[] byArray, int n3, int n4) {
        if (n2 < 0 || n2 >= 8) {
            return;
        }
        block0 : switch (byArray[n3]) {
            case 48: {
                if (byArray[n3 + 2] != 0) break;
                n4 = byArray[n3 + 1] - 1;
                AD102 aD102 = this;
                switch (byArray[n3 += 3]) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                    case 3: {
                        String string = "";
                        for (int i2 = 1; i2 < n4; ++i2) {
                            string = i2 == n4 - 1 ? string + byArray[n3 + i2] : string + byArray[n3 + i2] + ".";
                        }
                        aD102.getChannel().Version = string;
                        aD102.notifyParent(new LineMessage(aD102.getLineId(), 0, 0));
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                    case 7: {
                        break block0;
                    }
                    case 8: {
                        break block0;
                    }
                    case 9: {
                        break block0;
                    }
                    case 10: {
                        break block0;
                    }
                    case 11: {
                        break block0;
                    }
                    case 16: {
                        break block0;
                    }
                    case 17: {
                        int n5 = n4 - 1;
                        if (n5 <= 0) break block0;
                        if (aD102.m_MemBuffLen + n5 <= 128) {
                            System.arraycopy(byArray, n3 + 1, aD102.m_MemBuffer, aD102.m_MemBuffLen, n5);
                            aD102.m_MemBuffLen += n5;
                        }
                        if (aD102.m_MemBuffLen >= 128) {
                            aD102.m_MemBuffLen = 0;
                            int n6 = aD102.m_MemBuffer[1] & 0xFF;
                            n6 |= (aD102.m_MemBuffer[2] & 0xFF) << 8;
                            n6 |= (aD102.m_MemBuffer[3] & 0xFF) << 16;
                            if ((n6 |= (aD102.m_MemBuffer[4] & 0xFF) << 24) != -1) {
                                aD102.getChannel().Serial = DeviceSN = String.format("%08d", n6);
                                aD102.notifyParent(new LineMessage(aD102.getLineId(), 0, 0));
                            }
                        }
                    }
                    default: {
                        return;
                    }
                }
            }
            case 49: {
                channel.FskData(byArray, n3 + 2, byArray[n3 + 1]);
                return;
            }
            case 50: {
                channel.DTMFData(byArray, n3 + 2, byArray[n3 + 1]);
            }
        }
    }

    private void AnalyseACKCommand$101cc16b(byte[] byArray, int n2, int n3) {
        switch (byArray[n2]) {
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                String string = "";
                for (int i2 = 1; i2 < n3; ++i2) {
                    string = i2 == n3 - 1 ? string + byArray[n2 + i2] : string + byArray[n2 + i2] + ".";
                }
                this.getChannel().Version = string;
                this.notifyParent(new LineMessage(this.getLineId(), 0, 0));
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
            case 7: {
                return;
            }
            case 8: {
                return;
            }
            case 9: {
                return;
            }
            case 10: {
                return;
            }
            case 11: {
                return;
            }
            case 16: {
                return;
            }
            case 17: {
                int n4 = n3 - 1;
                if (n4 <= 0) {
                    return;
                }
                if (this.m_MemBuffLen + n4 <= 128) {
                    System.arraycopy(byArray, n2 + 1, this.m_MemBuffer, this.m_MemBuffLen, n4);
                    this.m_MemBuffLen += n4;
                }
                if (this.m_MemBuffLen < 128) break;
                this.m_MemBuffLen = 0;
                int n5 = this.m_MemBuffer[1] & 0xFF;
                n5 |= (this.m_MemBuffer[2] & 0xFF) << 8;
                n5 |= (this.m_MemBuffer[3] & 0xFF) << 16;
                if ((n5 |= (this.m_MemBuffer[4] & 0xFF) << 24) == -1) break;
                this.getChannel().Serial = DeviceSN = String.format("%08d", n5);
                this.notifyParent(new LineMessage(this.getLineId(), 0, 0));
            }
        }
    }

    public void SendHangUpCommand(int n2) {
        int n3;
        int n4 = n2;
        n2 = 4;
        byte[] byArray = new byte[]{48, 2, 10, 0};
        int n5 = n4;
        AD102 aD102 = this;
        byte[] byArray2 = new byte[64];
        for (n3 = 0; n3 < 64; ++n3) {
            byArray2[n3] = 0;
        }
        byArray2[0] = 2;
        byArray2[1] = 8;
        byArray2[2] = aD102.m_DataPackIndex;
        byArray2[3] = (byte)(n5 % 8);
        byArray2[4] = 0;
        byArray2[5] = 0;
        for (n3 = 0; n3 < 4; ++n3) {
            byArray2[n3 + 6] = byArray[n3];
        }
        aD102.m_WriteBuffList.add(byArray2);
        aD102.m_DataPackIndex = (byte)(aD102.m_DataPackIndex + 1);
        if (aD102.m_DataPackIndex > 255) {
            aD102.m_DataPackIndex = 0;
        }
    }

    private void SendDataToDevice(int n2, byte[] byArray, int n3) {
        int n4;
        byte[] byArray2 = new byte[64];
        for (n4 = 0; n4 < 64; ++n4) {
            byArray2[n4] = 0;
        }
        byArray2[0] = 2;
        byArray2[1] = 8;
        byArray2[2] = this.m_DataPackIndex;
        byArray2[3] = (byte)(n2 % 8);
        byArray2[4] = 0;
        byArray2[5] = 0;
        for (n4 = 0; n4 < 4; ++n4) {
            byArray2[n4 + 6] = byArray[n4];
        }
        this.m_WriteBuffList.add(byArray2);
        this.m_DataPackIndex = (byte)(this.m_DataPackIndex + 1);
        if (this.m_DataPackIndex > 255) {
            this.m_DataPackIndex = 0;
        }
    }

    public void stop() {
        this.deleteObservers();
        this.mStop = true;
        this.notifyParent(new LineMessage(this.getLineId(), 1, 1));
        this.Sleep(10);
        if (this.mStop) {
            this.mLoop = null;
            this.mUsbThread = null;
            this.mReadLoop = null;
            this.mWriteLoop = null;
            this.mUsbReadThread = null;
            this.mUsbWriteThread = null;
            this.mCountLoop = null;
            this.mCountThread = null;
            channel = null;
            try {
                this.a.close();
                this.b.release();
                System.gc();
            }
            catch (Exception exception) {
                this.notifyParent(new LineMessage(this.getLineId(), 1, 1));
            }
        }
        this.l("stop");
    }

    private void start() {
        this.l("start handler");
        try {
            if (this.mLoop != null) {
                this.mStop = false;
                this.l("Running already");
                return;
            }
            this.mLoop = null;
            this.mUsbThread = null;
            this.mReadLoop = null;
            this.mWriteLoop = null;
            this.mUsbReadThread = null;
            this.mUsbWriteThread = null;
            this.mCountLoop = null;
            this.mCountThread = null;
            this.mStop = false;
            if (this.mStop) {
                return;
            }
            this.mReadLoop = new UsbReadRunnable(this, 0);
            this.mWriteLoop = new UsbWriteRunnable(this, 0);
            this.mLoop = new UsbRunnable(this, 0);
            this.mCountLoop = new CountRunnable(this, 0);
            this.mUsbReadThread = new Thread(this.mReadLoop);
            this.mUsbReadThread.setPriority(10);
            this.mUsbReadThread.start();
            this.mUsbWriteThread = new Thread(this.mWriteLoop);
            this.mUsbWriteThread.setPriority(10);
            this.mUsbWriteThread.start();
            this.mUsbThread = new Thread(this.mLoop);
            this.mUsbThread.setPriority(10);
            this.mUsbThread.start();
            this.mCountThread = new Thread(this.mCountLoop);
            this.mCountThread.setPriority(10);
            this.mCountThread.start();
            this.notifyParent(new LineMessage(this.getLineId(), 1, AD102.channel.m_State));
            this.l("handler init end");
            return;
        }
        catch (Exception exception) {
            this.e(exception);
            return;
        }
    }

    private void notifyParent(LineMessage lineMessage) {
        this.setChanged();
        this.notifyObservers(lineMessage);
    }

    public int getLineId() {
        return this.iLineId;
    }

    private void GetSnAndVersion() {
        int n2 = 0;
        while ((DeviceSN == "" || DeviceVer == "") && n2++ <= 0) {
            this.m_DataPackIndex = 0;
            while (this.m_DataPackIndex < 22) {
                if (this.mStop) {
                    return;
                }
                try {
                    byte[] byArray = new byte[512];
                    int n3 = this.a.read(byArray);
                    if (n3 > 0) {
                        if (byArray[0] == 3 && byArray[1] > 4) {
                            this.AnalyseCommand(0, byArray, 6, byArray[7] + 2);
                        }
                        byArray = new byte[64];
                        for (n3 = 0; n3 < 64; ++n3) {
                            byArray[n3] = 0;
                        }
                        if (this.m_DataPackIndex == 0) {
                            byArray[0] = 2;
                            byArray[1] = 7;
                            byArray[6] = 48;
                            byArray[7] = 1;
                            byArray[8] = 3;
                        } else if (this.m_DataPackIndex == 1) {
                            byArray[0] = 2;
                            byArray[1] = 9;
                            byArray[2] = 1;
                            byArray[6] = 48;
                            byArray[7] = 3;
                            byArray[8] = 17;
                            byArray[9] = 0;
                            byArray[10] = 30;
                        } else if (this.m_DataPackIndex == 2) {
                            byArray[0] = 2;
                            byArray[1] = 9;
                            byArray[2] = 2;
                            byArray[6] = 48;
                            byArray[7] = 3;
                            byArray[8] = 17;
                            byArray[9] = 30;
                            byArray[10] = 30;
                        } else if (this.m_DataPackIndex == 3) {
                            byArray[0] = 2;
                            byArray[1] = 9;
                            byArray[2] = 3;
                            byArray[6] = 48;
                            byArray[7] = 3;
                            byArray[8] = 17;
                            byArray[9] = 60;
                            byArray[10] = 30;
                        } else if (this.m_DataPackIndex == 4) {
                            byArray[0] = 2;
                            byArray[1] = 9;
                            byArray[2] = 4;
                            byArray[6] = 48;
                            byArray[7] = 3;
                            byArray[8] = 17;
                            byArray[9] = 90;
                            byArray[10] = 30;
                        } else if (this.m_DataPackIndex == 5) {
                            byArray[0] = 2;
                            byArray[1] = 9;
                            byArray[2] = 84;
                            byArray[6] = 48;
                            byArray[7] = 3;
                            byArray[8] = 17;
                            byArray[9] = 120;
                            byArray[10] = 8;
                        } else if (this.m_DataPackIndex > 5 && this.m_DataPackIndex < 22) {
                            if (this.m_DataPackIndex % 2 == 0) {
                                byArray[0] = 2;
                                byArray[1] = 9;
                                byArray[2] = this.m_DataPackIndex;
                                byArray[3] = (byte)((this.m_DataPackIndex - 4) / 2 - 1);
                                byArray[6] = 48;
                                byArray[7] = 3;
                                byArray[8] = 5;
                                byArray[9] = 11;
                                byArray[10] = 0;
                            } else {
                                byArray[0] = 2;
                                byArray[1] = 9;
                                byArray[2] = this.m_DataPackIndex;
                                byArray[3] = (byte)((this.m_DataPackIndex - 5) / 2 - 1);
                                byArray[6] = 48;
                                byArray[7] = 3;
                                byArray[8] = 4;
                                byArray[9] = 4;
                                byArray[10] = 32;
                            }
                        }
                        this.a.write(byArray);
                    }
                }
                catch (Exception exception) {
                    this.e("transfer:" + exception.getLocalizedMessage());
                }
                this.m_DataPackIndex = (byte)(this.m_DataPackIndex + 1);
            }
        }
    }

    public static String milliToString(long l2) {
        long l3 = TimeUnit.MILLISECONDS.toHours(l2) % 24L;
        long l4 = TimeUnit.MILLISECONDS.toMinutes(l2) % 60L;
        long l5 = TimeUnit.MILLISECONDS.toSeconds(l2) % 60L;
        long l6 = l2 % 1000L;
        String string = String.format("%02d:%02d:%02d.%03d", l3, l4, l5, l6);
        return string;
    }

    static /* synthetic */ boolean a(AD102 aD102, boolean bl2) {
        aD102.mStop = true;
        return true;
    }

    static {
        DeviceSN = "";
        DeviceVer = "";
        sWriteLock = new Object[0];
        sReadLock = new Object[0];
    }

    private class CountRunnable
    implements Runnable {
        private /* synthetic */ AD102 this$0;

        private CountRunnable(AD102 aD102) {
            this.this$0 = aD102;
        }

        @Override
        public void run() {
            while (!this.this$0.mStop) {
                this.this$0.Sleep(1);
                try {
                    int n2;
                    AD102.channel.m_CheckVoltageTime += 10;
                    if (4 == AD102.channel.m_State || 5 == AD102.channel.m_State) {
                        AD102.channel.m_RingDuration += 10;
                    }
                    if (6 == AD102.channel.m_State || 7 == AD102.channel.m_State) {
                        AD102.channel.m_CallDuration += 10;
                    }
                    if (AD102.channel.m_CheckVoltageTime >= 100 && AD102.channel.m_VoltageIndex > 0) {
                        n2 = 0;
                        AD102.channel.m_RingOn1 = 0;
                        AD102.channel.m_RingOn2 = 0;
                        int n3 = AD102.channel.m_VoltageValue / AD102.channel.m_VoltageIndex;
                        this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 2, n3));
                        if (1 == AD102.channel.m_State || 2 == AD102.channel.m_State || 4 == AD102.channel.m_State || 5 == AD102.channel.m_State) {
                            n2 = 1;
                        }
                        if (n2 != 0) {
                            for (int i2 = 0; i2 < 256; ++i2) {
                                if (AD102.channel.m_VoltageArray[i2] >= 24) {
                                    ++AD102.channel.m_RingOn1;
                                }
                                if (AD102.channel.m_VoltageArray[i2] <= -24) {
                                    ++AD102.channel.m_RingOn2;
                                }
                                AD102.channel.m_VoltageArray[i2] = 0;
                            }
                        }
                        AD102.channel.m_CheckVoltageTime = 0;
                        AD102.channel.m_VoltageValue = 0;
                        AD102.channel.m_VoltageIndex = 0;
                        if (n2 != 0 && AD102.channel.m_RingOn1 >= 2 && AD102.channel.m_RingOn2 >= 2) {
                            if (!AD102.channel.m_bCheckRingOn) {
                                AD102.channel.m_bCheckRingOn = true;
                                AD102.channel.m_CheckRingOnTime = 0;
                            }
                            if (!AD102.channel.m_bCheckRingOn) continue;
                            AD102.channel.m_CheckRingOnTime += 100;
                            if (AD102.channel.m_CheckRingOnTime < 200) continue;
                            AD102.channel.m_bCheckIdle = false;
                            AD102.channel.m_CheckIdleTime = 0;
                            AD102.channel.m_bCheckPowerOff = false;
                            AD102.channel.m_CheckPowerOffTime = 0;
                            AD102.channel.m_bCheckHookOff = false;
                            AD102.channel.m_CheckHookOffTime = 0;
                            AD102.channel.m_bCheckRingOn = false;
                            AD102.channel.m_CheckRingOnTime = 0;
                            AD102.channel.m_bInbound = true;
                            ++AD102.channel.m_RingCnt;
                            if (4 == AD102.channel.m_State) continue;
                            AD102.channel.m_State = 4;
                            this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 1, AD102.channel.m_State));
                            continue;
                        }
                        if (4 == AD102.channel.m_State && (AD102.channel.m_RingOn1 >= 2 || AD102.channel.m_RingOn2 >= 2)) {
                            if (5 == AD102.channel.m_State) continue;
                            AD102.channel.m_RingOffTime = 0;
                            AD102.channel.m_State = 5;
                            this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 5, AD102.channel.m_State));
                            continue;
                        }
                        if (5 == AD102.channel.m_State) {
                            AD102.channel.m_RingOffTime += 100;
                            if (AD102.channel.m_RingOffTime >= 3700 && !AD102.channel.m_bCheckIdle) {
                                AD102.channel.m_bCheckIdle = true;
                                AD102.channel.m_CheckIdleTime = 0;
                            }
                        }
                        if (n3 <= 3) {
                            if (!AD102.channel.m_bCheckPowerOff) {
                                AD102.channel.m_bCheckPowerOff = true;
                                AD102.channel.m_CheckPowerOffTime = 0;
                            }
                        } else if (n3 > 3 && n3 < 24) {
                            if (!AD102.channel.m_bCheckHookOff) {
                                AD102.channel.m_bCheckHookOff = true;
                                AD102.channel.m_CheckHookOffTime = 0;
                            }
                        } else if (n3 >= 24 && 5 != AD102.channel.m_State && !AD102.channel.m_bCheckIdle) {
                            AD102.channel.m_bCheckIdle = true;
                            AD102.channel.m_CheckIdleTime = 0;
                        }
                    }
                    if (AD102.channel.m_bCheckPowerOff) {
                        AD102.channel.m_CheckPowerOffTime += 10;
                        if (AD102.channel.m_CheckPowerOffTime >= 3000 && 1 != AD102.channel.m_State) {
                            try {
                                this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 1, AD102.channel.m_State));
                            }
                            catch (Exception exception) {
                                System.err.println("UsbController: " + exception.getLocalizedMessage());
                            }
                            AD102.channel.m_State = 1;
                            this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 1, AD102.channel.m_State));
                            AD102.channel.m_bCheckIdle = false;
                            AD102.channel.m_CheckIdleTime = 0;
                            AD102.channel.m_bCheckPowerOff = false;
                            AD102.channel.m_CheckPowerOffTime = 0;
                            AD102.channel.m_bCheckHookOff = false;
                            AD102.channel.m_CheckHookOffTime = 0;
                            AD102.channel.m_bCheckRingOn = false;
                            AD102.channel.m_CheckRingOnTime = 0;
                        }
                    }
                    if (AD102.channel.m_bCheckIdle) {
                        AD102.channel.m_CheckIdleTime += 10;
                        if (AD102.channel.m_CheckIdleTime >= 800 && 2 != AD102.channel.m_State) {
                            AD102.milliToString(AD102.channel.m_RingDuration);
                            AD102.milliToString(AD102.channel.m_CallDuration);
                            if (1 == AD102.channel.m_State) {
                                this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 1, 0));
                            } else if (4 == AD102.channel.m_State) {
                                this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 4, 0));
                            } else if (5 == AD102.channel.m_State) {
                                this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 5, 0));
                            } else if (6 == AD102.channel.m_State) {
                                this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 6, 0));
                            } else if (7 == AD102.channel.m_State) {
                                this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 7, 0));
                            }
                            AD102.channel.Dialed = "";
                            AD102.channel.m_State = 2;
                            this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 2, AD102.channel.m_State));
                            AD102.channel.m_bCheckIdle = false;
                            AD102.channel.m_CheckIdleTime = 0;
                            AD102.channel.m_bCheckPowerOff = false;
                            AD102.channel.m_CheckPowerOffTime = 0;
                            AD102.channel.m_bCheckHookOff = false;
                            AD102.channel.m_CheckHookOffTime = 0;
                            AD102.channel.m_DtmfDetectTime = 0;
                            AD102.channel.m_CallDuration = 0;
                            AD102.channel.m_bCheckRingOn = false;
                            AD102.channel.m_CheckRingOnTime = 0;
                            AD102.channel.m_RingCnt = 0;
                            AD102.channel.m_RingOn1 = 0;
                            AD102.channel.m_RingOn2 = 0;
                            AD102.channel.m_bInbound = false;
                            AD102.channel.m_RingOffTime = 0;
                            AD102.channel.m_RingDuration = 0;
                            AD102.channel.m_FSKCIDDataSize = 0;
                            AD102.channel.m_iCarry = 0;
                            AD102.channel.m_DtmfSize = 0;
                            for (n2 = 0; n2 < AD102.channel.m_DtmfNum.length; ++n2) {
                                AD102.channel.m_DtmfNum[n2] = '\u0000';
                            }
                            for (n2 = 0; n2 < AD102.channel.m_szFSKCIDData.length; ++n2) {
                                AD102.channel.m_szFSKCIDData[n2] = 0;
                            }
                            for (n2 = 0; n2 < AD102.channel.m_FskNum.length; ++n2) {
                                AD102.channel.m_FskNum[n2] = '\u0000';
                            }
                        }
                    }
                    if (!AD102.channel.m_bCheckHookOff) continue;
                    if (!AD102.channel.m_bInbound && !AD102.channel.Dtmf.isEmpty() && 7 != AD102.channel.m_State) {
                        AD102.channel.m_DtmfDetectTime += 10;
                    }
                    AD102.channel.m_CheckHookOffTime += 10;
                    if (AD102.channel.m_CheckHookOffTime < 200) continue;
                    AD102.channel.m_bCheckIdle = false;
                    AD102.channel.m_CheckIdleTime = 0;
                    AD102.channel.m_bCheckPowerOff = false;
                    AD102.channel.m_CheckPowerOffTime = 0;
                    AD102.channel.m_bCheckHookOff = false;
                    AD102.channel.m_CheckHookOffTime = 0;
                    AD102.channel.m_bCheckRingOn = false;
                    AD102.channel.m_CheckRingOnTime = 0;
                    AD102.channel.m_RingCnt = 0;
                    AD102.channel.m_RingOn1 = 0;
                    AD102.channel.m_RingOn2 = 0;
                    AD102.channel.m_RingOffTime = 0;
                    if (AD102.channel.m_bInbound) {
                        if (6 == AD102.channel.m_State) continue;
                        AD102.channel.m_CallDuration = 0;
                        AD102.channel.m_State = 6;
                        this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 1, AD102.channel.m_State));
                        continue;
                    }
                    if (AD102.channel.m_DtmfDetectTime > 4000) {
                        if (7 == AD102.channel.m_State) continue;
                        AD102.channel.m_State = 7;
                        AD102.channel.m_CallDuration = 0;
                        AD102.channel.Dialed = AD102.channel.Dtmf;
                        this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 1, AD102.channel.m_State));
                        continue;
                    }
                    if (3 == AD102.channel.m_State) continue;
                    AD102.channel.m_State = 3;
                    this.this$0.notifyParent(new LineMessage(this.this$0.getLineId(), 3, AD102.channel.m_State));
                }
                catch (Exception exception) {
                    AD102.a(this.this$0, true);
                    System.err.println("Count Service: " + exception.getMessage());
                }
            }
        }

        /* synthetic */ CountRunnable(AD102 aD102, byte by) {
            this(aD102);
        }
    }

    private class UsbRunnable
    implements Runnable {
        private /* synthetic */ AD102 this$0;

        private UsbRunnable(AD102 aD102) {
            this.this$0 = aD102;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                while (!this.this$0.mStop) {
                    try {
                        byte[] byArray;
                        block20: {
                            block19: {
                                try {
                                    if (!this.this$0.IsThereAnyReceivedData()) {
                                        this.this$0.Sleep(1);
                                    }
                                    break block19;
                                }
                                catch (Exception exception) {
                                    this.this$0.e("UsbRunnable IsThereAnyReceivedData: " + exception.getMessage());
                                    this.this$0.Sleep(1);
                                }
                                continue;
                            }
                            try {
                                byArray = this.this$0.GetReceivedDataFromQueue();
                                if (byArray == null) {
                                    this.this$0.Sleep(1);
                                }
                                break block20;
                            }
                            catch (Exception exception) {
                                this.this$0.Sleep(1);
                            }
                            continue;
                        }
                        try {
                            n2 = byArray[1] - 4;
                            n4 = byArray[3] & 0x7F;
                            n3 = 6;
                            if (n4 < 0 || n4 >= 8 || n2 < 0) {
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            this.this$0.e("UsbRunnable Middle: " + exception.getMessage());
                        }
                        if (this.this$0.mStop) break;
                        try {
                            channel.GetVoltage((byArray[4] << 8) + byArray[5] & 0xFFFF);
                        }
                        catch (Exception exception) {
                            this.this$0.e("UsbRunnable Voltage: " + exception.getMessage());
                        }
                        try {
                            byte by;
                            while (n2 > 0 && (by = byArray[n3 + 1]) < n2) {
                                this.this$0.AnalyseCommand(n4, byArray, n3, by + 2);
                                n2 -= by + 2;
                                n3 += by + 2;
                            }
                        }
                        catch (Exception exception) {
                            this.this$0.e("UsbRunnable Analyze;" + exception.getLocalizedMessage());
                        }
                    }
                    catch (Exception exception) {
                        this.this$0.e("UsbRunnable Exception:" + exception.getLocalizedMessage());
                    }
                }
                this.this$0.a.close();
                this.this$0.b.release();
                System.gc();
                return;
            }
            catch (Exception exception) {
                this.this$0.e("UsbRunnable out Exception:" + exception.getLocalizedMessage());
                return;
            }
        }

        /* synthetic */ UsbRunnable(AD102 aD102, byte by) {
            this(aD102);
        }
    }

    private class UsbWriteRunnable
    implements Runnable {
        private int FreeTime;
        private /* synthetic */ AD102 this$0;

        private UsbWriteRunnable(AD102 aD102) {
            this.this$0 = aD102;
        }

        @Override
        public void run() {
            try {
                while (!this.this$0.mStop) {
                    try {
                        this.this$0.SendDeviceCheckControlCmd();
                        this.this$0.Sleep(15000);
                    }
                    catch (Exception exception) {
                        this.this$0.stop();
                        this.this$0.e("UsbWriteRunnable Exception:" + exception.getLocalizedMessage());
                    }
                }
                this.this$0.a.close();
                this.this$0.b.release();
                System.gc();
                return;
            }
            catch (Exception exception) {
                this.this$0.stop();
                this.this$0.e("UsbWriteRunnable out Exception:" + exception.getLocalizedMessage());
                return;
            }
        }

        /* synthetic */ UsbWriteRunnable(AD102 aD102, byte by) {
            this(aD102);
        }
    }

    private class UsbReadRunnable
    implements Runnable {
        private /* synthetic */ AD102 this$0;

        private UsbReadRunnable(AD102 aD102) {
            this.this$0 = aD102;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.this$0.mStop) {
                    try {
                        byte[] byArray = new byte[64];
                        int n2 = this.this$0.a.readTimeout(byArray, 100);
                        if (this.this$0.mStop) break;
                        if (n2 <= 0 || byArray[0] != 3 || byArray[1] <= 3) continue;
                        this.this$0.m_ReadBuffList.add(byArray);
                    }
                    catch (Exception exception) {
                        this.this$0.stop();
                    }
                }
                this.this$0.a.close();
                this.this$0.b.release();
                System.gc();
                return;
            }
            catch (Exception exception) {
                this.this$0.stop();
                return;
            }
        }

        /* synthetic */ UsbReadRunnable(AD102 aD102, byte by) {
            this(aD102);
        }
    }
}

