/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import com.codeminders.hidapi.AD102;
import com.codeminders.hidapi.LineMessage;

public class AD800 {
    public String LineStatus = "";
    public int LineVoltage = 0;
    public String VoiceTrigger = "";
    public String CallerId = "";
    public String Dtmf = "";
    public String Dialed = "";
    public String Version = "";
    public String Serial = "";
    public int m_Channel;
    public int m_FSKCIDDataSize;
    public int m_iCarry;
    public byte[] m_szFSKCIDData = new byte[128];
    public char[] m_FskNum = new char[33];
    public char[] m_DtmfNum = new char[33];
    public int m_DtmfSize;
    public int m_VoltageIndex;
    public int m_VoltageValue;
    public int[] m_VoltageArray = new int[256];
    public int m_CheckVoltageTime;
    public boolean m_bCheckPowerOff;
    public int m_CheckPowerOffTime;
    public boolean m_bCheckIdle;
    public int m_CheckIdleTime;
    public boolean m_bCheckHookOff;
    public int m_CheckHookOffTime;
    public int m_DtmfDetectTime;
    public int m_CallDuration;
    public int m_RingOn1;
    public int m_RingOn2;
    public boolean m_bCheckRingOn;
    public int m_CheckRingOnTime;
    public int m_RingCnt;
    public int m_RingOffTime;
    public int m_RingDuration;
    public int m_State;
    public boolean m_bInbound;
    private AD102 parent;

    public AD800(AD102 aD102) {
        this.parent = aD102;
        this.init();
    }

    public void init() {
        int n2;
        this.LineStatus = "";
        this.LineVoltage = 0;
        this.VoiceTrigger = "";
        this.CallerId = "";
        this.Dtmf = "";
        this.Dialed = "";
        this.m_Channel = 0;
        this.m_FSKCIDDataSize = 0;
        this.m_iCarry = 0;
        for (n2 = 0; n2 < this.m_szFSKCIDData.length; ++n2) {
            this.m_szFSKCIDData[n2] = 0;
        }
        for (n2 = 0; n2 < this.m_FskNum.length; ++n2) {
            this.m_FskNum[n2] = '\u0000';
        }
        this.m_DtmfSize = 0;
        for (n2 = 0; n2 < this.m_DtmfNum.length; ++n2) {
            this.m_DtmfNum[n2] = '\u0000';
        }
        this.m_VoltageIndex = 0;
        this.m_CheckVoltageTime = 0;
        this.m_VoltageValue = 0;
        for (n2 = 0; n2 < 256; ++n2) {
            this.m_VoltageArray[n2] = 0;
        }
        this.m_bCheckPowerOff = false;
        this.m_CheckPowerOffTime = 0;
        this.m_bCheckIdle = false;
        this.m_CheckIdleTime = 0;
        this.m_bCheckHookOff = false;
        this.m_CheckHookOffTime = 0;
        this.m_DtmfDetectTime = 0;
        this.m_CallDuration = 0;
        this.m_bCheckRingOn = false;
        this.m_CheckRingOnTime = 0;
        this.m_RingOn1 = 0;
        this.m_RingOn2 = 0;
        this.m_RingCnt = 0;
        this.m_RingOffTime = 0;
        this.m_RingDuration = 0;
        this.m_State = 1;
        this.m_bInbound = false;
    }

    public void FskData(byte[] byArray, int n2, int n3) {
        try {
            if (2 != this.m_State && 4 != this.m_State && 5 != this.m_State) {
                return;
            }
            Object object = new byte[n3];
            System.arraycopy(byArray, n2, object, 0, n3);
            if (this.m_FSKCIDDataSize <= 0) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (85 == object[i2]) {
                        ++this.m_iCarry;
                        continue;
                    }
                    if (this.m_iCarry < 8) {
                        this.m_iCarry = 0;
                        this.m_FSKCIDDataSize = 0;
                        for (n2 = 0; n2 < this.m_szFSKCIDData.length; ++n2) {
                            this.m_szFSKCIDData[n2] = 0;
                        }
                        for (n2 = 0; n2 < this.m_FskNum.length; ++n2) {
                            this.m_FskNum[n2] = '\u0000';
                        }
                        continue;
                    }
                    if (object[i2] != -128 && object[i2] != -126 && object[i2] != 4 && object[i2] != 6) {
                        this.m_iCarry = 0;
                        this.m_FSKCIDDataSize = 0;
                        for (n2 = 0; n2 < this.m_szFSKCIDData.length; ++n2) {
                            this.m_szFSKCIDData[n2] = 0;
                        }
                        for (n2 = 0; n2 < this.m_FskNum.length; ++n2) {
                            this.m_FskNum[n2] = '\u0000';
                        }
                        continue;
                    }
                    if (this.m_FSKCIDDataSize + (n3 - i2) >= this.m_szFSKCIDData.length) continue;
                    System.arraycopy(object, i2, this.m_szFSKCIDData, this.m_FSKCIDDataSize, n3 - i2);
                    this.m_FSKCIDDataSize += n3 - i2;
                    break;
                }
            } else if (this.m_FSKCIDDataSize + n3 < this.m_szFSKCIDData.length) {
                System.arraycopy(object, 0, this.m_szFSKCIDData, this.m_FSKCIDDataSize, n3);
                this.m_FSKCIDDataSize += n3;
            } else {
                int n4;
                this.m_iCarry = 0;
                this.m_FSKCIDDataSize = 0;
                for (n4 = 0; n4 < this.m_szFSKCIDData.length; ++n4) {
                    this.m_szFSKCIDData[n4] = 0;
                }
                for (n4 = 0; n4 < this.m_FskNum.length; ++n4) {
                    this.m_FskNum[n4] = '\u0000';
                }
            }
            if (this.m_FSKCIDDataSize > 2 && this.m_szFSKCIDData[1] + 2 <= this.m_FSKCIDDataSize) {
                int n5;
                AD800 aD800 = this;
                n3 = this.m_FSKCIDDataSize;
                byte[] byArray2 = aD800.m_szFSKCIDData;
                AD800 aD8002 = aD800;
                try {
                    object = "";
                    for (n5 = 0; n5 < n3; ++n5) {
                        object = (String)object + String.format("%x,", byArray2[n5]);
                    }
                }
                catch (Exception exception) {}
                if (byArray2[0] == -128 || byArray2[0] == -126 || byArray2[0] == 4 || byArray2[0] == 6 || byArray2[0] == 64) {
                    int n6;
                    int n7 = 0;
                    n5 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    for (n6 = 2; n6 < n3; ++n6) {
                        if (2 == byArray2[n6] && n7 == 0) {
                            n7 = n6;
                        }
                        if (4 == byArray2[n6] && n5 == 0) {
                            n5 = n6;
                        }
                        if (3 != byArray2[n6] || n8 != 0) continue;
                        n8 = n6;
                    }
                    if (n7 != 0) {
                        n9 = n7;
                    } else if (n5 != 0) {
                        n9 = n5;
                    } else if (n8 != 0) {
                        n9 = n8;
                    }
                    n6 = byArray2[n9 + 1];
                    if (4 == byArray2[n9]) {
                        n6 -= 8;
                        n9 += 8;
                    }
                    if (n6 > 0) {
                        if (n6 > 32) {
                            n6 = 32;
                        }
                        for (n3 = 0; n3 < n6; ++n3) {
                            aD8002.m_FskNum[n3] = (char)byArray2[n9 + 2 + n3];
                        }
                        n3 = 0;
                        while (n3 < n6) {
                            int n10 = n3++;
                            aD8002.m_FskNum[n10] = (char)(aD8002.m_FskNum[n10] & 0x7F);
                        }
                        String string = "";
                        for (int i3 = 0; i3 < n6; ++i3) {
                            string = string + String.format("%c", Character.valueOf(aD8002.m_FskNum[i3]));
                        }
                        aD8002.CallerId = string;
                        aD8002.parent.notifyObservers(new LineMessage(aD8002.m_Channel, 4, 4));
                    }
                }
                this.m_iCarry = 0;
                this.m_FSKCIDDataSize = 0;
                for (int i4 = 0; i4 < this.m_szFSKCIDData.length; ++i4) {
                    this.m_szFSKCIDData[i4] = 0;
                }
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("Fsk: Exception:" + exception.getLocalizedMessage());
            return;
        }
    }

    private void AnalyseFSKCID(byte[] byArray, int n2) {
        int n3;
        int n4;
        try {
            String string = "";
            for (n4 = 0; n4 < n2; ++n4) {
                string = string + String.format("%x,", byArray[n4]);
            }
        }
        catch (Exception exception) {}
        if (byArray[0] != -128 && byArray[0] != -126 && byArray[0] != 4 && byArray[0] != 6 && byArray[0] != 64) {
            return;
        }
        int n5 = 0;
        n4 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 2; n3 < n2; ++n3) {
            if (2 == byArray[n3] && n5 == 0) {
                n5 = n3;
            }
            if (4 == byArray[n3] && n4 == 0) {
                n4 = n3;
            }
            if (3 != byArray[n3] || n6 != 0) continue;
            n6 = n3;
        }
        if (n5 != 0) {
            n7 = n5;
        } else if (n4 != 0) {
            n7 = n4;
        } else if (n6 != 0) {
            n7 = n6;
        }
        n3 = byArray[n7 + 1];
        if (4 == byArray[n7]) {
            n3 -= 8;
            n7 += 8;
        }
        if (n3 > 0) {
            if (n3 > 32) {
                n3 = 32;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.m_FskNum[n2] = (char)byArray[n7 + 2 + n2];
            }
            n2 = 0;
            while (n2 < n3) {
                int n8 = n2++;
                this.m_FskNum[n8] = (char)(this.m_FskNum[n8] & 0x7F);
            }
            String string = "";
            for (int i2 = 0; i2 < n3; ++i2) {
                string = string + String.format("%c", Character.valueOf(this.m_FskNum[i2]));
            }
            this.CallerId = string;
            this.parent.notifyObservers(new LineMessage(this.m_Channel, 4, 4));
        }
    }

    public void DTMFData(byte[] byArray, int n2, int n3) {
        try {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = byArray[i2 + n2];
                int n5 = 0;
                switch (n4) {
                    case 10: {
                        n5 = 48;
                        break;
                    }
                    case 11: {
                        n5 = 42;
                        break;
                    }
                    case 12: {
                        n5 = 35;
                        break;
                    }
                    case 13: {
                        n5 = 65;
                        break;
                    }
                    case 14: {
                        n5 = 66;
                        break;
                    }
                    case 15: {
                        n5 = 67;
                        break;
                    }
                    case 0: {
                        n5 = 68;
                        break;
                    }
                    default: {
                        if (n4 < 0 || n4 > 9) break;
                        n5 = (char)(n4 + 48);
                    }
                }
                this.m_DtmfNum[this.m_DtmfSize] = n5;
                ++this.m_DtmfSize;
                if (this.m_DtmfSize >= 32) {
                    this.m_DtmfSize = 0;
                    for (n4 = 0; n4 < this.m_DtmfNum.length; ++n4) {
                        this.m_DtmfNum[n4] = '\u0000';
                    }
                }
                this.Dtmf = "";
                for (n4 = 0; n4 < this.m_DtmfSize; ++n4) {
                    this.Dtmf = this.Dtmf + this.m_DtmfNum[n4];
                }
                if ("".equals(this.Dtmf) || this.m_State != 3) continue;
                this.m_DtmfDetectTime = 0;
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("Dtmf: Exception:" + exception.getLocalizedMessage());
            return;
        }
    }

    private static char DTMFToChar(byte by) {
        char c2 = '\u0000';
        switch (by) {
            case 10: {
                c2 = '0';
                break;
            }
            case 11: {
                c2 = '*';
                break;
            }
            case 12: {
                c2 = '#';
                break;
            }
            case 13: {
                c2 = 'A';
                break;
            }
            case 14: {
                c2 = 'B';
                break;
            }
            case 15: {
                c2 = 'C';
                break;
            }
            case 0: {
                c2 = 'D';
                break;
            }
            default: {
                if (by < 0 || by > 9) break;
                c2 = (char)(by + 48);
            }
        }
        return c2;
    }

    public void GetVoltage(int n2) {
        if (this.m_VoltageIndex < 256) {
            this.m_VoltageArray[this.m_VoltageIndex] = (int)(((double)n2 * 5.035477225909819E-5 - 1.65) * 60.0);
        }
        this.m_VoltageValue = (int)((double)this.m_VoltageValue + Math.abs(((double)n2 * 5.035477225909819E-5 - 1.65) * 60.0));
        ++this.m_VoltageIndex;
    }
}

