/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class ClassPathLibraryLoader {
    public static OSType getOSType() {
        String string = System.getProperty("os.name", "generic").toLowerCase();
        if (string.contains("mac") || string.contains("darwin")) {
            return OSType.MacOS;
        }
        if (string.contains("win")) {
            return OSType.Windows;
        }
        if (string.contains("nux")) {
            return OSType.Linux;
        }
        return OSType.Other;
    }

    public static String getLibExtensionForOS(OSType oSType) {
        switch (oSType) {
            case Windows: {
                return "dll";
            }
            case MacOS: {
                return "jnilib";
            }
            case Linux: {
                return "so";
            }
        }
        return "unknown";
    }

    public static String getWindowsCPUType() {
        String string = System.getenv("PROCESSOR_ARCHITEW6432");
        if (string != null && !string.isEmpty()) {
            return string;
        }
        return System.getenv("PROCESSOR_ARCHITECTURE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLinuxCPUType() {
        try {
            Object object = Runtime.getRuntime().exec("uname -p");
            ((Process)object).waitFor();
            object = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            try {
                String string = ((BufferedReader)object).readLine();
                if (string == null) return "";
                return string;
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return "";
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLinuxCPUType2() {
        try {
            Object object = Runtime.getRuntime().exec("uname -m");
            ((Process)object).waitFor();
            object = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            try {
                String string = ((BufferedReader)object).readLine();
                if (string == null) return "";
                return string;
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return "";
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        return "";
    }

    public static String getCPUBitArch() {
        OSType oSType = ClassPathLibraryLoader.getOSType();
        String string = "32";
        String string2 = "";
        if (oSType == OSType.Windows) {
            string2 = ClassPathLibraryLoader.getWindowsCPUType();
        } else if (oSType == OSType.Linux || oSType == OSType.MacOS) {
            string2 = ClassPathLibraryLoader.getLinuxCPUType();
        }
        if ((string2 == null || string2.equals("unknown")) && (string2 = ClassPathLibraryLoader.getLinuxCPUType2()) == null) {
            return string;
        }
        if (string2.contains("64")) {
            string = "64";
        } else if (string2.contains("arm")) {
            string = "arm";
        }
        System.out.println(oSType.name() + "-" + string2);
        return string;
    }

    public static boolean loadNativeHIDLibrary() {
        boolean bl2;
        block8: {
            bl2 = false;
            Object object = ClassPathLibraryLoader.getOSType();
            Object object2 = ClassPathLibraryLoader.getCPUBitArch();
            object = "/native/" + ((Enum)object).toString().toLowerCase() + "/libhidapi-jni-" + (String)object2 + "." + ClassPathLibraryLoader.getLibExtensionForOS((OSType)((Object)object));
            System.out.println("Trying to load: " + (String)object);
            try {
                object2 = ClassPathLibraryLoader.class.getResourceAsStream((String)object);
                if (object2 == null) break block8;
                try {
                    int n2;
                    Object object3 = object;
                    Object object4 = object = ((String)object3).substring(((String)object3).lastIndexOf(47) + 1);
                    object = File.createTempFile(((String)object).substring(0, ((String)object).lastIndexOf(46)), ((String)object4).substring(((String)object4).lastIndexOf(46), ((String)object).length()));
                    ((File)object).deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                    byte[] byArray = new byte[1024];
                    while ((n2 = ((InputStream)object2).read(byArray)) > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    }
                    ((OutputStream)fileOutputStream).close();
                    Runtime.getRuntime().load(((File)object).toString());
                    bl2 = true;
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
                finally {
                    ((InputStream)object2).close();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        return bl2;
    }

    public static boolean loadNativeACLASLibrary() {
        boolean bl2;
        block8: {
            bl2 = false;
            Object object = ClassPathLibraryLoader.getOSType();
            Object object2 = ClassPathLibraryLoader.getCPUBitArch();
            object = "/" + ((Enum)object).toString().toLowerCase() + "/aclassdk-" + (String)object2 + "." + ClassPathLibraryLoader.getLibExtensionForOS((OSType)((Object)object));
            System.out.println("Trying to load: " + (String)object);
            try {
                object2 = ClassPathLibraryLoader.class.getResourceAsStream((String)object);
                if (object2 == null) break block8;
                try {
                    int n2;
                    Object object3 = object;
                    Object object4 = object = ((String)object3).substring(((String)object3).lastIndexOf(47) + 1);
                    object = File.createTempFile(((String)object).substring(0, ((String)object).lastIndexOf(46)), ((String)object4).substring(((String)object4).lastIndexOf(46), ((String)object).length()));
                    ((File)object).deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                    byte[] byArray = new byte[1024];
                    while ((n2 = ((InputStream)object2).read(byArray)) > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    }
                    ((OutputStream)fileOutputStream).close();
                    Runtime.getRuntime().load(((File)object).toString());
                    bl2 = true;
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
                finally {
                    ((InputStream)object2).close();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        return bl2;
    }

    public static String getACLASLibraryPath() {
        try {
            Object object = ClassPathLibraryLoader.getOSType();
            String string = ClassPathLibraryLoader.getCPUBitArch();
            object = "/" + object.toString().toLowerCase() + "/aclassdk-" + string + "." + ClassPathLibraryLoader.getLibExtensionForOS(object);
            System.out.println("Trying to load: " + (String)object);
            return object;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Other;

    }
}

