/*
 * Decompiled with CFR 0.152.
 */
package com.posics.beans;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class RoundedBorder
extends AbstractBorder {
    private static Border a;
    private static Border b;
    private static Border c;
    protected Color colorBorder;
    protected Color colorgradient;
    protected int roundedRadius;
    protected float thickness;
    protected boolean filled;
    private float ftop;
    private float fbottom;
    private float ftopinset;
    private float fbottominset;

    public static Border createBlackLineBorder() {
        if (a == null) {
            a = new RoundedBorder(Color.BLACK);
        }
        return a;
    }

    public static Border createGrayLineBorder() {
        if (b == null) {
            b = new RoundedBorder(Color.GRAY);
        }
        return b;
    }

    public static Border createGradientBorder() {
        if (c == null) {
            c = new RoundedBorder(Color.GRAY, 0.0f, 8, false, false);
        }
        return c;
    }

    public RoundedBorder(Color color) {
        this(color, Color.WHITE, 1.0f, 0, true, true);
    }

    public RoundedBorder(Color color, float f2) {
        this(color, Color.WHITE, f2, 0, true, true);
    }

    public RoundedBorder(Color color, float f2, int n2) {
        this(color, Color.WHITE, f2, n2, true, true);
    }

    public RoundedBorder(Color color, float f2, int n2, boolean bl2, boolean bl3) {
        this(color, Color.WHITE, f2, n2, bl2, bl3);
    }

    public RoundedBorder(Color color, Color color2, float f2, int n2, boolean bl2, boolean bl3) {
        this.colorBorder = color;
        this.colorgradient = color2;
        this.thickness = f2;
        this.roundedRadius = n2;
        this.filled = true;
        this.ftop = bl2 ? 0.0f : f2 + (float)n2;
        this.fbottom = bl3 ? 0.0f : f2 + (float)n2;
        this.ftopinset = bl2 ? 0.0f : f2;
        this.fbottominset = bl3 ? 0.0f : f2;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics = (Graphics2D)graphics;
        Object object = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = ((Graphics2D)graphics).getStroke();
        Paint paint = ((Graphics2D)graphics).getPaint();
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f2 = this.thickness;
        if (this.filled) {
            if (component.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, component.getBackground(), n4, 0.0f, this.colorgradient));
            } else {
                ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, this.colorgradient, n4, 0.0f, component.getBackground()));
            }
            graphics.fillRoundRect((int)((float)n2 + this.thickness), (int)((float)n3 + this.thickness - this.ftop), (int)((float)n4 - this.thickness - this.thickness), (int)((float)n5 - this.thickness - this.thickness + this.ftop + this.fbottom), (int)((float)(this.roundedRadius << 1) - f2), (int)((float)(this.roundedRadius << 1) - f2));
        }
        if (this.thickness > 0.0f) {
            ((Graphics2D)graphics).setStroke(new BasicStroke(this.thickness));
            ((Graphics2D)graphics).setPaint(this.colorBorder);
            graphics.drawRoundRect(n2, (int)((float)n3 - this.ftop), (int)((float)n4 - this.thickness), (int)((float)n5 - this.thickness + this.ftop + this.fbottom), this.roundedRadius << 1, this.roundedRadius << 1);
        }
        ((Graphics2D)graphics).setPaint(paint);
        ((Graphics2D)graphics).setStroke(stroke);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets((int)(0.5 + (double)this.thickness - (double)this.ftopinset), (int)(0.5 + (double)this.thickness + (double)this.roundedRadius), (int)(0.5 + (double)this.thickness - (double)this.fbottominset), (int)(0.5 + (double)this.thickness + (double)this.roundedRadius));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = (int)(0.5 + (double)this.thickness - (double)this.ftopinset);
        insets.left = (int)(0.5 + (double)this.thickness + (double)this.roundedRadius);
        insets.bottom = (int)(0.5 + (double)this.thickness - (double)this.fbottominset);
        insets.right = (int)(0.5 + (double)this.thickness + (double)this.roundedRadius);
        return insets;
    }

    public Color getLineColor() {
        return this.colorBorder;
    }

    public float getThickness() {
        return this.thickness;
    }

    public boolean isFilled() {
        return this.filled;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

