/*
 * Decompiled with CFR 0.152.
 */
package com.posics.data.gui;

import com.posics.data.loader.IKeyGetter;
import com.posics.data.loader.KeyGetterBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class ComboBoxValModel
extends AbstractListModel
implements ComboBoxModel {
    private List m_aData;
    private IKeyGetter m_keygetter;
    private Object m_selected;

    public ComboBoxValModel(List list, IKeyGetter iKeyGetter) {
        this.m_aData = list;
        this.m_keygetter = iKeyGetter;
        this.m_selected = null;
    }

    public ComboBoxValModel(List list) {
        this(list, KeyGetterBuilder.INSTANCE);
    }

    public ComboBoxValModel(IKeyGetter iKeyGetter) {
        this(new ArrayList(), iKeyGetter);
    }

    public ComboBoxValModel() {
        this(new ArrayList(), KeyGetterBuilder.INSTANCE);
    }

    public void add(Object object) {
        this.m_aData.add(object);
    }

    public void add(int n2, Object object) {
        this.m_aData.add(n2, object);
    }

    public void del(Object object) {
        this.m_aData.remove(object);
    }

    public void refresh(List list) {
        this.m_aData = list;
        this.m_selected = null;
    }

    public Object getSelectedKey() {
        if (this.m_selected == null) {
            return null;
        }
        return this.m_keygetter.getKey(this.m_selected);
    }

    public String getSelectedText() {
        if (this.m_selected == null) {
            return null;
        }
        return this.m_selected.toString();
    }

    public void setSelectedKey(Object object) {
        ComboBoxValModel comboBoxValModel = this;
        comboBoxValModel.setSelectedItem(comboBoxValModel.getElementByKey(object));
    }

    public void setSelectedFirst() {
        this.m_selected = this.m_aData.size() == 0 ? null : this.m_aData.get(0);
    }

    public Object getElementByKey(Object object) {
        if (object != null) {
            for (Object e2 : this.m_aData) {
                if (!object.equals(this.m_keygetter.getKey(e2))) continue;
                return e2;
            }
        }
        return null;
    }

    @Override
    public Object getElementAt(int n2) {
        return this.m_aData.get(n2);
    }

    @Override
    public Object getSelectedItem() {
        return this.m_selected;
    }

    @Override
    public int getSize() {
        return this.m_aData.size();
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.m_selected != null && !this.m_selected.equals(object) || this.m_selected == null && object != null) {
            this.m_selected = object;
            ComboBoxValModel comboBoxValModel = this;
            comboBoxValModel.fireContentsChanged(comboBoxValModel, -1, -1);
        }
    }
}

