/*
 * Decompiled with CFR 0.152.
 */
package com.posics.data.loader;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DataWriteUtils {
    private static DateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public static String getSQLValue(Object object) {
        if (object == null) {
            return "NULL";
        }
        if (object instanceof Double) {
            return DataWriteUtils.getSQLValue((Double)object);
        }
        if (object instanceof Integer) {
            return DataWriteUtils.getSQLValue((Integer)object);
        }
        if (object instanceof Boolean) {
            return DataWriteUtils.getSQLValue((Boolean)object);
        }
        if (object instanceof String) {
            return DataWriteUtils.getSQLValue((String)object);
        }
        if (object instanceof Date) {
            return DataWriteUtils.getSQLValue((Date)object);
        }
        return DataWriteUtils.getSQLValue(object.toString());
    }

    public static String getSQLValue(Integer n2) {
        if (n2 == null) {
            return "NULL";
        }
        return n2.toString();
    }

    public static String getSQLValue(Double d2) {
        if (d2 == null) {
            return "NULL";
        }
        return d2.toString();
    }

    public static String getSQLValue(Boolean bl2) {
        if (bl2 == null) {
            return "NULL";
        }
        if (bl2.booleanValue()) {
            return "TRUE";
        }
        return "FALSE";
    }

    public static String getSQLValue(String string) {
        if (string == null) {
            return "NULL";
        }
        return "'" + DataWriteUtils.getEscaped(string) + '\'';
    }

    public static String getSQLValue(Date date) {
        if (date == null) {
            return "NULL";
        }
        return "{ts '" + a.format(date) + "'}";
    }

    public static String getEscaped(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i2 = 0; i2 < string.length(); ++i2) {
            switch (string.charAt(i2)) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block6;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block6;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block6;
                }
                default: {
                    stringBuffer.append(string.charAt(i2));
                }
            }
        }
        return stringBuffer.toString();
    }
}

