/*
 * Decompiled with CFR 0.152.
 */
package com.posics.data.loader;

import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.DataWriteUtils;
import com.posics.data.loader.ImageUtils;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class Datas {
    public static final Datas INT = new e(0);
    public static final Datas STRING = new i(0);
    public static final Datas DOUBLE = new c(0);
    public static final Datas BOOLEAN = new a(0);
    public static final Datas TIMESTAMP = new j(0);
    public static final Datas BYTES = new b(0);
    public static final Datas IMAGE = new d(0);
    public static final Datas OBJECT = new g(0);
    public static final Datas SERIALIZABLE = new h(0);
    public static final Datas NULL = new f(0);
    private static DateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private Datas() {
    }

    public abstract Object getValue(DataRead var1, int var2);

    public abstract void setValue(DataWrite var1, int var2, Object var3);

    public abstract Class getClassValue();

    protected abstract String toStringAbstract(Object var1);

    protected abstract int compareAbstract(Object var1, Object var2);

    public String toString(Object object) {
        if (object == null) {
            return "null";
        }
        return this.toStringAbstract(object);
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return this.compareAbstract(object, object2);
    }

    /* synthetic */ Datas(byte by) {
        this();
    }

    static final class f
    extends Datas {
        private f() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return null;
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
        }

        @Override
        public final Class getClassValue() {
            return Object.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return "null";
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ f(byte by) {
            this();
        }
    }

    static final class h
    extends Datas {
        private h() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return ImageUtils.readSerializable(dataRead.getBytes(n2));
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setBytes(n2, ImageUtils.writeSerializable(object));
        }

        @Override
        public final Class getClassValue() {
            return Object.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return "0x" + ImageUtils.bytes2hex(ImageUtils.writeSerializable(object));
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ h(byte by) {
            this();
        }
    }

    static final class g
    extends Datas {
        private g() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return dataRead.getObject(n2);
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setObject(n2, object);
        }

        @Override
        public final Class getClassValue() {
            return Object.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return "0x" + ImageUtils.bytes2hex(ImageUtils.writeSerializable(object));
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ g(byte by) {
            this();
        }
    }

    static final class d
    extends Datas {
        private d() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return ImageUtils.readImage(dataRead.getBytes(n2));
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setBytes(n2, ImageUtils.writeImage((BufferedImage)object));
        }

        @Override
        public final Class getClassValue() {
            return BufferedImage.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return "0x" + ImageUtils.bytes2hex(ImageUtils.writeImage((BufferedImage)object));
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ d(byte by) {
            this();
        }
    }

    static final class b
    extends Datas {
        private b() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return dataRead.getBytes(n2);
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setBytes(n2, (byte[])object);
        }

        @Override
        public final Class getClassValue() {
            return byte[].class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return "0x" + ImageUtils.bytes2hex((byte[])object);
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    static final class j
    extends Datas {
        private j() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return dataRead.getTimestamp(n2);
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setTimestamp(n2, (Date)object);
        }

        @Override
        public final Class getClassValue() {
            return Date.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return a.format(object);
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            return ((Date)object).compareTo((Date)object2);
        }

        /* synthetic */ j(byte by) {
            this();
        }
    }

    static final class a
    extends Datas {
        private a() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return dataRead.getBoolean(n2);
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setBoolean(n2, (Boolean)object);
        }

        @Override
        public final Class getClassValue() {
            return Boolean.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return ((Boolean)object).toString();
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            return ((Boolean)object).compareTo((Boolean)object2);
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    static final class c
    extends Datas {
        private c() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return dataRead.getDouble(n2);
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setDouble(n2, (Double)object);
        }

        @Override
        public final Class getClassValue() {
            return Double.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return ((Double)object).toString();
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            return ((Double)object).compareTo((Double)object2);
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    static final class i
    extends Datas {
        private i() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return dataRead.getString(n2);
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setString(n2, (String)object);
        }

        @Override
        public final Class getClassValue() {
            return String.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return "'" + DataWriteUtils.getEscaped((String)object) + "'";
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            return ((String)object).compareTo((String)object2);
        }

        /* synthetic */ i(byte by) {
            this();
        }
    }

    static final class e
    extends Datas {
        private e() {
            super((byte)0);
        }

        @Override
        public final Object getValue(DataRead dataRead, int n2) {
            return dataRead.getInt(n2);
        }

        @Override
        public final void setValue(DataWrite dataWrite, int n2, Object object) {
            dataWrite.setInt(n2, (Integer)object);
        }

        @Override
        public final Class getClassValue() {
            return Integer.class;
        }

        @Override
        protected final String toStringAbstract(Object object) {
            return ((Integer)object).toString();
        }

        @Override
        protected final int compareAbstract(Object object, Object object2) {
            return ((Integer)object).compareTo((Integer)object2);
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }
}

