/*
 * Decompiled with CFR 0.152.
 */
package com.posics.data.loader;

import com.posics.basic.BasicException;
import com.posics.data.loader.BaseSentence;
import com.posics.data.loader.DataField;
import com.posics.data.loader.DataResultSet;
import com.posics.data.loader.SerializerRead;
import com.posics.data.loader.Session;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public abstract class JDBCSentence
extends BaseSentence {
    protected Session m_s;

    public JDBCSentence(Session session) {
        this.m_s = session;
    }

    protected static final class JDBCDataResultSet
    implements DataResultSet {
        private ResultSet a;
        private SerializerRead b;

        public JDBCDataResultSet(ResultSet resultSet, SerializerRead serializerRead) {
            this.a = resultSet;
            this.b = serializerRead;
        }

        @Override
        public final Integer getInt(int n2) {
            try {
                n2 = this.a.getInt(n2);
                if (this.a.wasNull()) {
                    return null;
                }
                return n2;
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final String getString(int n2) {
            try {
                return this.a.getString(n2);
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final Double getDouble(int n2) {
            try {
                double d2 = this.a.getDouble(n2);
                if (this.a.wasNull()) {
                    return null;
                }
                return d2;
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final Boolean getBoolean(int n2) {
            try {
                n2 = this.a.getBoolean(n2) ? 1 : 0;
                if (this.a.wasNull()) {
                    return null;
                }
                return n2 != 0;
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final Date getTimestamp(int n2) {
            try {
                Timestamp timestamp = this.a.getTimestamp(n2);
                if (timestamp == null) {
                    return null;
                }
                return new Date(timestamp.getTime());
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final byte[] getBytes(int n2) {
            try {
                return this.a.getBytes(n2);
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final Object getObject(int n2) {
            try {
                return this.a.getObject(n2);
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final DataField[] getDataField() {
            try {
                ResultSetMetaData resultSetMetaData = this.a.getMetaData();
                DataField[] dataFieldArray = new DataField[resultSetMetaData.getColumnCount()];
                for (int i2 = 0; i2 < dataFieldArray.length; ++i2) {
                    dataFieldArray[i2] = new DataField();
                    dataFieldArray[i2].Name = resultSetMetaData.getColumnName(i2 + 1);
                    dataFieldArray[i2].Size = resultSetMetaData.getColumnDisplaySize(i2 + 1);
                    dataFieldArray[i2].Type = resultSetMetaData.getColumnType(i2 + 1);
                }
                return dataFieldArray;
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final Object getCurrent() {
            return this.b.readValues(this);
        }

        @Override
        public final boolean next() {
            try {
                return this.a.next();
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final void close() {
            try {
                this.a.close();
                return;
            }
            catch (SQLException sQLException) {
                throw new BasicException(sQLException);
            }
        }

        @Override
        public final int updateCount() {
            return -1;
        }
    }
}

