/*
 * Decompiled with CFR 0.152.
 */
package com.posics.editor;

import com.posics.basic.BasicException;
import com.posics.editor.EditorComponent;
import com.posics.editor.EditorKeys;
import com.posics.editor.a;
import com.posics.pos.config.LAFColors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public abstract class JEditorAbstract
extends JPanel
implements EditorComponent {
    private EditorKeys editorkeys;
    private boolean m_bActive;
    private final Border m_borderactive = new CompoundBorder(new LineBorder(UIManager.getDefaults().getColor("TextField.selectionBackground")), new EmptyBorder(new Insets(1, 4, 1, 4)));
    private final Border m_borderinactive = new CompoundBorder(new LineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), new EmptyBorder(new Insets(1, 4, 1, 4)));
    private JLabel m_jMode;
    private JButton m_jText;
    private JPanel panBackground;

    public JEditorAbstract() {
        JEditorAbstract jEditorAbstract = this;
        this.panBackground = new JPanel();
        jEditorAbstract.m_jText = new JButton();
        jEditorAbstract.m_jMode = new JLabel();
        jEditorAbstract.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        jEditorAbstract.setLayout(new BorderLayout());
        jEditorAbstract.panBackground.setBackground(UIManager.getDefaults().getColor("TextField.background"));
        jEditorAbstract.panBackground.setLayout(new BorderLayout());
        jEditorAbstract.m_jText.setBackground(UIManager.getDefaults().getColor("TextField.background"));
        jEditorAbstract.m_jText.setContentAreaFilled(false);
        jEditorAbstract.m_jText.setFocusPainted(false);
        jEditorAbstract.m_jText.setFocusable(false);
        jEditorAbstract.m_jText.setMinimumSize(new Dimension(100, 25));
        jEditorAbstract.m_jText.setPreferredSize(new Dimension(100, 25));
        jEditorAbstract.m_jText.setRequestFocusEnabled(false);
        jEditorAbstract.m_jText.setVerticalAlignment(1);
        jEditorAbstract.m_jText.addActionListener(new a(jEditorAbstract));
        jEditorAbstract.panBackground.add((Component)jEditorAbstract.m_jText, "Center");
        JEditorAbstract jEditorAbstract2 = jEditorAbstract;
        jEditorAbstract2.add((Component)jEditorAbstract2.panBackground, "Center");
        jEditorAbstract.m_jMode.setFont(new Font("Dialog", 0, 9));
        jEditorAbstract.m_jMode.setForeground(LAFColors.COLOR_LABEL);
        jEditorAbstract.m_jMode.setHorizontalAlignment(2);
        jEditorAbstract.m_jMode.setVerticalAlignment(1);
        jEditorAbstract.m_jMode.setPreferredSize(new Dimension(32, 0));
        JEditorAbstract jEditorAbstract3 = jEditorAbstract;
        jEditorAbstract3.add((Component)jEditorAbstract3.m_jMode, "After");
        this.editorkeys = null;
        this.m_bActive = false;
        this.m_jText.setBorder(this.m_borderinactive);
        this.m_jText.setName("EditorAbstract");
    }

    protected abstract int getMode();

    protected abstract int getAlignment();

    protected abstract String getEditMode();

    protected abstract String getTextEdit();

    protected abstract String getTextFormat();

    protected abstract void typeCharInternal(char var1);

    protected abstract void transCharInternal(char var1);

    @Override
    public void typeChar(char c2) {
        this.typeCharInternal(c2);
        this.reprintText();
        this.firePropertyChange("Edition", null, null);
    }

    @Override
    public void transChar(char c2) {
        this.transCharInternal(c2);
        this.reprintText();
        this.firePropertyChange("Edition", null, null);
    }

    @Override
    public void addEditorKeys(EditorKeys editorKeys) {
        this.editorkeys = editorKeys;
    }

    @Override
    public void deactivate() {
        this.a(false);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void activate() {
        if (this.isEnabled()) {
            JEditorAbstract jEditorAbstract = this;
            this.editorkeys.setActive(jEditorAbstract, jEditorAbstract.getMode());
            this.a(true);
        }
    }

    private void a(boolean bl2) {
        this.m_bActive = bl2;
        this.m_jText.setBorder(this.m_bActive ? this.m_borderactive : this.m_borderinactive);
        this.reprintText();
    }

    protected void reprintText() {
        this.m_jText.setHorizontalAlignment(this.getAlignment());
        if (this.m_bActive) {
            this.m_jMode.setText(this.getEditMode());
            this.m_jText.setText(this.getTextEdit());
            this.m_jText.setForeground(UIManager.getDefaults().getColor("Label.foreground"));
            return;
        }
        this.m_jMode.setText(null);
        try {
            this.m_jText.setText(this.getTextFormat());
            this.m_jText.setForeground(UIManager.getDefaults().getColor("Label.foreground"));
            return;
        }
        catch (BasicException basicException) {
            this.m_jText.setText(this.getTextEdit());
            this.m_jText.setForeground(Color.RED);
            return;
        }
    }

    @Override
    public void setEnabled(boolean bl2) {
        if (this.editorkeys != null) {
            this.editorkeys.setInactive(this);
        }
        this.panBackground.setBackground(bl2 ? UIManager.getDefaults().getColor("TextField.background") : UIManager.getDefaults().getColor("TextField.disabledBackground"));
        super.setEnabled(bl2);
    }

    static /* synthetic */ void access$000(JEditorAbstract jEditorAbstract, ActionEvent actionEvent) {
        jEditorAbstract.activate();
    }
}

