/*
 * Decompiled with CFR 0.152.
 */
package com.posics.editor;

import com.posics.basic.BasicException;
import com.posics.editor.JEditorAbstract;
import com.posics.format.DoubleUtils;
import com.posics.format.Formats;
import java.awt.Toolkit;

public abstract class JEditorNumber
extends JEditorAbstract {
    private int m_iNumberStatus;
    private String m_sNumber;
    private boolean m_bNegative;
    private Formats m_fmt = this.getFormat();

    public JEditorNumber() {
        this.reset();
    }

    protected abstract Formats getFormat();

    public void reset() {
        String string = this.getText();
        this.m_sNumber = "";
        this.m_bNegative = false;
        this.m_iNumberStatus = 0;
        this.reprintText();
        this.firePropertyChange("Text", string, this.getText());
    }

    public void setDoubleValue(Double d2) {
        String string = this.getText();
        if (d2 == null) {
            this.m_sNumber = "";
            this.m_bNegative = false;
            this.m_iNumberStatus = 0;
        } else if (d2 >= 0.0) {
            this.m_sNumber = JEditorNumber.a(d2);
            this.m_bNegative = false;
            this.m_iNumberStatus = 0;
        } else {
            this.m_sNumber = JEditorNumber.a(-d2.doubleValue());
            this.m_bNegative = true;
            this.m_iNumberStatus = 0;
        }
        this.reprintText();
        this.firePropertyChange("Text", string, this.getText());
    }

    public Double getDoubleValue() {
        String string = this.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void setValueInteger(int n2) {
        String string = this.getText();
        if (n2 >= 0) {
            this.m_sNumber = Integer.toString(n2);
            this.m_bNegative = false;
            this.m_iNumberStatus = 0;
        } else {
            this.m_sNumber = Integer.toString(-n2);
            this.m_bNegative = true;
            this.m_iNumberStatus = 0;
        }
        this.reprintText();
        this.firePropertyChange("Text", string, this.getText());
    }

    public int getValueInteger() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new BasicException(numberFormatException);
        }
    }

    private static String a(Double object) {
        if (((String)(object = Double.toString(DoubleUtils.fixDecimals((Number)object)))).endsWith(".0")) {
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        return object;
    }

    @Override
    protected String getEditMode() {
        return "-1.23";
    }

    public String getText() {
        return (this.m_bNegative ? "-" : "") + this.m_sNumber;
    }

    @Override
    protected int getAlignment() {
        return 4;
    }

    @Override
    protected String getTextEdit() {
        return this.getText();
    }

    @Override
    protected String getTextFormat() {
        return this.m_fmt.formatValue(this.getDoubleValue());
    }

    @Override
    protected void typeCharInternal(char c2) {
        this.transChar(c2);
    }

    @Override
    protected void transCharInternal(char c2) {
        String string = this.getText();
        if (c2 == '\u007f') {
            this.reset();
        } else if (c2 == '-') {
            this.m_bNegative = !this.m_bNegative;
        } else if (c2 == '0' && this.m_iNumberStatus == 0) {
            this.m_sNumber = "0";
        } else if ((c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '6' || c2 == '7' || c2 == '8' || c2 == '9') && this.m_iNumberStatus == 0) {
            this.m_iNumberStatus = 1;
            this.m_sNumber = Character.toString(c2);
        } else if (c2 == '.' && this.m_iNumberStatus == 0) {
            this.m_iNumberStatus = 2;
            this.m_sNumber = "0.";
        } else if ((c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '6' || c2 == '7' || c2 == '8' || c2 == '9') && this.m_iNumberStatus == 1) {
            this.m_sNumber = this.m_sNumber + c2;
        } else if (c2 == '.' && this.m_iNumberStatus == 1) {
            this.m_iNumberStatus = 2;
            this.m_sNumber = this.m_sNumber + '.';
        } else if ((c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '6' || c2 == '7' || c2 == '8' || c2 == '9') && this.m_iNumberStatus == 2) {
            this.m_sNumber = this.m_sNumber + c2;
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        this.firePropertyChange("Text", string, this.getText());
    }
}

