/*
 * Decompiled with CFR 0.152.
 */
package com.posics.format;

import com.posics.basic.BasicException;
import com.posics.format.DoubleUtils;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class Formats {
    public static final Formats NULL = new g(0);
    public static final Formats INT = new f(0);
    public static final Formats STRING = new i(0);
    public static final Formats DOUBLE = new e(0);
    public static final Formats CURRENCY = new c(0);
    public static final Formats PERCENT = new h(0);
    public static final Formats BOOLEAN = new a(0);
    public static final Formats TIMESTAMP = new k(0);
    public static final Formats DATE = new d(0);
    public static final Formats TIME = new j(0);
    public static final Formats BYTEA = new b(0);
    private static NumberFormat a = NumberFormat.getIntegerInstance();
    private static NumberFormat b = NumberFormat.getNumberInstance();
    private static NumberFormat c = NumberFormat.getCurrencyInstance();
    private static NumberFormat d = new DecimalFormat("#,##0.##%");
    private static DateFormat e = DateFormat.getDateInstance();
    private static DateFormat f = DateFormat.getTimeInstance();
    private static DateFormat g = DateFormat.getDateTimeInstance();

    protected Formats() {
    }

    public static int getCurrencyDecimals() {
        return c.getMaximumFractionDigits();
    }

    public String formatValue(Object object) {
        if (object == null) {
            return "";
        }
        return this.formatValueInt(object);
    }

    public Object parseValue(String string, Object object) {
        if (string == null || "".equals(string)) {
            return object;
        }
        try {
            return this.parseValueInt(string);
        }
        catch (ParseException parseException) {
            throw new BasicException(parseException.getMessage(), parseException);
        }
    }

    public Object parseValue(String string) {
        return this.parseValue(string, null);
    }

    public static void setIntegerPattern(String string) {
        if (string == null || string.equals("")) {
            a = NumberFormat.getIntegerInstance();
            return;
        }
        a = new DecimalFormat(string);
    }

    public static void setDoublePattern(String string) {
        if (string == null || string.equals("")) {
            b = NumberFormat.getNumberInstance();
            return;
        }
        b = new DecimalFormat(string);
    }

    public static void setCurrencyPattern(String string) {
        if (string == null || string.equals("")) {
            c = NumberFormat.getCurrencyInstance();
            return;
        }
        c = new DecimalFormat(string);
    }

    public static void setPercentPattern(String string) {
        if (string == null || string.equals("")) {
            d = new DecimalFormat("#,##0.##%");
            return;
        }
        d = new DecimalFormat(string);
    }

    public static void setDatePattern(String string) {
        try {
            if (string != null && !string.equals("")) {
                e = new SimpleDateFormat(string);
                return;
            }
            e = DateFormat.getDateInstance();
        }
        catch (Exception exception) {
            e = DateFormat.getDateInstance();
        }
    }

    public static void setTimePattern(String string) {
        try {
            if (string != null && !string.equals("")) {
                f = new SimpleDateFormat(string);
                return;
            }
            f = DateFormat.getTimeInstance();
        }
        catch (Exception exception) {
            f = DateFormat.getTimeInstance();
        }
    }

    public static void setDateTimePattern(String string) {
        try {
            if (string != null && !string.equals("")) {
                g = new SimpleDateFormat(string);
                return;
            }
            g = DateFormat.getDateTimeInstance();
        }
        catch (Exception exception) {
            g = DateFormat.getDateTimeInstance();
        }
    }

    protected abstract String formatValueInt(Object var1);

    protected abstract Object parseValueInt(String var1);

    public abstract int getAlignment();

    static final class b
    extends Formats {
        private b() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            try {
                return new String((byte[])object, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "";
            }
        }

        @Override
        protected final Object parseValueInt(String string) {
            try {
                return string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new byte[0];
            }
        }

        @Override
        public final int getAlignment() {
            return 10;
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    static final class j
    extends Formats {
        private j() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return f.format((Date)object);
        }

        @Override
        protected final Object parseValueInt(String string) {
            return f.parse(string);
        }

        @Override
        public final int getAlignment() {
            return 0;
        }

        /* synthetic */ j(byte by) {
            this();
        }
    }

    static final class d
    extends Formats {
        private d() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return e.format((Date)object);
        }

        @Override
        protected final Object parseValueInt(String string) {
            return e.parse(string);
        }

        @Override
        public final int getAlignment() {
            return 0;
        }

        /* synthetic */ d(byte by) {
            this();
        }
    }

    static final class k
    extends Formats {
        private k() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return g.format((Date)object);
        }

        @Override
        protected final Object parseValueInt(String string) {
            try {
                return g.parse(string);
            }
            catch (ParseException parseException) {
                return e.parse(string);
            }
        }

        @Override
        public final int getAlignment() {
            return 0;
        }

        /* synthetic */ k(byte by) {
            this();
        }
    }

    static final class a
    extends Formats {
        private a() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return ((Boolean)object).toString();
        }

        @Override
        protected final Object parseValueInt(String string) {
            return Boolean.valueOf(string);
        }

        @Override
        public final int getAlignment() {
            return 0;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    static final class c
    extends Formats {
        private c() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return c.format(DoubleUtils.fixDecimals((Number)object));
        }

        @Override
        protected final Object parseValueInt(String string) {
            try {
                return new Double(c.parse(string).doubleValue());
            }
            catch (ParseException parseException) {
                return new Double(b.parse(string).doubleValue());
            }
        }

        @Override
        public final int getAlignment() {
            return 4;
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    static final class h
    extends Formats {
        private h() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return d.format(DoubleUtils.fixDecimals((Number)object));
        }

        @Override
        protected final Object parseValueInt(String string) {
            try {
                return new Double(d.parse(string).doubleValue());
            }
            catch (ParseException parseException) {
                return new Double(b.parse(string).doubleValue() / 100.0);
            }
        }

        @Override
        public final int getAlignment() {
            return 4;
        }

        /* synthetic */ h(byte by) {
            this();
        }
    }

    static final class e
    extends Formats {
        private e() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return b.format(DoubleUtils.fixDecimals((Number)object));
        }

        @Override
        protected final Object parseValueInt(String string) {
            return new Double(b.parse(string).doubleValue());
        }

        @Override
        public final int getAlignment() {
            return 4;
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    static final class i
    extends Formats {
        private i() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return (String)object;
        }

        @Override
        protected final Object parseValueInt(String string) {
            return string;
        }

        @Override
        public final int getAlignment() {
            return 2;
        }

        /* synthetic */ i(byte by) {
            this();
        }
    }

    static final class f
    extends Formats {
        private f() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return a.format(((Number)object).longValue());
        }

        @Override
        protected final Object parseValueInt(String string) {
            return new Integer(a.parse(string).intValue());
        }

        @Override
        public final int getAlignment() {
            return 4;
        }

        /* synthetic */ f(byte by) {
            this();
        }
    }

    static final class g
    extends Formats {
        private g() {
        }

        @Override
        protected final String formatValueInt(Object object) {
            return null;
        }

        @Override
        protected final Object parseValueInt(String string) {
            return null;
        }

        @Override
        public final int getAlignment() {
            return 2;
        }

        /* synthetic */ g(byte by) {
            this();
        }
    }
}

