/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.catalog;

import com.posics.pos.ticket.ProductInfoBasic;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.UIManager;

public class CustomComboRenderer
extends DefaultListCellRenderer {
    public static final Color background = new Color(225, 240, 255);
    private Supplier<String> highlightTextSupplier;

    public CustomComboRenderer(Supplier<String> supplier) {
        this.highlightTextSupplier = supplier;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> object, Object object2, int n2, boolean bl2, boolean bl3) {
        super.getListCellRendererComponent((JList<?>)object, object2, n2, bl2, bl3);
        object = (ProductInfoBasic)object2;
        if (object == null) {
            return this;
        }
        object = CustomComboRenderer.getProductDisplayText(object);
        this.setText((String)object);
        return this;
    }

    public static String getProductDisplayText(ProductInfoBasic productInfoBasic) {
        if (productInfoBasic == null) {
            return "";
        }
        return String.format("%s [%s]", productInfoBasic.getName(), productInfoBasic.getCode());
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.getText().toLowerCase().contains(this.highlightTextSupplier.get().toLowerCase())) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getText().substring(0, this.getText().toLowerCase().indexOf(this.highlightTextSupplier.get().toLowerCase()));
            String string2 = this.getText().substring(this.getText().toLowerCase().indexOf(this.highlightTextSupplier.get().toLowerCase()), this.getText().toLowerCase().indexOf(this.highlightTextSupplier.get().toLowerCase()) + this.highlightTextSupplier.get().length());
            int n2 = fontMetrics.stringWidth(string);
            int n3 = fontMetrics.stringWidth(string2);
            int n4 = fontMetrics.getHeight();
            graphics.setColor(Color.yellow);
            graphics.fillRect(n2, 0, n3, n4);
        }
        super.paint(graphics);
    }

    static {
        UIManager.get("List.background");
        UIManager.get("List.foreground");
    }
}

