/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.catalog;

import com.posics.pos.catalog.AddressDataValues;
import com.posics.pos.catalog.ContentDataValues;
import com.posics.pos.catalog.DefaultAddressDataValues;
import com.posics.pos.catalog.DefaultContentDataValues;
import com.posics.pos.catalog.DefaultNameDataValues;
import com.posics.pos.catalog.NameDataValues;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;

public final class DataFactory {
    private static Random a = new Random(93285L);
    private NameDataValues b = new DefaultNameDataValues();
    private AddressDataValues c = new DefaultAddressDataValues();
    private ContentDataValues d = new DefaultContentDataValues();
    private Random e = new Random();

    @Deprecated
    public DataFactory() {
        this(a);
    }

    private DataFactory(Random random) {
        this.e = random;
    }

    public static DataFactory create() {
        return new DataFactory();
    }

    public static DataFactory create(long l2) {
        return new DataFactory(new Random(l2));
    }

    public static DataFactory createWithOriginalRandom() {
        return new DataFactory(a);
    }

    public final <T> T getItem(List<T> list) {
        return this.getItem(list, 100, null);
    }

    public final <T> T getItem(List<T> list, int n2) {
        return this.getItem(list, n2, null);
    }

    public final <T> T getItem(List<T> list, int n2, T t2) {
        if (list == null) {
            throw new IllegalArgumentException("Item list cannot be null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Item list cannot be empty");
        }
        if (this.chance(n2)) {
            return list.get(this.e.nextInt(list.size()));
        }
        return t2;
    }

    public final <T> T getItem(T[] TArray) {
        return this.getItem(TArray, 100, null);
    }

    public final <T> T getItem(T[] TArray, int n2) {
        return this.getItem(TArray, n2, null);
    }

    public final <T> T getItem(T[] TArray, int n2, T t2) {
        if (TArray == null) {
            throw new IllegalArgumentException("Item array cannot be null");
        }
        if (TArray.length == 0) {
            throw new IllegalArgumentException("Item array cannot be empty");
        }
        if (this.chance(n2)) {
            return TArray[this.e.nextInt(TArray.length)];
        }
        return t2;
    }

    public final String getFirstName() {
        DataFactory dataFactory = this;
        return dataFactory.getItem(dataFactory.b.getFirstNames());
    }

    public final String getName() {
        DataFactory dataFactory = this;
        DataFactory dataFactory2 = this;
        return dataFactory.getItem(dataFactory.b.getFirstNames()) + " " + dataFactory2.getItem(dataFactory2.b.getLastNames());
    }

    public final String getLastName() {
        DataFactory dataFactory = this;
        return dataFactory.getItem(dataFactory.b.getLastNames());
    }

    public final String getStreetName() {
        DataFactory dataFactory = this;
        return dataFactory.getItem(dataFactory.c.getStreetNames());
    }

    public final String getStreetSuffix() {
        DataFactory dataFactory = this;
        return dataFactory.getItem(dataFactory.c.getAddressSuffixes());
    }

    public final String getCity() {
        DataFactory dataFactory = this;
        return dataFactory.getItem(dataFactory.c.getCities());
    }

    public final String getAddress() {
        int n2 = 404 + this.e.nextInt(1400);
        return n2 + " " + this.getStreetName() + " " + this.getStreetSuffix();
    }

    public final String getAddressLine2(int n2) {
        return this.getAddressLine2(n2, null);
    }

    public final String getAddressLine2(int n2, String string) {
        if (this.chance(n2)) {
            return this.getAddressLine2();
        }
        return string;
    }

    public final String getAddressLine2() {
        int n2 = this.e.nextInt(100);
        if (n2 < 50) {
            return "Apt #100" + this.e.nextInt(1000);
        }
        return "Suite #100" + this.e.nextInt(1000);
    }

    public final Date getBirthDate() {
        Date date = new Date(0L);
        return this.getDate(date, -5475, 5475);
    }

    public final int getNumber() {
        return this.e.nextInt();
    }

    public final int getNumberUpTo(int n2) {
        return this.getNumberBetween(0, n2);
    }

    public final int getNumberBetween(int n2, int n3) {
        if (n3 < n2) {
            throw new IllegalArgumentException(String.format("Minimum must be less than minimum (min=%d, max=%d)", n2, n3));
        }
        if (n3 == n2) {
            return n2;
        }
        return n2 + this.e.nextInt(n3 - n2);
    }

    public final Date getDate(int n2, int n3, int n4) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(n2, n3 - 1, n4, 0, 0, 0);
        return calendar.getTime();
    }

    public final Date getDate(Date date, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n4 = n2 + this.e.nextInt(n3 - n2);
        calendar.add(5, n4);
        return calendar.getTime();
    }

    public final Date getDateBetween(Date date, Date date2) {
        long l2 = (date2.getTime() - date.getTime()) / 1000L;
        l2 = (long)(this.e.nextDouble() * (double)l2);
        date2 = new Date();
        date2.setTime(date.getTime() + l2 * 1000L);
        return date2;
    }

    public final String getRandomText(int n2) {
        int n3 = n2;
        return this.getRandomText(n3, n3);
    }

    public final String getRandomText(int n2, int n3) {
        DataFactory.a(n2, n3);
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = n2;
        if (n3 != n2) {
            n4 = n2 + this.e.nextInt(n3 - n2);
        }
        while (n4 > 0) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" ");
                --n4;
            }
            double d2 = 1.0 + Math.abs(this.e.nextGaussian()) * 6.0;
            n2 = (int)Math.min((double)n4, d2);
            String string = this.getRandomWord(n2);
            stringBuilder.append(string);
            n4 -= string.length();
        }
        return stringBuilder.toString();
    }

    private static void a(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Minimum length must be a non-negative number");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Maximum length must be a non-negative number");
        }
        if (n3 < n2) {
            throw new IllegalArgumentException(String.format("Minimum length must be less than maximum length (min=%d, max=%d)", n2, n3));
        }
    }

    public final char getRandomChar() {
        return (char)(this.e.nextInt(26) + 97);
    }

    public final String getRandomChars(int n2) {
        int n3 = n2;
        return this.getRandomChars(n3, n3);
    }

    public final String getRandomChars(int n2, int n3) {
        DataFactory.a(n2, n3);
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = n2;
        if (n3 != n2) {
            n4 = n2 + this.e.nextInt(n3 - n2);
        }
        while (n4 > 0) {
            stringBuilder.append(this.getRandomChar());
            --n4;
        }
        return stringBuilder.toString();
    }

    public final String getRandomWord() {
        DataFactory dataFactory = this;
        return dataFactory.getItem(dataFactory.d.getWords());
    }

    public final String getRandomWord(int n2) {
        int n3 = n2;
        return this.getRandomWord(n3, n3);
    }

    public final String getRandomWord(int n2, boolean bl2) {
        if (bl2) {
            int n3 = n2;
            return this.getRandomWord(n3, n3);
        }
        return this.getRandomWord(0, n2);
    }

    public final String getRandomWord(int n2, int n3) {
        DataFactory.a(n2, n3);
        if (n3 == 1) {
            if (this.chance(50)) {
                return "a";
            }
            return "I";
        }
        String[] stringArray = this.d.getWords();
        int n4 = this.e.nextInt(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n5 = (i2 + n4) % stringArray.length;
            String string = stringArray[n5];
            if (string.length() < n2 || string.length() > n3) continue;
            return string;
        }
        return this.getRandomChars(n2, n3);
    }

    public final String getSuffix(int n2) {
        DataFactory dataFactory = this;
        return dataFactory.getItem(dataFactory.b.getSuffixes(), n2);
    }

    public final String getPrefix(int n2) {
        DataFactory dataFactory = this;
        return dataFactory.getItem(dataFactory.b.getPrefixes(), n2);
    }

    public final String getNumberText(int n2) {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + this.e.nextInt(10);
        }
        return string;
    }

    public final String getBusinessName() {
        DataFactory dataFactory = this;
        return this.getCity() + " " + dataFactory.getItem(dataFactory.d.getBusinessTypes());
    }

    public final String getEmailAddress() {
        String string;
        int n2 = this.e.nextInt(100);
        if (n2 < 50) {
            string = this.getFirstName().charAt(0) + this.getLastName();
        } else {
            DataFactory dataFactory = this;
            DataFactory dataFactory2 = this;
            string = dataFactory.getItem(dataFactory.d.getWords()) + dataFactory2.getItem(dataFactory2.d.getWords());
        }
        if (this.e.nextInt(100) > 80) {
            string = string + this.e.nextInt(100);
        }
        DataFactory dataFactory = this;
        DataFactory dataFactory3 = this;
        string = string + "@" + dataFactory.getItem(dataFactory.d.getEmailHosts()) + "." + dataFactory3.getItem(dataFactory3.d.getTlds());
        return string.toLowerCase();
    }

    public final boolean chance(int n2) {
        return this.e.nextInt(100) < n2;
    }

    public final NameDataValues getNameDataValues() {
        return this.b;
    }

    public final void randomize(int n2) {
        this.e = new Random(n2);
    }

    public final void setNameDataValues(NameDataValues nameDataValues) {
        this.b = nameDataValues;
    }

    public final void setAddressDataValues(AddressDataValues addressDataValues) {
        this.c = addressDataValues;
    }

    public final void setContentDataValues(ContentDataValues contentDataValues) {
        this.d = contentDataValues;
    }
}

