/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.inventory;

import com.posics.data.user.DirtyManager;
import com.posics.data.user.EditorRecord;
import com.posics.format.Formats;
import com.posics.pos.config.LAFColors;
import com.posics.pos.forms.AppLocal;
import java.awt.Component;
import java.util.UUID;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class AttributeValuesEditor
extends JPanel
implements EditorRecord {
    private Object id;
    private Object attid;
    private Object insertid;
    private JLabel jLabel2;
    private JTextField jValue;

    public AttributeValuesEditor(DirtyManager dirtyManager) {
        AttributeValuesEditor attributeValuesEditor = this;
        this.jLabel2 = new JLabel();
        attributeValuesEditor.jValue = new JTextField();
        attributeValuesEditor.setBackground(LAFColors.COLOR_PANEL);
        attributeValuesEditor.jLabel2.setForeground(LAFColors.COLOR_LABEL);
        attributeValuesEditor.jLabel2.setText(AppLocal.getIntString("label.value"));
        GroupLayout groupLayout = new GroupLayout(attributeValuesEditor);
        attributeValuesEditor.setLayout(groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(attributeValuesEditor.jLabel2, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(attributeValuesEditor.jValue, -2, 200, -2).addContainerGap()));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(attributeValuesEditor.jLabel2).addComponent(attributeValuesEditor.jValue, -2, 25, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jValue.getDocument().addDocumentListener(dirtyManager);
    }

    public void setInsertId(String string) {
        this.insertid = string;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void writeValueEOF() {
        this.id = null;
        this.attid = null;
        this.jValue.setText(null);
        this.jValue.setEnabled(false);
    }

    @Override
    public void writeValueInsert() {
        this.id = UUID.randomUUID().toString();
        this.attid = this.insertid;
        this.jValue.setText(null);
        this.jValue.requestFocus();
        this.jValue.setEnabled(true);
    }

    @Override
    public void writeValueEdit(Object objectArray) {
        objectArray = objectArray;
        this.id = objectArray[0];
        this.attid = objectArray[1];
        this.jValue.setText(Formats.STRING.formatValue(objectArray[2]));
        this.jValue.setEnabled(true);
    }

    @Override
    public void writeValueDelete(Object objectArray) {
        objectArray = objectArray;
        this.id = objectArray[0];
        this.attid = objectArray[1];
        this.jValue.setText(Formats.STRING.formatValue(objectArray[2]));
        this.jValue.setEnabled(false);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Object createValue() {
        return new Object[]{this.id, this.attid, Formats.STRING.formatValue(this.jValue.getText())};
    }
}

