/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.inventory;

import com.posics.format.Formats;
import com.posics.pos.ticket.ProductInfoExt;
import com.posics.pos.ticket.TaxInfo;
import com.posics.pos.util.StringUtils;

public class InventoryLine {
    private double a;
    private double b;
    private double c;
    private double d;
    private TaxInfo e;
    private String f;
    private String g;
    private String h;
    private String i;
    private String j;

    public InventoryLine(ProductInfoExt productInfoExt, TaxInfo taxInfo) {
        this.f = productInfoExt.getID();
        this.g = productInfoExt.getName();
        this.a = 1.0;
        this.c = productInfoExt.getPriceBuy();
        this.b = productInfoExt.getPriceBuy();
        this.d = productInfoExt.getPriceSell();
        this.h = productInfoExt.getAttributeSetID();
        this.i = null;
        this.j = null;
        this.e = taxInfo;
    }

    public InventoryLine(ProductInfoExt productInfoExt) {
        this.f = productInfoExt.getID();
        this.g = productInfoExt.getName();
        this.a = 1.0;
        this.c = productInfoExt.getPriceBuy();
        this.b = productInfoExt.getPriceBuy();
        this.d = productInfoExt.getPriceSell();
        this.h = productInfoExt.getAttributeSetID();
        this.i = null;
        this.j = null;
        this.e = null;
    }

    public InventoryLine(ProductInfoExt productInfoExt, double d2, double d3, TaxInfo taxInfo) {
        this.f = productInfoExt.getID();
        this.g = productInfoExt.getName();
        this.a = d2;
        this.c = d3;
        this.b = productInfoExt.getPriceBuy();
        this.d = productInfoExt.getPriceSell();
        this.h = productInfoExt.getAttributeSetID();
        this.i = null;
        this.j = null;
        this.e = taxInfo;
    }

    public InventoryLine(ProductInfoExt productInfoExt, double d2, double d3) {
        this.f = productInfoExt.getID();
        this.g = productInfoExt.getName();
        this.a = d2;
        this.c = d3;
        this.b = productInfoExt.getPriceBuy();
        this.d = productInfoExt.getPriceSell();
        this.h = productInfoExt.getAttributeSetID();
        this.i = null;
        this.j = null;
        this.e = null;
    }

    public String getProductID() {
        return this.f;
    }

    public String getProductName() {
        return this.g;
    }

    public void setProductName(String string) {
        if (this.f == null) {
            this.g = string;
        }
    }

    public double getMultiply() {
        return this.a;
    }

    public void setMultiply(double d2) {
        this.a = d2;
    }

    public double getPrice() {
        return this.c;
    }

    public double getCurrentPriceBuy() {
        return this.b;
    }

    public void setCurrentPriceBuy(double d2) {
        this.b = d2;
    }

    public double getSubValue() {
        return this.c * (1.0 + this.getTaxRate()) * this.a;
    }

    public double getPriceTax() {
        return this.c * (1.0 + this.getTaxRate());
    }

    public double getPriceSellTax() {
        return this.d * (1.0 + this.getTaxRate());
    }

    public void setPrice(double d2) {
        this.c = d2;
    }

    public void setPriceTax(double d2) {
        this.c = d2 / (1.0 + this.getTaxRate());
    }

    public String getProductAttSetInstId() {
        return this.i;
    }

    public void setProductAttSetInstId(String string) {
        this.i = string;
    }

    public String getProductAttSetId() {
        return this.h;
    }

    public String getProductAttSetInstDesc() {
        return this.j;
    }

    public void setProductAttSetInstDesc(String string) {
        this.j = string;
    }

    public String printName() {
        return StringUtils.encodeXML(this.g);
    }

    public String printPrice() {
        return Formats.CURRENCY.formatValue(new Double(this.getPrice()));
    }

    public String printPriceSellTax() {
        return Formats.CURRENCY.formatValue(this.d * (1.0 + this.getTaxRate()));
    }

    public String printMultiply() {
        return Formats.DOUBLE.formatValue(this.a);
    }

    public String printSubValue() {
        return Formats.CURRENCY.formatValue(new Double(this.getSubValue()));
    }

    public double getTax() {
        return this.c * this.a * this.getTaxRate();
    }

    public TaxInfo getTaxInfo() {
        return this.e;
    }

    public void setTaxInfo(TaxInfo taxInfo) {
        this.e = taxInfo;
    }

    public double getTaxRate() {
        if (this.e == null) {
            return 0.0;
        }
        return this.e.getRate();
    }
}

