/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.inventory;

import com.posics.format.Formats;
import com.posics.pos.inventory.InventoryLine;
import com.posics.pos.inventory.LocationInfo;
import com.posics.pos.inventory.MovementReason;
import com.posics.pos.suppliers.SupplierInfoExt;
import com.posics.pos.util.StringUtils;
import java.util.Date;
import java.util.List;

public class InventoryRecord {
    private Date a;
    private MovementReason b;
    private LocationInfo c;
    private List<InventoryLine> d;
    private SupplierInfoExt e;
    private String f;

    public InventoryRecord(Date date, MovementReason movementReason, LocationInfo locationInfo, List<InventoryLine> list, SupplierInfoExt supplierInfoExt, String string) {
        this.a = date;
        this.b = movementReason;
        this.c = locationInfo;
        this.d = list;
        this.e = supplierInfoExt;
        this.f = string;
    }

    public Date getDate() {
        return this.a;
    }

    public MovementReason getReason() {
        return this.b;
    }

    public LocationInfo getLocation() {
        return this.c;
    }

    public SupplierInfoExt getSupplier() {
        return this.e;
    }

    public String getReference() {
        return this.f;
    }

    public List<InventoryLine> getLines() {
        return this.d;
    }

    public boolean isInput() {
        return this.b.isInput();
    }

    public double getSubTotal() {
        double d2 = 0.0;
        for (InventoryLine inventoryLine : this.d) {
            d2 += inventoryLine.getSubValue();
        }
        return d2;
    }

    public String printDate() {
        return Formats.TIMESTAMP.formatValue(this.a);
    }

    public String printLocation() {
        return StringUtils.encodeXML(this.c.toString());
    }

    public String printReason() {
        return StringUtils.encodeXML(this.b.toString());
    }

    public String printReference() {
        return StringUtils.encodeXML(this.f.toString());
    }

    public String printSupplier() {
        if (this.e != null) {
            return StringUtils.encodeXML(this.e.getName());
        }
        return "";
    }

    public String printSubTotal() {
        return Formats.CURRENCY.formatValue(new Double(this.getSubTotal()));
    }
}

