/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.inventory;

import com.posics.format.Formats;
import com.posics.pos.config.LAFColors;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.inventory.InventoryLine;
import com.posics.pos.inventory.s;
import com.posics.pos.ticket.TicketTaxInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JInventoryLines
extends JPanel {
    private InventoryTableModel m_inventorylines;
    private JScrollPane jScrollPane1;
    private JTable m_tableinventory;

    public JInventoryLines() {
        Serializable serializable = this;
        this.jScrollPane1 = new JScrollPane();
        ((JInventoryLines)serializable).m_tableinventory = new JTable();
        ((JComponent)serializable).setBackground(new Color(194, 206, 161));
        ((Container)serializable).setLayout(new BorderLayout());
        ((JInventoryLines)serializable).jScrollPane1.setBackground(new Color(194, 206, 161));
        ((JInventoryLines)serializable).jScrollPane1.setHorizontalScrollBarPolicy(31);
        ((JInventoryLines)serializable).jScrollPane1.setVerticalScrollBarPolicy(22);
        ((JInventoryLines)serializable).m_tableinventory.setAutoCreateColumnsFromModel(false);
        ((JInventoryLines)serializable).m_tableinventory.setBackground(new Color(194, 206, 161));
        ((JInventoryLines)serializable).m_tableinventory.setAutoResizeMode(3);
        ((JInventoryLines)serializable).m_tableinventory.setFocusable(false);
        ((JInventoryLines)serializable).m_tableinventory.setIntercellSpacing(new Dimension(0, 1));
        ((JInventoryLines)serializable).m_tableinventory.setRequestFocusEnabled(false);
        ((JInventoryLines)serializable).m_tableinventory.setShowVerticalLines(false);
        ((JInventoryLines)serializable).jScrollPane1.setViewportView(((JInventoryLines)serializable).m_tableinventory);
        JInventoryLines jInventoryLines = serializable;
        jInventoryLines.add((Component)jInventoryLines.jScrollPane1, "Center");
        serializable = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 300, new DataCellRenderer(2), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(AppLocal.getIntString("label.item"));
        ((DefaultTableColumnModel)serializable).addColumn(tableColumn);
        tableColumn = new TableColumn(1, 100, new DataCellRenderer(4), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(AppLocal.getIntString("label.units"));
        ((DefaultTableColumnModel)serializable).addColumn(tableColumn);
        tableColumn = new TableColumn(2, 150, new DataCellRenderer(4), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(AppLocal.getIntString("label.price"));
        ((DefaultTableColumnModel)serializable).addColumn(tableColumn);
        tableColumn = new TableColumn(3, 150, new DataCellRenderer(4), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(AppLocal.getIntString("label.taxes"));
        ((DefaultTableColumnModel)serializable).addColumn(tableColumn);
        tableColumn = new TableColumn(4, 150, new DataCellRenderer(4), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(AppLocal.getIntString("label.totalcash"));
        ((DefaultTableColumnModel)serializable).addColumn(tableColumn);
        this.m_tableinventory.setColumnModel((TableColumnModel)((Object)serializable));
        this.m_tableinventory.getTableHeader().setReorderingAllowed(false);
        this.m_tableinventory.setRowHeight(40);
        this.m_tableinventory.getSelectionModel().setSelectionMode(0);
        this.m_tableinventory.setIntercellSpacing(new Dimension(0, 1));
        this.m_tableinventory.setBackground(LAFColors.LCD_BACK);
        this.m_inventorylines = new InventoryTableModel(null);
        this.m_tableinventory.setModel(this.m_inventorylines);
        this.m_tableinventory.setShowGrid(false);
        this.m_tableinventory.setSelectionBackground(LAFColors.LCD_BACK_LIGHT);
        this.m_tableinventory.setSelectionForeground(new Color(0, 0, 0));
        this.m_tableinventory.setFillsViewportHeight(true);
        this.m_tableinventory.getTableHeader().setBackground(LAFColors.LCD_BACK);
        this.jScrollPane1.setBackground(LAFColors.LCD_BACK);
        this.jScrollPane1.getVerticalScrollBar().setBackground(LAFColors.LCD_BACK);
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(35, 35));
        this.jScrollPane1.getVerticalScrollBar().setUI(new s(this));
    }

    public void clear() {
        this.m_inventorylines.clear();
    }

    public void addLine(InventoryLine inventoryLine) {
        this.m_inventorylines.addRow(inventoryLine);
        JInventoryLines jInventoryLines = this;
        jInventoryLines.setSelectedIndex(jInventoryLines.m_inventorylines.getRowCount() - 1);
    }

    public void deleteLine(int n2) {
        this.m_inventorylines.removeRow(n2);
        if (n2 >= this.m_inventorylines.getRowCount()) {
            n2 = this.m_inventorylines.getRowCount() - 1;
        }
        if (n2 >= 0 && n2 < this.m_inventorylines.getRowCount()) {
            this.setSelectedIndex(n2);
        }
    }

    public void setLine(int n2, InventoryLine inventoryLine) {
        this.m_inventorylines.setRow(n2, inventoryLine);
        this.setSelectedIndex(n2);
    }

    public InventoryLine getLine(int n2) {
        return this.m_inventorylines.getRow(n2);
    }

    public List<InventoryLine> getLines() {
        return this.m_inventorylines.getLines();
    }

    public int getCount() {
        return this.m_inventorylines.getRowCount();
    }

    public double getSubTotal() {
        double d2 = 0.0;
        for (InventoryLine inventoryLine : this.m_inventorylines.getLines()) {
            d2 += inventoryLine.getPrice() * inventoryLine.getMultiply();
        }
        return d2;
    }

    public String printSubTotal() {
        return Formats.CURRENCY.formatValue(new Double(this.getSubTotal()));
    }

    public double getTotal() {
        return this.getSubTotal() + this.getTax();
    }

    public String printTotal() {
        return Formats.CURRENCY.formatValue(new Double(this.getTotal()));
    }

    public double getTax() {
        double d2 = 0.0;
        if (this.hasTaxesCalculated()) {
            for (TicketTaxInfo ticketTaxInfo : this.m_inventorylines.getTaxes()) {
                d2 += ticketTaxInfo.getTax();
            }
        } else {
            for (InventoryLine inventoryLine : this.m_inventorylines.getLines()) {
                d2 += inventoryLine.getTax();
            }
        }
        return d2;
    }

    public String printTax() {
        return Formats.CURRENCY.formatValue(new Double(this.getTax()));
    }

    public boolean hasTaxesCalculated() {
        return this.m_inventorylines.getTaxes() != null;
    }

    public int getSelectedRow() {
        return this.m_tableinventory.getSelectedRow();
    }

    public void setSelectedIndex(int n2) {
        int n3 = n2;
        this.m_tableinventory.getSelectionModel().setSelectionInterval(n3, n3);
        Rectangle rectangle = this.m_tableinventory.getCellRect(n2, 0, true);
        this.m_tableinventory.scrollRectToVisible(rectangle);
    }

    public void goDown() {
        int n2 = this.m_tableinventory.getSelectionModel().getMaxSelectionIndex();
        if (n2 < 0) {
            n2 = 0;
        } else if (++n2 >= this.m_inventorylines.getRowCount()) {
            n2 = this.m_inventorylines.getRowCount() - 1;
        }
        if (n2 >= 0 && n2 < this.m_inventorylines.getRowCount()) {
            this.setSelectedIndex(n2);
        }
    }

    public void goUp() {
        int n2 = this.m_tableinventory.getSelectionModel().getMinSelectionIndex();
        if (n2 < 0) {
            n2 = this.m_inventorylines.getRowCount() - 1;
        } else if (--n2 < 0) {
            n2 = 0;
        }
        if (n2 >= 0 && n2 < this.m_inventorylines.getRowCount()) {
            this.setSelectedIndex(n2);
        }
    }

    private static class DataCellRenderer
    extends DefaultTableCellRenderer {
        private int m_iAlignment;

        public DataCellRenderer(int n2) {
            this.m_iAlignment = n2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jComponent, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            jComponent = (JLabel)super.getTableCellRendererComponent((JTable)jComponent, object, bl2, bl3, n2, n3);
            ((JLabel)jComponent).setVerticalAlignment(1);
            ((JLabel)jComponent).setHorizontalAlignment(this.m_iAlignment);
            return jComponent;
        }
    }

    private static class InventoryTableModel
    extends AbstractTableModel {
        private ArrayList<InventoryLine> m_rows = new ArrayList();
        private List<TicketTaxInfo> taxes;

        private InventoryTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.m_rows.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n2) {
            return "a";
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            InventoryLine inventoryLine = this.m_rows.get(n2);
            switch (n3) {
                case 0: {
                    return "<html>" + inventoryLine.getProductName() + (inventoryLine.getProductAttSetInstDesc() == null ? "" : "<br>" + inventoryLine.getProductAttSetInstDesc());
                }
                case 1: {
                    return "x" + Formats.DOUBLE.formatValue(inventoryLine.getMultiply());
                }
                case 2: {
                    return Formats.CURRENCY.formatValue(inventoryLine.getPrice());
                }
                case 3: {
                    return Formats.CURRENCY.formatValue(inventoryLine.getTax());
                }
                case 4: {
                    return Formats.CURRENCY.formatValue(inventoryLine.getSubValue());
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public void clear() {
            int n2 = this.getRowCount();
            if (n2 > 0) {
                this.m_rows.clear();
                this.fireTableRowsDeleted(0, n2 - 1);
            }
        }

        public List<InventoryLine> getLines() {
            return this.m_rows;
        }

        public List<TicketTaxInfo> getTaxes() {
            return this.taxes;
        }

        public InventoryLine getRow(int n2) {
            return this.m_rows.get(n2);
        }

        public void setRow(int n2, InventoryLine inventoryLine) {
            this.m_rows.set(n2, inventoryLine);
            int n3 = n2;
            this.fireTableRowsUpdated(n3, n3);
        }

        public void addRow(InventoryLine inventoryLine) {
            InventoryTableModel inventoryTableModel = this;
            inventoryTableModel.insertRow(inventoryTableModel.m_rows.size(), inventoryLine);
        }

        public void insertRow(int n2, InventoryLine inventoryLine) {
            this.m_rows.add(n2, inventoryLine);
            int n3 = n2;
            this.fireTableRowsInserted(n3, n3);
        }

        public void removeRow(int n2) {
            this.m_rows.remove(n2);
            int n3 = n2;
            this.fireTableRowsDeleted(n3, n3);
        }

        /* synthetic */ InventoryTableModel(s s2) {
            this();
        }
    }
}

