/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.inventory;

import com.posics.format.Formats;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.inventory.InventoryLine;
import com.posics.pos.inventory.d;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JInventoryLines_old
extends JPanel {
    private InventoryTableModel m_inventorylines;
    private JScrollPane jScrollPane1;
    private JTable m_tableinventory;

    public JInventoryLines_old() {
        Serializable serializable = this;
        this.jScrollPane1 = new JScrollPane();
        ((JInventoryLines_old)serializable).m_tableinventory = new JTable();
        ((Container)serializable).setLayout(new BorderLayout());
        ((JInventoryLines_old)serializable).m_tableinventory.setAutoCreateColumnsFromModel(false);
        ((JInventoryLines_old)serializable).m_tableinventory.setAutoResizeMode(0);
        ((JInventoryLines_old)serializable).m_tableinventory.setFocusable(false);
        ((JInventoryLines_old)serializable).m_tableinventory.setRequestFocusEnabled(false);
        ((JInventoryLines_old)serializable).m_tableinventory.setShowVerticalLines(false);
        ((JInventoryLines_old)serializable).jScrollPane1.setViewportView(((JInventoryLines_old)serializable).m_tableinventory);
        JInventoryLines_old jInventoryLines_old = serializable;
        jInventoryLines_old.add((Component)jInventoryLines_old.jScrollPane1, "Center");
        serializable = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 200, new DataCellRenderer(2), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(AppLocal.getIntString("label.item"));
        ((DefaultTableColumnModel)serializable).addColumn(tableColumn);
        tableColumn = new TableColumn(1, 75, new DataCellRenderer(4), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(AppLocal.getIntString("label.units"));
        ((DefaultTableColumnModel)serializable).addColumn(tableColumn);
        tableColumn = new TableColumn(2, 75, new DataCellRenderer(4), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(AppLocal.getIntString("label.price"));
        ((DefaultTableColumnModel)serializable).addColumn(tableColumn);
        this.m_tableinventory.setColumnModel((TableColumnModel)((Object)serializable));
        this.m_tableinventory.getTableHeader().setReorderingAllowed(false);
        this.m_tableinventory.setRowHeight(40);
        this.m_tableinventory.getSelectionModel().setSelectionMode(0);
        this.m_tableinventory.setIntercellSpacing(new Dimension(0, 1));
        this.m_inventorylines = new InventoryTableModel(null);
        this.m_tableinventory.setModel(this.m_inventorylines);
    }

    public void clear() {
        this.m_inventorylines.clear();
    }

    public void addLine(InventoryLine inventoryLine) {
        this.m_inventorylines.addRow(inventoryLine);
        JInventoryLines_old jInventoryLines_old = this;
        jInventoryLines_old.setSelectedIndex(jInventoryLines_old.m_inventorylines.getRowCount() - 1);
    }

    public void deleteLine(int n2) {
        this.m_inventorylines.removeRow(n2);
        if (n2 >= this.m_inventorylines.getRowCount()) {
            n2 = this.m_inventorylines.getRowCount() - 1;
        }
        if (n2 >= 0 && n2 < this.m_inventorylines.getRowCount()) {
            this.setSelectedIndex(n2);
        }
    }

    public void setLine(int n2, InventoryLine inventoryLine) {
        this.m_inventorylines.setRow(n2, inventoryLine);
        this.setSelectedIndex(n2);
    }

    public InventoryLine getLine(int n2) {
        return this.m_inventorylines.getRow(n2);
    }

    public List<InventoryLine> getLines() {
        return this.m_inventorylines.getLines();
    }

    public int getCount() {
        return this.m_inventorylines.getRowCount();
    }

    public int getSelectedRow() {
        return this.m_tableinventory.getSelectedRow();
    }

    public void setSelectedIndex(int n2) {
        int n3 = n2;
        this.m_tableinventory.getSelectionModel().setSelectionInterval(n3, n3);
        Rectangle rectangle = this.m_tableinventory.getCellRect(n2, 0, true);
        this.m_tableinventory.scrollRectToVisible(rectangle);
    }

    public void goDown() {
        int n2 = this.m_tableinventory.getSelectionModel().getMaxSelectionIndex();
        if (n2 < 0) {
            n2 = 0;
        } else if (++n2 >= this.m_inventorylines.getRowCount()) {
            n2 = this.m_inventorylines.getRowCount() - 1;
        }
        if (n2 >= 0 && n2 < this.m_inventorylines.getRowCount()) {
            this.setSelectedIndex(n2);
        }
    }

    public void goUp() {
        int n2 = this.m_tableinventory.getSelectionModel().getMinSelectionIndex();
        if (n2 < 0) {
            n2 = this.m_inventorylines.getRowCount() - 1;
        } else if (--n2 < 0) {
            n2 = 0;
        }
        if (n2 >= 0 && n2 < this.m_inventorylines.getRowCount()) {
            this.setSelectedIndex(n2);
        }
    }

    private static class DataCellRenderer
    extends DefaultTableCellRenderer {
        private int m_iAlignment;

        public DataCellRenderer(int n2) {
            this.m_iAlignment = n2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jComponent, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            jComponent = (JLabel)super.getTableCellRendererComponent((JTable)jComponent, object, bl2, bl3, n2, n3);
            ((JLabel)jComponent).setVerticalAlignment(1);
            ((JLabel)jComponent).setHorizontalAlignment(this.m_iAlignment);
            if (!bl2) {
                jComponent.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            }
            return jComponent;
        }
    }

    private static class InventoryTableModel
    extends AbstractTableModel {
        private ArrayList<InventoryLine> m_rows = new ArrayList();

        private InventoryTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.m_rows.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n2) {
            return "a";
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            InventoryLine inventoryLine = this.m_rows.get(n2);
            switch (n3) {
                case 0: {
                    return "<html>" + inventoryLine.getProductName() + (inventoryLine.getProductAttSetInstDesc() == null ? "" : "<br>" + inventoryLine.getProductAttSetInstDesc());
                }
                case 1: {
                    return "x" + Formats.DOUBLE.formatValue(inventoryLine.getMultiply());
                }
                case 2: {
                    return Formats.CURRENCY.formatValue(inventoryLine.getPrice());
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public void clear() {
            int n2 = this.getRowCount();
            if (n2 > 0) {
                this.m_rows.clear();
                this.fireTableRowsDeleted(0, n2 - 1);
            }
        }

        public List<InventoryLine> getLines() {
            return this.m_rows;
        }

        public InventoryLine getRow(int n2) {
            return this.m_rows.get(n2);
        }

        public void setRow(int n2, InventoryLine inventoryLine) {
            this.m_rows.set(n2, inventoryLine);
            int n3 = n2;
            this.fireTableRowsUpdated(n3, n3);
        }

        public void addRow(InventoryLine inventoryLine) {
            InventoryTableModel inventoryTableModel = this;
            inventoryTableModel.insertRow(inventoryTableModel.m_rows.size(), inventoryLine);
        }

        public void insertRow(int n2, InventoryLine inventoryLine) {
            this.m_rows.add(n2, inventoryLine);
            int n3 = n2;
            this.fireTableRowsInserted(n3, n3);
        }

        public void removeRow(int n2) {
            this.m_rows.remove(n2);
            int n3 = n2;
            this.fireTableRowsDeleted(n3, n3);
        }

        /* synthetic */ InventoryTableModel(d d2) {
            this();
        }
    }
}

