/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.inventory;

import com.posics.basic.BasicException;
import com.posics.data.gui.ComboBoxValModel;
import com.posics.data.gui.JImageEditor;
import com.posics.data.loader.SentenceList;
import com.posics.data.user.DirtyManager;
import com.posics.data.user.EditorRecord;
import com.posics.format.Formats;
import com.posics.pos.config.LAFColors;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.inventory.CodeType;
import com.posics.pos.sales.TaxesLogic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class MaterialsEditor
extends JPanel
implements EditorRecord {
    private ComboBoxValModel m_CodetypeModel;
    private SentenceList m_sentunit;
    private ComboBoxValModel m_UnitModel;
    private Object m_id;
    private Object m_code;
    private double dUnitPrice;
    private SentenceList taxsent;
    private TaxesLogic taxeslogic;
    private SentenceList taxcatsent;
    private ComboBoxValModel taxcatmodel;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTextField m_jAmount;
    private JComboBox m_jCboUnit;
    private JComboBox m_jCodetype;
    private JImageEditor m_jImage;
    private JTextField m_jName;
    private JTextField m_jPriceBuy;
    private JCheckBox m_jScale;
    private JComboBox m_jTax;
    private JLabel m_jTitle;
    private JTextField m_jUnitPrice;
    private JTextField m_jstockcost;
    private JTextField m_jstockvolume;
    private JTextArea txtAttributes;

    public MaterialsEditor(DataLogicSales dataLogicSales, DirtyManager dirtyManager) {
        MaterialsEditor materialsEditor = this;
        this.jLabel2 = new JLabel();
        materialsEditor.m_jName = new JTextField();
        materialsEditor.m_jTitle = new JLabel();
        materialsEditor.jTabbedPane1 = new JTabbedPane();
        materialsEditor.jPanel1 = new JPanel();
        materialsEditor.m_jImage = new JImageEditor();
        materialsEditor.jLabel3 = new JLabel();
        materialsEditor.m_jPriceBuy = new JTextField();
        materialsEditor.m_jCodetype = new JComboBox();
        materialsEditor.m_jUnitPrice = new JTextField();
        materialsEditor.jLabel4 = new JLabel();
        materialsEditor.m_jAmount = new JTextField();
        materialsEditor.m_jCboUnit = new JComboBox();
        materialsEditor.jLabel12 = new JLabel();
        materialsEditor.jLabel7 = new JLabel();
        materialsEditor.m_jTax = new JComboBox();
        materialsEditor.jPanel2 = new JPanel();
        materialsEditor.jLabel9 = new JLabel();
        materialsEditor.m_jstockcost = new JTextField();
        materialsEditor.jLabel10 = new JLabel();
        materialsEditor.m_jstockvolume = new JTextField();
        materialsEditor.jLabel13 = new JLabel();
        materialsEditor.m_jScale = new JCheckBox();
        materialsEditor.jPanel3 = new JPanel();
        materialsEditor.jScrollPane1 = new JScrollPane();
        materialsEditor.txtAttributes = new JTextArea();
        materialsEditor.setBackground(LAFColors.COLOR_PANEL);
        materialsEditor.setLayout(null);
        materialsEditor.jLabel2.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jLabel2.setText(AppLocal.getIntString("label.prodname"));
        MaterialsEditor materialsEditor2 = materialsEditor;
        materialsEditor2.add(materialsEditor2.jLabel2);
        materialsEditor.jLabel2.setBounds(20, 50, 70, 14);
        MaterialsEditor materialsEditor3 = materialsEditor;
        materialsEditor3.add(materialsEditor3.m_jName);
        materialsEditor.m_jName.setBounds(90, 50, 220, 25);
        materialsEditor.m_jTitle.setFont(materialsEditor.m_jTitle.getFont().deriveFont(materialsEditor.m_jTitle.getFont().getStyle() | 2 | 1, materialsEditor.m_jTitle.getFont().getSize() + 5));
        materialsEditor.m_jTitle.setForeground(LAFColors.COLOR_LABEL);
        MaterialsEditor materialsEditor4 = materialsEditor;
        materialsEditor4.add(materialsEditor4.m_jTitle);
        materialsEditor.m_jTitle.setBounds(10, 10, 320, 30);
        materialsEditor.jTabbedPane1.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        materialsEditor.jTabbedPane1.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jTabbedPane1.setPreferredSize(new Dimension(84, 158));
        materialsEditor.jPanel1.setBackground(LAFColors.COLOR_PANEL);
        materialsEditor.m_jImage.setMaxDimensions(new Dimension(64, 64));
        materialsEditor.jLabel3.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jLabel3.setText(AppLocal.getIntString("label.prodpricebuy"));
        materialsEditor.m_jPriceBuy.setHorizontalAlignment(4);
        materialsEditor.m_jUnitPrice.setHorizontalAlignment(4);
        materialsEditor.jLabel4.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jLabel4.setText(AppLocal.getIntString("label.units"));
        materialsEditor.m_jAmount.setHorizontalAlignment(4);
        materialsEditor.jLabel12.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jLabel12.setText(AppLocal.getIntString("label.unitprice"));
        materialsEditor.jLabel7.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jLabel7.setText(AppLocal.getIntString("label.taxcategory"));
        GroupLayout groupLayout = new GroupLayout((Container)materialsEditor.jPanel1);
        materialsEditor.jPanel1.setLayout((LayoutManager)groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)materialsEditor.m_jCodetype, -2, 80, -2).add(81, 81, 81)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)materialsEditor.jLabel7, -2, 140, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)materialsEditor.m_jTax, -2, 170, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)materialsEditor.jLabel3, -2, 150, -2).add((Component)materialsEditor.jLabel4, -2, 136, -2).add((Component)materialsEditor.jLabel12, -2, 117, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)materialsEditor.m_jPriceBuy, -2, 80, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)materialsEditor.m_jAmount, -2, 50, -2).add(10, 10, 10).add((Component)materialsEditor.m_jCboUnit, -2, 110, -2)).add((Component)materialsEditor.m_jUnitPrice, -2, 80, -2)))).add(10, 10, 10))).add((Component)materialsEditor.m_jImage, -2, 200, -2)));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(30, 30, 30).add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)materialsEditor.jLabel3).add((Component)materialsEditor.m_jPriceBuy, -2, 25, -2)).add(5, 5, 5).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)materialsEditor.m_jAmount, -2, 25, -2).add((Component)materialsEditor.jLabel4)).add((Component)materialsEditor.m_jCboUnit, -2, 25, -2)).add(5, 5, 5).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)materialsEditor.m_jUnitPrice, -2, 25, -2).add((Component)materialsEditor.jLabel12)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)materialsEditor.m_jTax, -2, 25, -2).add((Component)materialsEditor.jLabel7)).add(3, 3, 3).add((Component)materialsEditor.m_jCodetype, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(20, 20, 20).add((Component)materialsEditor.m_jImage, -2, 180, -2))).add(62, 62, 62)));
        materialsEditor.jTabbedPane1.addTab(AppLocal.getIntString("label.prodgeneral"), materialsEditor.jPanel1);
        materialsEditor.jPanel2.setBackground(LAFColors.COLOR_PANEL);
        materialsEditor.jLabel9.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jLabel9.setText(AppLocal.getIntString("label.prodstockcost"));
        materialsEditor.m_jstockcost.setHorizontalAlignment(4);
        materialsEditor.jLabel10.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jLabel10.setText(AppLocal.getIntString("label.prodstockvol"));
        materialsEditor.m_jstockvolume.setHorizontalAlignment(4);
        materialsEditor.jLabel13.setForeground(LAFColors.COLOR_LABEL);
        materialsEditor.jLabel13.setText(AppLocal.getIntString("label.prodscale"));
        materialsEditor.m_jScale.setOpaque(false);
        groupLayout = new GroupLayout((Container)materialsEditor.jPanel2);
        materialsEditor.jPanel2.setLayout((LayoutManager)groupLayout);
        GroupLayout groupLayout4 = groupLayout;
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)materialsEditor.jLabel9, -2, 144, -2).add((Component)materialsEditor.jLabel10, -2, 144, -2).add((Component)materialsEditor.jLabel13, -2, 150, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)materialsEditor.m_jScale, -2, 80, -2).add((Component)materialsEditor.m_jstockvolume, -2, 80, -2).add((Component)materialsEditor.m_jstockcost, -2, 80, -2)).addContainerGap(311, Short.MAX_VALUE)));
        GroupLayout groupLayout5 = groupLayout;
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((Component)materialsEditor.jLabel9)).add((Component)materialsEditor.m_jstockcost, -2, 25, -2)).add(6, 6, 6).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((Component)materialsEditor.jLabel10)).add((Component)materialsEditor.m_jstockvolume, -2, 25, -2)).add(5, 5, 5).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(3, 3, 3).add((Component)materialsEditor.jLabel13)).add((Component)materialsEditor.m_jScale))));
        materialsEditor.jTabbedPane1.addTab(AppLocal.getIntString("label.prodstock"), materialsEditor.jPanel2);
        materialsEditor.jPanel3.setBackground(LAFColors.COLOR_PANEL);
        materialsEditor.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        materialsEditor.jPanel3.setLayout(new BorderLayout());
        materialsEditor.jScrollPane1.setBackground(LAFColors.COLOR_PANEL);
        materialsEditor.txtAttributes.setFont(new Font("DialogInput", 0, 12));
        materialsEditor.jScrollPane1.setViewportView(materialsEditor.txtAttributes);
        materialsEditor.jPanel3.add((Component)materialsEditor.jScrollPane1, "Center");
        materialsEditor.jTabbedPane1.addTab("Attributes", materialsEditor.jPanel3);
        MaterialsEditor materialsEditor5 = materialsEditor;
        materialsEditor5.add(materialsEditor5.jTabbedPane1);
        materialsEditor.jTabbedPane1.setBounds(10, 90, 560, 290);
        this.m_CodetypeModel = new ComboBoxValModel();
        this.m_CodetypeModel.add(null);
        this.m_CodetypeModel.add(CodeType.EAN13);
        this.m_CodetypeModel.add(CodeType.CODE128);
        this.m_jCodetype.setModel(this.m_CodetypeModel);
        this.m_jCodetype.setVisible(false);
        this.m_sentunit = dataLogicSales.getUnitsList();
        this.m_UnitModel = new ComboBoxValModel();
        this.taxsent = dataLogicSales.getTaxList();
        this.taxcatsent = dataLogicSales.getTaxCategoriesList();
        this.taxcatmodel = new ComboBoxValModel();
        this.m_jName.getDocument().addDocumentListener(dirtyManager);
        this.m_jScale.addActionListener(dirtyManager);
        this.m_jPriceBuy.getDocument().addDocumentListener(dirtyManager);
        this.m_jImage.addPropertyChangeListener("image", dirtyManager);
        this.m_jstockcost.getDocument().addDocumentListener(dirtyManager);
        this.m_jstockvolume.getDocument().addDocumentListener(dirtyManager);
        this.m_jAmount.getDocument().addDocumentListener(dirtyManager);
        this.m_jUnitPrice.getDocument().addDocumentListener(dirtyManager);
        this.m_jCboUnit.addActionListener(dirtyManager);
        this.txtAttributes.getDocument().addDocumentListener(dirtyManager);
        this.m_jTax.addActionListener(dirtyManager);
        this.m_jPriceBuy.getDocument().addDocumentListener(new a(this, 0));
        this.m_jAmount.getDocument().addDocumentListener(new a(this, 0));
        this.m_jUnitPrice.setEditable(false);
        this.writeValueEOF();
    }

    @Override
    public void refresh() {
    }

    public void activate() {
        this.m_UnitModel = new ComboBoxValModel(this.m_sentunit.list());
        this.m_jCboUnit.setModel(this.m_UnitModel);
        this.taxeslogic = new TaxesLogic(this.taxsent.list());
        this.taxcatmodel = new ComboBoxValModel(this.taxcatsent.list());
        this.m_jTax.setModel(this.taxcatmodel);
    }

    @Override
    public void writeValueEOF() {
        this.m_jTitle.setText(AppLocal.getIntString("label.recordeof"));
        this.m_id = null;
        this.m_code = null;
        this.m_jName.setText(null);
        this.m_jScale.setSelected(false);
        this.m_jPriceBuy.setText(null);
        this.m_jImage.setImage(null);
        this.m_jstockcost.setText(null);
        this.m_jstockvolume.setText(null);
        this.m_UnitModel.setSelectedKey(null);
        this.m_jAmount.setText(null);
        this.m_jUnitPrice.setText(null);
        this.txtAttributes.setText(null);
        this.dUnitPrice = 0.0;
        this.taxcatmodel.setSelectedKey(null);
        this.m_jName.setEnabled(false);
        this.m_jScale.setEnabled(false);
        this.m_jPriceBuy.setEnabled(false);
        this.m_jImage.setEnabled(false);
        this.m_jstockcost.setEnabled(false);
        this.m_jstockvolume.setEnabled(false);
        this.m_jCboUnit.setEnabled(false);
        this.m_jAmount.setEnabled(false);
        this.txtAttributes.setEnabled(false);
        this.m_jTax.setEnabled(false);
    }

    @Override
    public void writeValueInsert() {
        this.m_jTitle.setText(AppLocal.getIntString("label.recordnew"));
        this.m_id = null;
        this.m_code = null;
        this.m_jName.setText(null);
        this.m_jScale.setSelected(false);
        this.m_jPriceBuy.setText(null);
        this.m_jImage.setImage(null);
        this.m_jstockcost.setText(null);
        this.m_jstockvolume.setText(null);
        this.m_UnitModel.setSelectedKey(null);
        this.m_jAmount.setText(null);
        this.m_jUnitPrice.setText(null);
        this.txtAttributes.setText(null);
        this.dUnitPrice = 0.0;
        this.taxcatmodel.setSelectedKey(null);
        this.m_jName.setEnabled(true);
        this.m_jName.requestFocus();
        this.m_jScale.setEnabled(true);
        this.m_jPriceBuy.setEnabled(true);
        this.m_jImage.setEnabled(true);
        this.m_jstockcost.setEnabled(true);
        this.m_jstockvolume.setEnabled(true);
        this.m_jCboUnit.setEnabled(true);
        this.m_jAmount.setEnabled(true);
        this.txtAttributes.setEnabled(true);
        this.m_jTax.setEnabled(true);
    }

    @Override
    public void writeValueDelete(Object objectArray) {
        objectArray = objectArray;
        this.m_jTitle.setText(Formats.STRING.formatValue(objectArray[3]) + " " + AppLocal.getIntString("label.recorddeleted"));
        this.m_id = objectArray[0];
        this.m_code = objectArray[2];
        this.m_jName.setText(Formats.STRING.formatValue(objectArray[3]));
        this.m_jScale.setSelected((Boolean)objectArray[5]);
        this.m_jUnitPrice.setText(Formats.CURRENCY.formatValue(objectArray[6]));
        this.taxcatmodel.setSelectedKey(objectArray[9]);
        this.m_jImage.setImage((BufferedImage)objectArray[10]);
        this.m_jstockcost.setText(Formats.CURRENCY.formatValue(objectArray[11]));
        this.m_jstockvolume.setText(Formats.DOUBLE.formatValue(objectArray[12]));
        this.m_UnitModel.setSelectedKey(objectArray[13]);
        this.m_jAmount.setText(Formats.DOUBLE.formatValue(objectArray[14]));
        this.m_jPriceBuy.setText(Formats.CURRENCY.formatValue(objectArray[15]));
        this.txtAttributes.setText(Formats.BYTEA.formatValue(objectArray[16]));
        this.txtAttributes.setCaretPosition(0);
        this.m_jName.setEnabled(false);
        this.m_jScale.setEnabled(false);
        this.m_jPriceBuy.setEnabled(false);
        this.m_jImage.setEnabled(false);
        this.m_jstockcost.setEnabled(false);
        this.m_jstockvolume.setEnabled(false);
        this.m_jCboUnit.setEnabled(false);
        this.m_jAmount.setEnabled(false);
        this.txtAttributes.setEnabled(false);
        this.m_jTax.setEnabled(false);
    }

    @Override
    public void writeValueEdit(Object objectArray) {
        objectArray = objectArray;
        this.m_jTitle.setText(Formats.STRING.formatValue(objectArray[3]));
        this.m_id = objectArray[0];
        this.m_code = objectArray[2];
        this.m_jName.setText(Formats.STRING.formatValue(objectArray[3]));
        this.m_jScale.setSelected((Boolean)objectArray[5]);
        this.dUnitPrice = (Double)objectArray[6];
        this.m_jUnitPrice.setText(Formats.CURRENCY.formatValue(this.dUnitPrice));
        this.taxcatmodel.setSelectedKey(objectArray[9]);
        this.m_jImage.setImage((BufferedImage)objectArray[10]);
        this.m_jstockcost.setText(Formats.CURRENCY.formatValue(objectArray[11]));
        this.m_jstockvolume.setText(Formats.DOUBLE.formatValue(objectArray[12]));
        this.m_UnitModel.setSelectedKey(objectArray[13]);
        this.m_jAmount.setText(Formats.DOUBLE.formatValue(objectArray[14]));
        this.m_jPriceBuy.setText(Formats.CURRENCY.formatValue(objectArray[15]));
        this.txtAttributes.setText(Formats.BYTEA.formatValue(objectArray[16]));
        this.txtAttributes.setCaretPosition(0);
        this.m_jName.setEnabled(true);
        this.m_jScale.setEnabled(true);
        this.m_jPriceBuy.setEnabled(true);
        this.m_jImage.setEnabled(true);
        this.m_jstockcost.setEnabled(true);
        this.m_jstockvolume.setEnabled(true);
        this.m_jCboUnit.setEnabled(true);
        this.m_jAmount.setEnabled(true);
        this.txtAttributes.setEnabled(true);
        this.m_jTax.setEnabled(true);
    }

    @Override
    public Object createValue() {
        if (this.m_UnitModel.getSelectedKey() == null) {
            throw new BasicException(AppLocal.getIntString("message.unitnotselect"));
        }
        Object[] objectArray = new Object[17];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.m_id == null ? UUID.randomUUID().toString() : this.m_id;
        objectArray2[1] = this.m_jName.getText();
        objectArray2[2] = this.m_code == null ? UUID.randomUUID().toString() : this.m_code;
        objectArray2[3] = this.m_jName.getText();
        objectArray2[4] = Boolean.TRUE;
        objectArray2[5] = this.m_jScale.isSelected();
        objectArray2[6] = this.dUnitPrice;
        objectArray2[7] = 0.0;
        objectArray2[8] = "-1";
        objectArray2[9] = this.taxcatmodel.getSelectedKey();
        objectArray2[10] = this.m_jImage.getImage();
        objectArray2[11] = MaterialsEditor.a(this.m_jstockcost.getText());
        objectArray2[12] = Formats.DOUBLE.parseValue(this.m_jstockvolume.getText());
        objectArray2[13] = this.m_UnitModel.getSelectedKey();
        objectArray2[14] = Formats.DOUBLE.parseValue(this.m_jAmount.getText()) != null ? Formats.DOUBLE.parseValue(this.m_jAmount.getText()) : Double.valueOf(0.0);
        objectArray2[15] = MaterialsEditor.a(this.m_jPriceBuy.getText()) != null ? MaterialsEditor.a(this.m_jPriceBuy.getText()) : 0.0;
        objectArray2[16] = Formats.BYTEA.parseValue(this.txtAttributes.getText());
        return objectArray2;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private static final Double a(String string) {
        try {
            return (Double)Formats.CURRENCY.parseValue(string);
        }
        catch (BasicException basicException) {
            return null;
        }
    }

    protected void calcUnitPrice() {
        double d2;
        try {
            d2 = MaterialsEditor.a(this.m_jPriceBuy.getText());
        }
        catch (Exception exception) {
            d2 = 0.0;
        }
        try {
            double d3 = (Double)Formats.DOUBLE.parseValue(this.m_jAmount.getText());
            this.dUnitPrice = d3 != 0.0 ? d2 / d3 : 0.0;
            if (!(this.dUnitPrice < 0.01)) {
                this.m_jUnitPrice.setText(Formats.CURRENCY.formatValue(this.dUnitPrice));
                return;
            }
            this.m_jUnitPrice.setText(Formats.DOUBLE.formatValue(this.dUnitPrice));
        }
        catch (Exception exception) {
            this.m_jUnitPrice.setText(Formats.CURRENCY.formatValue(0.0));
        }
    }

    final class a
    implements DocumentListener {
        private /* synthetic */ MaterialsEditor a;

        private a(MaterialsEditor materialsEditor) {
            this.a = materialsEditor;
        }

        @Override
        public final void changedUpdate(DocumentEvent documentEvent) {
            this.a.calcUnitPrice();
        }

        @Override
        public final void insertUpdate(DocumentEvent documentEvent) {
            this.a.calcUnitPrice();
        }

        @Override
        public final void removeUpdate(DocumentEvent documentEvent) {
            this.a.calcUnitPrice();
        }

        /* synthetic */ a(MaterialsEditor materialsEditor, byte by) {
            this(materialsEditor);
        }
    }
}

