/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.kds;

import com.posics.data.loader.DataRead;
import com.posics.data.loader.DataWrite;
import com.posics.data.loader.SerializableRead;
import com.posics.pos.printer.ticket.BasicTicketForKDS;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class KDSTicketInfo
implements SerializableRead,
Externalizable {
    private static final long serialVersionUID = 7640633837719L;
    private String id;
    private String money;
    private String displayid;
    private BasicTicketForKDS ticket;
    private Date datesent;
    private Date dateattended;
    private Date dateclosed;
    private int status;
    private Date lapsedtime;

    @Override
    public void readValues(DataRead dataRead) {
        this.id = dataRead.getString(1);
        this.money = dataRead.getString(2);
        this.displayid = dataRead.getString(3);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(dataRead.getBytes(4)));
            this.ticket = (BasicTicketForKDS)objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.datesent = dataRead.getTimestamp(5);
        this.dateattended = dataRead.getTimestamp(6);
        this.dateclosed = dataRead.getTimestamp(7);
        this.status = dataRead.getInt(8);
    }

    @Override
    public void readExternal(ObjectInput objectInput) {
        this.id = (String)objectInput.readObject();
        this.money = (String)objectInput.readObject();
        this.displayid = (String)objectInput.readObject();
        this.ticket = (BasicTicketForKDS)objectInput.readObject();
        this.datesent = (Date)objectInput.readObject();
        this.dateattended = (Date)objectInput.readObject();
        this.dateclosed = (Date)objectInput.readObject();
        this.status = objectInput.readInt();
    }

    public void writeValues(DataWrite dataWrite) {
        dataWrite.setString(1, this.id);
        dataWrite.setString(2, this.money);
        dataWrite.setString(3, this.displayid);
        dataWrite.setObject(4, this.ticket);
        dataWrite.setTimestamp(5, this.datesent);
        dataWrite.setTimestamp(6, this.dateattended);
        dataWrite.setTimestamp(7, this.dateclosed);
        dataWrite.setInt(8, this.status);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.money);
        objectOutput.writeObject(this.displayid);
        objectOutput.writeObject(this.ticket);
        objectOutput.writeObject(this.datesent);
        objectOutput.writeObject(this.dateattended);
        objectOutput.writeObject(this.dateclosed);
        objectOutput.writeInt(this.status);
    }

    public String getTicketId() {
        return this.id;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n2) {
        this.status = n2;
    }

    public String getMoney() {
        return this.money;
    }

    public String getDisplayID() {
        return this.displayid;
    }

    public BasicTicketForKDS getTicket() {
        return this.ticket;
    }

    public String printElapsedMinutes() {
        long l2 = this.datesent.getTime();
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l2;
        return String.format("%d:%02d", TimeUnit.MILLISECONDS.toMinutes(l4), TimeUnit.MILLISECONDS.toSeconds(l4) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(l4)));
    }

    public long getElapsedMinutes() {
        long l2 = this.datesent.getTime();
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l2;
        return TimeUnit.MILLISECONDS.toMinutes(l4);
    }

    public String printElapsedHours() {
        long l2 = this.datesent.getTime();
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l2;
        return String.format("%d:%02d", TimeUnit.MILLISECONDS.toHours(l4), TimeUnit.MILLISECONDS.toMinutes(l4) - TimeUnit.MILLISECONDS.toHours(l4) * 60L);
    }

    public long getElapsedHours() {
        long l2 = this.datesent.getTime();
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l2;
        return TimeUnit.MILLISECONDS.toHours(l4);
    }
}

