/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.panels;

import com.posics.data.loader.DataField;
import com.posics.data.loader.DataRead;
import com.posics.data.loader.Datas;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SQLTableModel
extends AbstractTableModel {
    private List m_aRows = new ArrayList();
    private DataField[] m_df;
    private Datas[] m_classes;

    public SQLTableModel(DataField[] dataFieldArray) {
        this.m_df = dataFieldArray;
        this.m_classes = new Datas[dataFieldArray.length];
        block8: for (int i2 = 0; i2 < dataFieldArray.length; ++i2) {
            switch (dataFieldArray[i2].Type) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    this.m_classes[i2] = Datas.INT;
                    continue block8;
                }
                case -7: 
                case 16: {
                    this.m_classes[i2] = Datas.BOOLEAN;
                    continue block8;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    this.m_classes[i2] = Datas.DOUBLE;
                    continue block8;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    this.m_classes[i2] = Datas.STRING;
                    continue block8;
                }
                case 91: 
                case 92: 
                case 93: {
                    this.m_classes[i2] = Datas.TIMESTAMP;
                    continue block8;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    this.m_classes[i2] = Datas.BYTES;
                    continue block8;
                }
                default: {
                    this.m_classes[i2] = Datas.OBJECT;
                }
            }
        }
    }

    public void addRow(DataRead dataRead) {
        Object[] objectArray = new Object[this.m_classes.length];
        for (int i2 = 0; i2 < this.m_classes.length; ++i2) {
            objectArray[i2] = this.m_classes[i2].getValue(dataRead, i2 + 1);
        }
        this.m_aRows.add(objectArray);
    }

    public String getColumnString(int n2) {
        Object[] objectArray = (Object[])this.m_aRows.get(n2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_classes[i2].toString(objectArray[i2]));
        }
        return stringBuffer.toString();
    }

    public Class getColumnClass(int n2) {
        return this.m_classes[n2].getClassValue();
    }

    @Override
    public String getColumnName(int n2) {
        return this.m_df[n2].Name;
    }

    @Override
    public int getRowCount() {
        return this.m_aRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_df.length;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        Object[] objectArray = (Object[])this.m_aRows.get(n2);
        return objectArray[n3];
    }
}

