/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.payment;

import com.posics.data.gui.MessageInf;
import com.posics.format.Formats;
import com.posics.pos.config.LAFColors;
import com.posics.pos.customers.CustomerInfoExt;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.AppView;
import com.posics.pos.forms.DataLogicSales;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.payment.JPaymentAdvance;
import com.posics.pos.payment.JPaymentCashPos;
import com.posics.pos.payment.JPaymentCheque;
import com.posics.pos.payment.JPaymentCurrency;
import com.posics.pos.payment.JPaymentDebt;
import com.posics.pos.payment.JPaymentFree;
import com.posics.pos.payment.JPaymentInterface;
import com.posics.pos.payment.JPaymentMagcard;
import com.posics.pos.payment.JPaymentNotifier;
import com.posics.pos.payment.JPaymentOnline;
import com.posics.pos.payment.JPaymentPaper;
import com.posics.pos.payment.JPaymentPoints;
import com.posics.pos.payment.JPaymentRefund;
import com.posics.pos.payment.PaymentInfo;
import com.posics.pos.payment.PaymentInfoList;
import com.posics.pos.payment.PaymentInfoTicket;
import com.posics.pos.payment.e;
import com.posics.pos.payment.f;
import com.posics.pos.payment.g;
import com.posics.pos.payment.h;
import com.posics.pos.payment.i;
import com.posics.pos.payment.j;
import com.posics.pos.payment.k;
import com.posics.pos.payment.l;
import com.posics.pos.scripting.ScriptException;
import com.posics.pos.scripting.ScriptFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;

public abstract class JPaymentSelect
extends JDialog
implements JPaymentNotifier {
    private PaymentInfoList m_aPaymentInfo;
    private boolean printselected;
    private boolean mailselected;
    private boolean whatsappselected;
    private boolean accepted;
    private AppView app;
    private double m_dTotal;
    private CustomerInfoExt customerext;
    private DataLogicSystem dlSystem;
    private DataLogicSales dlSales;
    private Map<String, JPaymentInterface> payments = new HashMap<String, JPaymentInterface>();
    private String m_sTransactionID;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JButton m_jButtonAdd;
    private JButton m_jButtonCancel;
    private JToggleButton m_jButtonMail;
    private JButton m_jButtonOK;
    private JToggleButton m_jButtonPrint;
    private JButton m_jButtonRemove;
    private JToggleButton m_jButtonWhatsapp;
    private JLabel m_jLblRemainingEuros;
    private JLabel m_jLblTotalEuros1;
    private JLabel m_jRemaininglEuros;
    private JTabbedPane m_jTabPayment;
    private JLabel m_jTotalEuros;

    protected JPaymentSelect(Frame frame, boolean bl2, ComponentOrientation componentOrientation) {
        super(frame, bl2);
        this.b();
        this.applyComponentOrientation(componentOrientation);
        this.getRootPane().setDefaultButton(this.m_jButtonOK);
    }

    protected JPaymentSelect(Dialog dialog, boolean bl2, ComponentOrientation componentOrientation) {
        super(dialog, bl2);
        this.b();
        this.applyComponentOrientation(componentOrientation);
    }

    public void init(AppView appView) {
        this.app = appView;
        this.dlSystem = (DataLogicSystem)appView.getBean("com.posics.pos.forms.DataLogicSystem");
        this.dlSales = (DataLogicSales)appView.getBean("com.posics.pos.forms.DataLogicSales");
        this.printselected = true;
        this.mailselected = false;
        this.whatsappselected = false;
        JPaymentSelect jPaymentSelect = this;
        jPaymentSelect.setLocationRelativeTo(jPaymentSelect.getParent());
    }

    public void setPrintSelected(boolean bl2) {
        this.printselected = bl2;
    }

    public void setMailSelected(boolean bl2) {
        this.mailselected = bl2;
    }

    public void setWhatsappSelected(boolean bl2) {
        this.whatsappselected = bl2;
    }

    public boolean isPrintSelected() {
        return this.printselected;
    }

    public boolean isMailSelected() {
        return this.mailselected;
    }

    public boolean isWhatsappSelected() {
        return this.whatsappselected;
    }

    public List<PaymentInfo> getSelectedPayments() {
        return this.m_aPaymentInfo.getPayments();
    }

    public void addFastPayment(double d2, String string) {
        this.m_aPaymentInfo = new PaymentInfoList();
        this.m_dTotal = d2;
        if ("debt".equals(string)) {
            this.m_aPaymentInfo.add(new PaymentInfoTicket(d2, "debt"));
        } else if ("magcard".equals(string)) {
            this.m_aPaymentInfo.add(new PaymentInfoTicket(d2, "magcard"));
        } else {
            this.m_aPaymentInfo.add(this.getDefaultPayment(d2));
        }
        this.accepted = true;
    }

    public boolean showDialog(double d2, CustomerInfoExt object, String object2) {
        this.m_aPaymentInfo = new PaymentInfoList();
        this.accepted = false;
        this.m_dTotal = d2;
        this.customerext = object;
        this.m_jButtonPrint.setSelected(this.printselected);
        this.m_jButtonMail.setSelected(this.mailselected);
        this.m_jButtonWhatsapp.setSelected(this.whatsappselected);
        this.m_jTotalEuros.setText(Formats.CURRENCY.formatValue(this.m_dTotal));
        object = ((String)object2).equals("refund") ? this.dlSystem.getResourceAsXML("payment.refund.tabs") : (((String)object2).equals("customer") ? this.dlSystem.getResourceAsXML("payment.customer.tabs") : (((String)object2).equals("supplier") ? this.dlSystem.getResourceAsXML("payment.supplier.tabs") : (((String)object2).equals("purchase") ? this.dlSystem.getResourceAsXML("payment.supplier.tabs") : (((String)object2).equals("purchasereturn") ? this.dlSystem.getResourceAsXML("payment.supplier.tabs") : this.dlSystem.getResourceAsXML("payment.receipt.tabs")))));
        if (object != null) {
            try {
                object2 = ScriptFactory.getScriptEngine("beanshell");
                object2.put("payment", new ScriptPaymentTab(this));
                object2.eval((String)object);
            }
            catch (ScriptException scriptException) {
                object = new MessageInf(-67108864, AppLocal.getIntString("message.cannotexecute"), scriptException);
                ((MessageInf)object).show(this);
            }
        }
        this.setHeaderVisible(true);
        if (this.m_jTabPayment.getTabCount() == 0) {
            this.m_aPaymentInfo.add(this.getDefaultPayment(d2));
            this.accepted = true;
        } else {
            this.getRootPane().setDefaultButton(this.m_jButtonOK);
            this.a();
            this.setVisible(true);
        }
        this.printselected = this.m_jButtonPrint.isSelected();
        this.mailselected = this.m_jButtonMail.isSelected();
        this.whatsappselected = this.m_jButtonWhatsapp.isSelected();
        this.m_jTabPayment.removeAll();
        return this.accepted;
    }

    protected abstract void setStatusPanel(boolean var1, boolean var2);

    protected abstract PaymentInfo getDefaultPayment(double var1);

    protected void setOKEnabled(boolean bl2) {
        this.m_jButtonOK.setEnabled(bl2);
    }

    protected void setAddEnabled(boolean bl2) {
        this.m_jButtonAdd.setEnabled(bl2);
    }

    protected void addTabPayment(JPaymentCreator object, String string, String string2) {
        if (this.app.getAppUserView().getUser().hasPermission(object.getKey())) {
            try {
                JPaymentInterface jPaymentInterface = this.payments.get(string);
                if (jPaymentInterface == null) {
                    jPaymentInterface = object.createJPayment(string);
                    this.payments.put(string, jPaymentInterface);
                }
                jPaymentInterface.getComponent().applyComponentOrientation(this.getComponentOrientation());
                if (string2.length() <= 0) {
                    this.m_jTabPayment.addTab(string, jPaymentInterface.getComponent());
                    return;
                }
                this.m_jTabPayment.addTab(string, new ImageIcon(this.dlSystem.getResourceAsImage(string2)), jPaymentInterface.getComponent());
            }
            catch (Exception exception) {
                object = new MessageInf(-67108864, AppLocal.getIntString("message.cannotexecute"), exception);
                ((MessageInf)object).show(this);
            }
        }
    }

    protected void setHeaderVisible(boolean bl2) {
        this.jPanel6.setVisible(bl2);
    }

    private void a() {
        this.m_jRemaininglEuros.setText(Formats.CURRENCY.formatValue(new Double(this.m_dTotal - this.m_aPaymentInfo.getTotal())));
        this.m_jButtonRemove.setEnabled(!this.m_aPaymentInfo.isEmpty());
        this.m_jTabPayment.setSelectedIndex(0);
        ((JPaymentInterface)((Object)this.m_jTabPayment.getSelectedComponent())).activate(this.customerext, this.m_dTotal - this.m_aPaymentInfo.getTotal(), this.m_sTransactionID);
    }

    protected static Window getWindow(Component component) {
        while (component != null) {
            if (component instanceof Frame || component instanceof Dialog) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return new JFrame();
    }

    @Override
    public void setStatus(boolean bl2, boolean bl3) {
        this.setStatusPanel(bl2, bl3);
    }

    @Override
    public void setCustomer(CustomerInfoExt customerInfoExt) {
        this.customerext = customerInfoExt;
    }

    @Override
    public CustomerInfoExt getCustomer() {
        return this.customerext;
    }

    public void setTransactionID(String string) {
        this.m_sTransactionID = string;
    }

    private void b() {
        this.jPanel4 = new JPanel();
        this.m_jLblTotalEuros1 = new JLabel();
        this.m_jTotalEuros = new JLabel();
        this.jPanel6 = new JPanel();
        this.m_jLblRemainingEuros = new JLabel();
        this.m_jRemaininglEuros = new JLabel();
        this.m_jButtonAdd = new JButton();
        this.m_jButtonRemove = new JButton();
        this.jPanel3 = new JPanel();
        this.m_jTabPayment = new JTabbedPane();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.m_jButtonPrint = new JToggleButton();
        this.m_jButtonMail = new JToggleButton();
        this.m_jButtonWhatsapp = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.m_jButtonOK = new JButton();
        this.m_jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(AppLocal.getIntString("payment.title"));
        this.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        this.setResizable(false);
        this.jPanel4.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        this.m_jLblTotalEuros1.setForeground(LAFColors.COLOR_LABEL);
        this.m_jLblTotalEuros1.setText(AppLocal.getIntString("label.totalcash"));
        this.jPanel4.add(this.m_jLblTotalEuros1);
        this.m_jTotalEuros.setBackground(new Color(0, 57, 249));
        this.m_jTotalEuros.setFont(this.m_jTotalEuros.getFont().deriveFont(this.m_jTotalEuros.getFont().getStyle() | 1, this.m_jTotalEuros.getFont().getSize() + 4));
        this.m_jTotalEuros.setForeground(new Color(255, 255, 255));
        this.m_jTotalEuros.setHorizontalAlignment(4);
        this.m_jTotalEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jTotalEuros.setOpaque(true);
        this.m_jTotalEuros.setPreferredSize(new Dimension(125, 25));
        this.m_jTotalEuros.setRequestFocusEnabled(false);
        this.jPanel4.add(this.m_jTotalEuros);
        this.jPanel6.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        this.jPanel6.setLayout(new FlowLayout(1, 5, 0));
        this.m_jLblRemainingEuros.setForeground(LAFColors.COLOR_LABEL);
        this.m_jLblRemainingEuros.setText(AppLocal.getIntString("label.remainingcash"));
        this.jPanel6.add(this.m_jLblRemainingEuros);
        this.m_jRemaininglEuros.setBackground(new Color(0, 57, 249));
        this.m_jRemaininglEuros.setFont(this.m_jRemaininglEuros.getFont().deriveFont(this.m_jRemaininglEuros.getFont().getStyle() | 1, this.m_jRemaininglEuros.getFont().getSize() + 4));
        this.m_jRemaininglEuros.setForeground(new Color(255, 255, 255));
        this.m_jRemaininglEuros.setHorizontalAlignment(4);
        this.m_jRemaininglEuros.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.darkShadow")), BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.m_jRemaininglEuros.setOpaque(true);
        this.m_jRemaininglEuros.setPreferredSize(new Dimension(125, 25));
        this.m_jRemaininglEuros.setRequestFocusEnabled(false);
        this.jPanel6.add(this.m_jRemaininglEuros);
        this.m_jButtonAdd.setBackground(LAFColors.COLOR_BUTTON);
        this.m_jButtonAdd.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.m_jButtonAdd.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/btnplus.png")));
        this.m_jButtonAdd.addActionListener(new e(this));
        this.jPanel6.add(this.m_jButtonAdd);
        this.m_jButtonRemove.setBackground(LAFColors.COLOR_BUTTON);
        this.m_jButtonRemove.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.m_jButtonRemove.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/btnminus.png")));
        this.m_jButtonRemove.addActionListener(new f(this));
        this.jPanel6.add(this.m_jButtonRemove);
        this.jPanel4.add(this.jPanel6);
        this.getContentPane().add((Component)this.jPanel4, "North");
        this.jPanel3.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        this.jPanel3.setLayout(new BorderLayout());
        this.m_jTabPayment.setBackground(LAFColors.COLOR_PANEL_LIGHT);
        this.m_jTabPayment.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jTabPayment.setTabPlacement(2);
        this.m_jTabPayment.setFocusable(false);
        this.m_jTabPayment.setRequestFocusEnabled(false);
        this.m_jTabPayment.addChangeListener(new g(this));
        this.jPanel3.add((Component)this.m_jTabPayment, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel5.setBackground(LAFColors.COLOR_PANEL);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel2.setBackground(LAFColors.COLOR_PANEL);
        this.m_jButtonPrint.setBackground(LAFColors.COLOR_PANEL);
        this.m_jButtonPrint.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.m_jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/printer24.png")));
        this.m_jButtonPrint.setSelected(true);
        this.m_jButtonPrint.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_jButtonPrint.setFocusPainted(false);
        this.m_jButtonPrint.setFocusable(false);
        this.m_jButtonPrint.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonPrint.setMaximumSize(new Dimension(50, 40));
        this.m_jButtonPrint.setMinimumSize(new Dimension(50, 40));
        this.m_jButtonPrint.setOpaque(true);
        this.m_jButtonPrint.setPreferredSize(new Dimension(50, 40));
        this.m_jButtonPrint.setRequestFocusEnabled(false);
        this.m_jButtonPrint.addItemListener(new h(this));
        this.jPanel2.add(this.m_jButtonPrint);
        this.m_jButtonMail.setBackground(LAFColors.COLOR_PANEL);
        this.m_jButtonMail.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.m_jButtonMail.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/email24.png")));
        this.m_jButtonMail.setSelected(true);
        this.m_jButtonMail.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_jButtonMail.setFocusPainted(false);
        this.m_jButtonMail.setFocusable(false);
        this.m_jButtonMail.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonMail.setMaximumSize(new Dimension(50, 40));
        this.m_jButtonMail.setMinimumSize(new Dimension(50, 40));
        this.m_jButtonMail.setOpaque(true);
        this.m_jButtonMail.setPreferredSize(new Dimension(50, 40));
        this.m_jButtonMail.setRequestFocusEnabled(false);
        this.m_jButtonMail.addItemListener(new i(this));
        this.jPanel2.add(this.m_jButtonMail);
        this.m_jButtonWhatsapp.setBackground(LAFColors.COLOR_PANEL);
        this.m_jButtonWhatsapp.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.m_jButtonWhatsapp.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/whatsapp24.png")));
        this.m_jButtonWhatsapp.setSelected(true);
        this.m_jButtonWhatsapp.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_jButtonWhatsapp.setFocusPainted(false);
        this.m_jButtonWhatsapp.setFocusable(false);
        this.m_jButtonWhatsapp.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonWhatsapp.setMaximumSize(new Dimension(50, 40));
        this.m_jButtonWhatsapp.setMinimumSize(new Dimension(50, 40));
        this.m_jButtonWhatsapp.setOpaque(true);
        this.m_jButtonWhatsapp.setPreferredSize(new Dimension(50, 40));
        this.m_jButtonWhatsapp.setRequestFocusEnabled(false);
        this.m_jButtonWhatsapp.addItemListener(new j(this));
        this.jPanel2.add(this.m_jButtonWhatsapp);
        this.jPanel1.setBackground(LAFColors.COLOR_PANEL);
        this.jPanel2.add(this.jPanel1);
        this.m_jButtonOK.setBackground(LAFColors.COLOR_BUTTON);
        this.m_jButtonOK.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.m_jButtonOK.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_ok.png")));
        this.m_jButtonOK.setText(AppLocal.getIntString("Button.OK"));
        this.m_jButtonOK.setFocusPainted(false);
        this.m_jButtonOK.setFocusable(false);
        this.m_jButtonOK.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonOK.setRequestFocusEnabled(false);
        this.m_jButtonOK.addActionListener(new k(this));
        this.jPanel2.add(this.m_jButtonOK);
        this.m_jButtonCancel.setBackground(LAFColors.COLOR_BUTTON);
        this.m_jButtonCancel.setForeground(LAFColors.COLOR_BUTTON_TEXT);
        this.m_jButtonCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/posics/images/button_cancel.png")));
        this.m_jButtonCancel.setText(AppLocal.getIntString("Button.Cancel"));
        this.m_jButtonCancel.setFocusPainted(false);
        this.m_jButtonCancel.setFocusable(false);
        this.m_jButtonCancel.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonCancel.setRequestFocusEnabled(false);
        this.m_jButtonCancel.addActionListener(new l(this));
        this.jPanel2.add(this.m_jButtonCancel);
        this.jPanel5.add((Component)this.jPanel2, "After");
        this.getContentPane().add((Component)this.jPanel5, "South");
        this.setSize(new Dimension(672, 497));
        this.setLocationRelativeTo(null);
    }

    static /* synthetic */ void access$700(JPaymentSelect jPaymentSelect, ActionEvent object) {
        object = ((JPaymentInterface)((Object)jPaymentSelect.m_jTabPayment.getSelectedComponent())).executePayment();
        if (object != null) {
            jPaymentSelect.m_aPaymentInfo.add((PaymentInfo)object);
            jPaymentSelect.a();
        }
    }

    static /* synthetic */ void access$800(JPaymentSelect jPaymentSelect, ActionEvent actionEvent) {
        jPaymentSelect.m_aPaymentInfo.removeLast();
        jPaymentSelect.a();
    }

    static /* synthetic */ void access$900(JPaymentSelect jPaymentSelect, ChangeEvent object) {
        if (jPaymentSelect.m_jTabPayment.getSelectedComponent() != null) {
            ((JPaymentInterface)((Object)jPaymentSelect.m_jTabPayment.getSelectedComponent())).activate(jPaymentSelect.customerext, jPaymentSelect.m_dTotal - jPaymentSelect.m_aPaymentInfo.getTotal(), jPaymentSelect.m_sTransactionID);
            if (jPaymentSelect.m_jTabPayment.getSelectedComponent().getClass().getName().endsWith("JPaymentPoints")) {
                object = jPaymentSelect.getSelectedPayments();
                Double d2 = 0.0;
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    if (!((PaymentInfo)object.get(i2)).getName().equals("pointsin")) continue;
                    d2 = d2 + ((PaymentInfo)object.get(i2)).getTotal();
                }
                if (d2 > 0.0) {
                    JPaymentPoints jPaymentPoints = (JPaymentPoints)jPaymentSelect.m_jTabPayment.getSelectedComponent();
                    jPaymentPoints.setTendered(d2);
                }
            }
        }
    }

    static /* synthetic */ void access$1000(JPaymentSelect jPaymentSelect, ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            jPaymentSelect.m_jButtonPrint.setIcon(new ImageIcon(jPaymentSelect.getClass().getResource("/com/posics/images/printer24.png")));
            return;
        }
        if (itemEvent.getStateChange() == 2) {
            jPaymentSelect.m_jButtonPrint.setIcon(new ImageIcon(jPaymentSelect.getClass().getResource("/com/posics/images/printer24bw.png")));
        }
    }

    static /* synthetic */ void access$1100(JPaymentSelect jPaymentSelect, ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            jPaymentSelect.m_jButtonMail.setIcon(new ImageIcon(jPaymentSelect.getClass().getResource("/com/posics/images/email24.png")));
            return;
        }
        if (itemEvent.getStateChange() == 2) {
            jPaymentSelect.m_jButtonMail.setIcon(new ImageIcon(jPaymentSelect.getClass().getResource("/com/posics/images/email24bw.png")));
        }
    }

    static /* synthetic */ void access$1200(JPaymentSelect jPaymentSelect, ItemEvent itemEvent) {
    }

    static /* synthetic */ void access$1300(JPaymentSelect jPaymentSelect, ActionEvent object) {
        object = ((JPaymentInterface)((Object)jPaymentSelect.m_jTabPayment.getSelectedComponent())).executePayment();
        if (object != null) {
            jPaymentSelect.m_aPaymentInfo.add((PaymentInfo)object);
            jPaymentSelect.accepted = true;
            jPaymentSelect.dispose();
        }
    }

    static /* synthetic */ void access$1400(JPaymentSelect jPaymentSelect, ActionEvent actionEvent) {
        jPaymentSelect.dispose();
    }

    public class ScriptPaymentTab {
        private /* synthetic */ JPaymentSelect a;

        public ScriptPaymentTab(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        public void addPayment(String object, String string, String string2) {
            if (string2.equals("cash")) {
                this.a.addTabPayment(new JPaymentCashCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("currency")) {
                this.a.addTabPayment(new JPaymentCurrencyCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("online")) {
                this.a.addTabPayment(new JPaymentOnlineCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("cheque")) {
                this.a.addTabPayment(new JPaymentChequeCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("voucher")) {
                this.a.addTabPayment(new JPaymentPaperCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("points")) {
                this.a.addTabPayment(new JPaymentPointsCreator(this.a), (String)object, string);
                object = (JPaymentPoints)this.a.m_jTabPayment.getComponentAt(this.a.m_jTabPayment.getComponentCount() - 1);
                ((JPaymentPoints)object).activate(this.a.customerext, this.a.m_dTotal, this.a.m_sTransactionID);
                return;
            }
            if (string2.equals("card")) {
                this.a.addTabPayment(new JPaymentMagcardCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("free")) {
                this.a.addTabPayment(new JPaymentFreeCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("debt")) {
                this.a.addTabPayment(new JPaymentDebtCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("advance")) {
                this.a.addTabPayment(new JPaymentAdvanceCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("cashrefund")) {
                this.a.addTabPayment(new JPaymentCashRefundCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("chequerefund")) {
                this.a.addTabPayment(new JPaymentChequeRefundCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("voucherrefund")) {
                this.a.addTabPayment(new JPaymentPaperRefundCreator(this.a), (String)object, string);
                return;
            }
            if (string2.equals("cardrefund")) {
                this.a.addTabPayment(new JPaymentMagcardRefundCreator(this.a), (String)object, string);
            }
        }
    }

    public class JPaymentMagcardRefundCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentMagcardRefundCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentMagcard(this.a.app, this.a, string);
        }

        @Override
        public String getKey() {
            return "refund.magcard";
        }

        @Override
        public String getLabelKey() {
            return "tab.magcard";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.card.png";
        }
    }

    public class JPaymentPaperRefundCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentPaperRefundCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentRefund(this.a, "paperout");
        }

        @Override
        public String getKey() {
            return "refund.paper";
        }

        @Override
        public String getLabelKey() {
            return "tab.paper";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.voucher.png";
        }
    }

    public class JPaymentChequeRefundCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentChequeRefundCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentRefund(this.a, "chequerefund");
        }

        @Override
        public String getKey() {
            return "refund.cheque";
        }

        @Override
        public String getLabelKey() {
            return "tab.chequerefund";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cheque.png";
        }
    }

    public class JPaymentCashRefundCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentCashRefundCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentRefund(this.a, "cashrefund");
        }

        @Override
        public String getKey() {
            return "refund.cash";
        }

        @Override
        public String getLabelKey() {
            return "tab.cashrefund";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cash.png";
        }
    }

    public class JPaymentAdvanceCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentAdvanceCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentAdvance(this.a, this.a.app);
        }

        @Override
        public String getKey() {
            return "payment.advance";
        }

        @Override
        public String getLabelKey() {
            return "tab.advance";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.debt.png";
        }
    }

    public class JPaymentDebtCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentDebtCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentDebt(this.a, this.a.app);
        }

        @Override
        public String getKey() {
            return "payment.debt";
        }

        @Override
        public String getLabelKey() {
            return "tab.debt";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.debt.png";
        }
    }

    public class JPaymentFreeCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentFreeCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentFree(this.a, string);
        }

        @Override
        public String getKey() {
            return "payment.free";
        }

        @Override
        public String getLabelKey() {
            return "tab.free";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.free.png";
        }
    }

    public class JPaymentMagcardCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentMagcardCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentMagcard(this.a.app, this.a, string);
        }

        @Override
        public String getKey() {
            return "payment.magcard";
        }

        @Override
        public String getLabelKey() {
            return "tab.magcard";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.card.png";
        }
    }

    public class JPaymentPointsCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentPointsCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentPoints(this.a, "pointsin", this.a.dlSystem);
        }

        @Override
        public String getKey() {
            return "payment.points";
        }

        @Override
        public String getLabelKey() {
            return "tab.points";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.points.png";
        }
    }

    public class JPaymentPaperCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentPaperCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentPaper(this.a, "paperin", string, this.a.dlSystem);
        }

        @Override
        public String getKey() {
            return "payment.paper";
        }

        @Override
        public String getLabelKey() {
            return "tab.paper";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.voucher.png";
        }
    }

    public class JPaymentCreditPaidChequeCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentCreditPaidChequeCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentCheque(this.a, this.a.dlSales);
        }

        @Override
        public String getKey() {
            return "payment.cheque";
        }

        @Override
        public String getLabelKey() {
            return "tab.cheque";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cheque.png";
        }
    }

    public class JPaymentChequeCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentChequeCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentCheque(this.a, this.a.dlSales);
        }

        @Override
        public String getKey() {
            return "payment.cheque";
        }

        @Override
        public String getLabelKey() {
            return "tab.cheque";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cheque.png";
        }
    }

    public class JPaymentCreditPaidCashCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentCreditPaidCashCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentCashPos(this.a, this.a.dlSystem, "Cash");
        }

        @Override
        public String getKey() {
            return "payment.cash";
        }

        @Override
        public String getLabelKey() {
            return "tab.cash";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cash.png";
        }
    }

    public class JPaymentOnlineCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentOnlineCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentOnline(this.a, "online", string);
        }

        @Override
        public String getKey() {
            return "payment.online";
        }

        @Override
        public String getLabelKey() {
            return "tab.online";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.online.png";
        }
    }

    public class JPaymentCurrencyCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentCurrencyCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentCurrency(this.a, "currency", string, this.a.dlSystem);
        }

        @Override
        public String getKey() {
            return "payment.currency";
        }

        @Override
        public String getLabelKey() {
            return "tab.currency";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.currency.png";
        }
    }

    public class JPaymentCashCreator
    implements JPaymentCreator {
        private /* synthetic */ JPaymentSelect a;

        public JPaymentCashCreator(JPaymentSelect jPaymentSelect) {
            this.a = jPaymentSelect;
        }

        @Override
        public JPaymentInterface createJPayment(String string) {
            return new JPaymentCashPos(this.a, this.a.dlSystem, string);
        }

        @Override
        public String getKey() {
            return "payment.cash";
        }

        @Override
        public String getLabelKey() {
            return "tab.cash";
        }

        @Override
        public String getIconKey() {
            return "/com/posics/pos/templates/payment.icon.cash.png";
        }
    }

    public static interface JPaymentCreator {
        public JPaymentInterface createJPayment(String var1);

        public String getKey();

        public String getLabelKey();

        public String getIconKey();
    }
}

