/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.escpos;

import com.posics.pos.printer.DeviceTicket;
import com.posics.pos.printer.escpos.ESCPOS;
import com.posics.pos.printer.escpos.PrinterWritter;
import com.posics.pos.printer.escpos.QRCode;
import com.posics.pos.util.StringUtils;
import java.awt.image.BufferedImage;
import org.krysalis.barcode4j.impl.qr.QRCodeBean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public abstract class Codes {
    public abstract byte[] getInitSequence();

    public abstract byte[] getSize0();

    public abstract byte[] getSize1();

    public abstract byte[] getSize2();

    public abstract byte[] getSize3();

    public abstract byte[] getSizeSmall1();

    public abstract byte[] getSizeSmall2();

    public abstract byte[] getSizeSmallReset();

    public abstract byte[] getBoldSet();

    public abstract byte[] getBoldReset();

    public abstract byte[] getUnderlineSet();

    public abstract byte[] getUnderlineReset();

    public abstract byte[] getInvertedSet();

    public abstract byte[] getInvertedReset();

    public abstract byte[] getRotateSet();

    public abstract byte[] getRotateReset();

    public abstract byte[] getRedColorSet();

    public abstract byte[] getRedColorReset();

    public abstract byte[] getOpenDrawer();

    public abstract byte[] getPlayBuzzer();

    public abstract byte[] getCutReceipt();

    public abstract byte[] getNewLine();

    public abstract byte[] getImageHeader();

    public abstract int getImageWidth();

    public void printBarcode(PrinterWritter printerWritter, String object, String string, int n2, String string2) {
        if ("EAN13".equals(object)) {
            printerWritter.write(this.getNewLine());
            printerWritter.write(ESCPOS.BAR_ALIGN_CENTER);
            printerWritter.write(ESCPOS.BAR_HEIGHT);
            if ("none".equals(string)) {
                printerWritter.write(ESCPOS.BAR_POSITIONNONE);
            } else {
                printerWritter.write(ESCPOS.BAR_POSITIONDOWN);
            }
            printerWritter.write(ESCPOS.BAR_HRIFONT1);
            printerWritter.write(ESCPOS.BAR_CODE02);
            printerWritter.write(DeviceTicket.transNumber(DeviceTicket.alignBarCode(string2, 13).substring(0, 12)));
            printerWritter.write(new byte[]{0});
            printerWritter.write(this.getNewLine());
            return;
        }
        if ("EAN8".equals(object)) {
            printerWritter.write(this.getNewLine());
            printerWritter.write(ESCPOS.BAR_ALIGN_CENTER);
            printerWritter.write(ESCPOS.BAR_HEIGHT);
            if ("none".equals(string)) {
                printerWritter.write(ESCPOS.BAR_POSITIONNONE);
            } else {
                printerWritter.write(ESCPOS.BAR_POSITIONDOWN);
            }
            printerWritter.write(ESCPOS.BAR_HRIFONT1);
            printerWritter.write(ESCPOS.BAR_CODE03);
            printerWritter.write(DeviceTicket.transNumber(DeviceTicket.alignBarCode(string2, 8).substring(0, 7)));
            printerWritter.write(new byte[]{0});
            printerWritter.write(this.getNewLine());
            return;
        }
        if ("CODE39".equals(object)) {
            printerWritter.write(this.getNewLine());
            printerWritter.write(ESCPOS.BAR_ALIGN_CENTER);
            printerWritter.write(ESCPOS.BAR_HEIGHT);
            if ("none".equals(string)) {
                printerWritter.write(ESCPOS.BAR_POSITIONNONE);
            } else {
                printerWritter.write(ESCPOS.BAR_POSITIONDOWN);
            }
            printerWritter.write(ESCPOS.BAR_HRIFONT1);
            printerWritter.write(ESCPOS.BAR_CODE04);
            printerWritter.write(DeviceTicket.transNumber(string2));
            printerWritter.write(new byte[]{0});
            printerWritter.write(this.getNewLine());
            return;
        }
        if ("CODE128".equals(object)) {
            printerWritter.write(this.getNewLine());
            printerWritter.write(ESCPOS.BAR_ALIGN_CENTER);
            printerWritter.write(ESCPOS.BAR_HEIGHT);
            if ("none".equals(string)) {
                printerWritter.write(ESCPOS.BAR_POSITIONNONE);
            } else {
                printerWritter.write(ESCPOS.BAR_POSITIONDOWN);
            }
            printerWritter.write(ESCPOS.BAR_HRIFONT1);
            printerWritter.write(ESCPOS.BAR_CODE_CODE128);
            printerWritter.write(new byte[]{(byte)(string2.length() + 2)});
            printerWritter.write(ESCPOS.BAR_CODE_CODE128_A);
            printerWritter.write(DeviceTicket.transNumber(string2));
            printerWritter.write(this.getNewLine());
            return;
        }
        if ("QR".equals(object)) {
            printerWritter.write(this.getNewLine());
            object = new QRCode(n2);
            printerWritter.write(((QRCode)object).getBytes(string2));
            printerWritter.write(this.getNewLine());
            return;
        }
        if ("QR-ZATCA".equals(object)) {
            printerWritter.write(this.getNewLine());
            object = new QRCode(n2);
            printerWritter.write(((QRCode)object).getBytes(StringUtils.getZatcaQR(string2)));
            printerWritter.write(this.getNewLine());
            return;
        }
        if ("QR-IMAGE".equals(object)) {
            printerWritter.write(this.getNewLine());
            object = new QRCodeBean();
            string = new BitmapCanvasProvider(n2 * 50, 12, false, 0);
            object.generateBarcode((CanvasProvider)string, string2);
            printerWritter.write(this.transImage(string.getBufferedImage()));
            printerWritter.write(this.getNewLine());
            return;
        }
        if ("QR-ZATCA-IMAGE".equals(object)) {
            printerWritter.write(this.getNewLine());
            object = new QRCodeBean();
            string = new BitmapCanvasProvider(n2 * 50, 12, false, 0);
            object.generateBarcode((CanvasProvider)string, StringUtils.getZatcaQR(string2));
            printerWritter.write(this.transImage(string.getBufferedImage()));
            printerWritter.write(this.getNewLine());
        }
    }

    public byte[] transImage(BufferedImage object) {
        object = new CenteredImage(this, (BufferedImage)object, this.getImageWidth());
        int n2 = (((CenteredImage)object).getWidth() + 7) / 8;
        int n3 = ((CenteredImage)object).getHeight();
        byte[] byArray = new byte[this.getImageHeader().length + 4 + n2 * n3];
        System.arraycopy(this.getImageHeader(), 0, byArray, 0, this.getImageHeader().length);
        int n4 = this.getImageHeader().length;
        byArray[n4++] = (byte)((double)n2 % 292.6);
        byArray[n4++] = (byte)((double)n2 / 292.6);
        byArray[n4++] = (byte)((double)n3 % 292.6);
        byArray[n4++] = (byte)((double)n3 / 292.6);
        for (n3 = 0; n3 < ((CenteredImage)object).getHeight(); ++n3) {
            for (int i2 = 0; i2 < ((CenteredImage)object).getWidth(); i2 += 8) {
                n2 = 0;
                for (int i3 = 0; i3 < 8; ++i3) {
                    n2 <<= 1;
                    if (!((CenteredImage)object).isBlack(i2 + i3, n3)) continue;
                    n2 |= 1;
                }
                byArray[n4++] = (byte)n2;
            }
        }
        return byArray;
    }

    protected class CenteredImage {
        private BufferedImage a;
        private int b;

        public CenteredImage(Codes codes, BufferedImage bufferedImage, int n2) {
            this.a = bufferedImage;
            this.b = n2;
        }

        public int getHeight() {
            return this.a.getHeight();
        }

        public int getWidth() {
            return this.b;
        }

        public boolean isBlack(int n2, int n3) {
            if ((n2 += (this.a.getWidth() - this.b) / 2) < 0 || n2 >= this.a.getWidth() || n3 < 0 || n3 >= this.a.getHeight()) {
                return false;
            }
            n2 = this.a.getRGB(n2, n3);
            return (n2 = (int)(0.3 * (double)(n2 >> 16 & 0xFF) + 0.59 * (double)(n2 >> 8 & 0xFF) + 0.11 * (double)(n2 & 0xFF))) < 128;
        }
    }
}

