/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.escpos;

import com.posics.pos.printer.escpos.EscPosConst;
import java.io.ByteArrayOutputStream;

public class QRCode
implements EscPosConst {
    protected EscPosConst.Justification justification = EscPosConst.Justification.Center;
    protected QRModel model = QRModel._2;
    protected int size;
    protected QRErrorCorrectionLevel errorCorrectionLevel;

    public QRCode(int n2) {
        this.size = n2;
        this.errorCorrectionLevel = QRErrorCorrectionLevel.QR_ECLEVEL_M_Default;
    }

    public QRCode setJustification(EscPosConst.Justification justification) {
        this.justification = justification;
        return this;
    }

    public QRCode setModel(QRModel qRModel) {
        this.model = qRModel;
        return this;
    }

    public QRCode setSize(int n2) {
        if (n2 <= 0 || n2 > 16) {
            throw new IllegalArgumentException("size must be between 1 and 16");
        }
        this.size = n2;
        return this;
    }

    public QRCode setErrorCorrectionLevel(QRErrorCorrectionLevel qRErrorCorrectionLevel) {
        this.errorCorrectionLevel = qRErrorCorrectionLevel;
        return this;
    }

    public byte[] getBytes(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(27);
        byteArrayOutputStream.write(97);
        byteArrayOutputStream.write(this.justification.value);
        byteArrayOutputStream.write(29);
        byteArrayOutputStream.write(40);
        byteArrayOutputStream.write(107);
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(49);
        byteArrayOutputStream.write(65);
        byteArrayOutputStream.write(this.model.value);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(29);
        byteArrayOutputStream.write(40);
        byteArrayOutputStream.write(107);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(49);
        byteArrayOutputStream.write(67);
        byteArrayOutputStream.write(this.size);
        byteArrayOutputStream.write(29);
        byteArrayOutputStream.write(40);
        byteArrayOutputStream.write(107);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(49);
        byteArrayOutputStream.write(69);
        byteArrayOutputStream.write(this.errorCorrectionLevel.value);
        int n2 = string.length() + 3;
        int n3 = n2 & 0xFF;
        n2 = n2 >> 8 & 0xFF;
        byteArrayOutputStream.write(29);
        byteArrayOutputStream.write(40);
        byteArrayOutputStream.write(107);
        byteArrayOutputStream.write(n3);
        byteArrayOutputStream.write(n2);
        byteArrayOutputStream.write(49);
        byteArrayOutputStream.write(80);
        byteArrayOutputStream.write(48);
        byteArrayOutputStream.write(string.getBytes(), 0, string.length());
        byteArrayOutputStream.write(29);
        byteArrayOutputStream.write(40);
        byteArrayOutputStream.write(107);
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(49);
        byteArrayOutputStream.write(81);
        byteArrayOutputStream.write(48);
        return byteArrayOutputStream.toByteArray();
    }

    public static enum QRErrorCorrectionLevel {
        QR_ECLEVEL_L(48),
        QR_ECLEVEL_M_Default(49),
        QR_ECLEVEL_Q(50),
        QR_ECLEVEL_H(51);

        public int value;

        private QRErrorCorrectionLevel(int n3) {
            this.value = n3;
        }
    }

    public static enum QRModel {
        _1_Default(48),
        _2(49);

        public int value;

        private QRModel(int n3) {
            this.value = n3;
        }
    }
}

