/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.escpos;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TlvBox {
    protected static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    protected final Map<Integer, byte[]> valueMap = new HashMap<Integer, byte[]>();

    public TlvBox() {
    }

    public TlvBox(TlvBox tlvBox) {
        this(tlvBox != null ? tlvBox.serialize() : null);
    }

    public TlvBox(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public TlvBox(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null) {
            return;
        }
        for (int i2 = 0; i2 < n3; i2 += n4) {
            int n5 = ByteBuffer.wrap(byArray, n2 + i2, 4).order(DEFAULT_BYTE_ORDER).getInt();
            n4 = ByteBuffer.wrap(byArray, n2 + (i2 += 4), 4).order(DEFAULT_BYTE_ORDER).getInt();
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n2 + (i2 += 4), byArray2, 0, n4);
            this.put(n5, byArray2);
        }
    }

    public int length() {
        int n2 = 0;
        for (Map.Entry<Integer, byte[]> entry : this.valueMap.entrySet()) {
            n2 += entry.getValue().length + 8;
        }
        return n2;
    }

    public static TlvBox create() {
        return new TlvBox();
    }

    public static TlvBox clone(TlvBox tlvBox) {
        if (tlvBox == null) {
            return null;
        }
        return new TlvBox(tlvBox.serialize());
    }

    public static TlvBox parse(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return null;
        }
        return new TlvBox(byArray, n2, n3);
    }

    public static TlvBox parse(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new TlvBox(byArray);
    }

    public static byte[] serialize(TlvBox tlvBox) {
        if (tlvBox == null) {
            return null;
        }
        return tlvBox.serialize();
    }

    public byte[] serialize() {
        int n2 = this.length();
        if (n2 == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (Map.Entry<Integer, byte[]> entry : this.valueMap.entrySet()) {
            Integer n3 = entry.getKey();
            byte[] byArray = entry.getValue();
            byteArrayOutputStream.write(n3.byteValue());
            byteArrayOutputStream.write((byte)byArray.length);
            try {
                byteArrayOutputStream.write(entry.getValue());
            }
            catch (IOException iOException) {
                Logger.getLogger(TlvBox.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public TlvBox put(int n2, byte[] byArray) {
        if (byArray == null) {
            return this;
        }
        this.valueMap.put(n2, byArray);
        return this;
    }

    public TlvBox put(int n2, byte by) {
        return this.put(n2, new byte[]{by});
    }

    public TlvBox put(int n2, boolean bl2) {
        return this.put(n2, new byte[]{bl2 ? (byte)1 : 0});
    }

    public TlvBox put(int n2, char c2) {
        return this.put(n2, ByteBuffer.allocate(2).order(DEFAULT_BYTE_ORDER).putChar(c2).array());
    }

    public TlvBox put(int n2, short s2) {
        return this.put(n2, ByteBuffer.allocate(2).order(DEFAULT_BYTE_ORDER).putShort(s2).array());
    }

    public TlvBox put(int n2, int n3) {
        return this.put(n2, ByteBuffer.allocate(4).order(DEFAULT_BYTE_ORDER).putInt(n3).array());
    }

    public TlvBox put(int n2, long l2) {
        return this.put(n2, ByteBuffer.allocate(8).order(DEFAULT_BYTE_ORDER).putLong(l2).array());
    }

    public TlvBox put(int n2, float f2) {
        return this.put(n2, ByteBuffer.allocate(4).order(DEFAULT_BYTE_ORDER).putFloat(f2).array());
    }

    public TlvBox put(int n2, double d2) {
        return this.put(n2, ByteBuffer.allocate(8).order(DEFAULT_BYTE_ORDER).putDouble(d2).array());
    }

    public TlvBox put(int n2, String string) {
        if (string == null) {
            return this;
        }
        return this.put(n2, string.getBytes(StandardCharsets.UTF_8));
    }

    public TlvBox put(int n2, TlvBox tlvBox) {
        if (tlvBox == null) {
            return this;
        }
        return this.put(n2, tlvBox.serialize());
    }

    public byte[] getBytes(int n2) {
        return this.valueMap.get(n2);
    }

    public Byte getByte(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return byArray[0];
    }

    public Boolean getBoolean(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return byArray[0] == 1;
    }

    public Character getCharacter(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return Character.valueOf(ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getChar());
    }

    public Short getShort(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getShort();
    }

    public Integer getInteger(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getInt();
    }

    public Long getLong(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getLong();
    }

    public Float getFloat(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return Float.valueOf(ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getFloat());
    }

    public Double getDouble(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray).order(DEFAULT_BYTE_ORDER).getDouble();
    }

    public String getString(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public TlvBox getObject(int n2) {
        byte[] byArray = this.getBytes(n2);
        if (byArray == null) {
            return null;
        }
        return new TlvBox(byArray, 0, byArray.length);
    }

    public boolean contains(int n2) {
        return this.valueMap.containsKey(n2);
    }

    public byte[] remove(int n2) {
        return this.valueMap.remove(n2);
    }
}

