/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.screen;

import com.posics.data.gui.MessageInf;
import com.posics.data.loader.Datas;
import com.posics.data.loader.PreparedSentence;
import com.posics.data.loader.SerializerWriteBasicExt;
import com.posics.pos.config.LAFColors;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.forms.JRootApp;
import com.posics.pos.printer.DevicePrinter;
import com.posics.pos.printer.screen.JTicketContainer;
import com.posics.pos.printer.ticket.BasicTicketForKDS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DevicePrinterKDS
extends JPanel
implements DevicePrinter {
    private String m_sName;
    private String m_skdsid;
    private List<EstimateLine> m_aLines;
    private JTicketContainer m_jTicketContainer;
    private BasicTicketForKDS m_ticketcurrent;
    private JRootApp m_jrootapp;
    private JScrollPane m_jScrollView;

    public DevicePrinterKDS(Component component, String string) {
        DevicePrinterKDS devicePrinterKDS = this;
        this.m_jScrollView = new JScrollPane();
        devicePrinterKDS.setBackground(LAFColors.COLOR_PANEL);
        devicePrinterKDS.setLayout(new BorderLayout());
        devicePrinterKDS.m_jScrollView.setBackground(LAFColors.COLOR_PANEL);
        DevicePrinterKDS devicePrinterKDS2 = devicePrinterKDS;
        devicePrinterKDS2.add((Component)devicePrinterKDS2.m_jScrollView, "Center");
        this.m_skdsid = string;
        this.m_sName = AppLocal.getIntString("Printer.KDS");
        this.m_jrootapp = (JRootApp)component;
        this.m_ticketcurrent = null;
        this.m_jTicketContainer = new JTicketContainer();
        this.m_jScrollView.setViewportView(this.m_jTicketContainer);
    }

    @Override
    public String getPrinterName() {
        return this.m_sName;
    }

    @Override
    public String getPrinterDescription() {
        return null;
    }

    @Override
    public void setCodepage(int n2) {
    }

    @Override
    public void setTextFont(String string, int n2) {
        this.m_ticketcurrent.setTextFont(string, n2);
    }

    @Override
    public JComponent getPrinterComponent() {
        return this;
    }

    @Override
    public void reset() {
        this.m_ticketcurrent = null;
        this.m_jTicketContainer.removeAllTickets();
        this.m_jTicketContainer.repaint();
    }

    @Override
    public void beginReceipt() {
        this.m_ticketcurrent = new BasicTicketForKDS();
        this.m_aLines = new ArrayList<EstimateLine>();
    }

    @Override
    public void printImage(BufferedImage bufferedImage) {
        this.m_ticketcurrent.printImage(bufferedImage);
    }

    @Override
    public void printBarCode(String string, String string2, String string3, String string4) {
        this.m_ticketcurrent.printBarCode(string, string2, string3, string4);
    }

    @Override
    public void beginLine(int n2) {
        this.m_ticketcurrent.beginLine(n2);
    }

    @Override
    public void printText(int n2, String string) {
        this.m_ticketcurrent.printText(n2, string);
    }

    @Override
    public void endLine() {
        this.m_ticketcurrent.endLine();
    }

    @Override
    public void endReceipt() {
        try {
            String string = UUID.randomUUID().toString();
            Object[] objectArray = new Object[]{string, this.m_jrootapp.getActiveCashIndex(), this.m_skdsid, this.m_ticketcurrent, new Date(), this.m_jrootapp.getAppUserView().getUser().getId(), 0};
            Datas[] datasArray = new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.SERIALIZABLE, Datas.TIMESTAMP, Datas.STRING, Datas.INT};
            new PreparedSentence(this.m_jrootapp.getSession(), "INSERT INTO KDSTICKETS (ID, MONEY, DISPLAYID, CONTENT, DATESENT, USERNAME, STATUS) VALUES (?, ?, ?, ?, ?, ?, ?)", new SerializerWriteBasicExt(datasArray, new int[]{0, 1, 2, 3, 4, 5, 6})).exec(objectArray);
            datasArray = new Datas[]{Datas.STRING, Datas.TIMESTAMP, Datas.STRING, Datas.STRING, Datas.DOUBLE};
            for (int i2 = 0; i2 < this.m_aLines.size(); ++i2) {
                objectArray = new Object[]{UUID.randomUUID().toString(), new Date(), string, this.m_aLines.get(i2).b, this.m_aLines.get(i2).a};
                new PreparedSentence(this.m_jrootapp.getSession(), "INSERT INTO KDSLINES (ID, DATESENT, KDSID, PRODUCT, UNITS) VALUES (?, ?, ?, ?, ?)", new SerializerWriteBasicExt(datasArray, new int[]{0, 1, 2, 3, 4})).exec(objectArray);
            }
        }
        catch (Exception exception) {
            new MessageInf(exception).show(this);
        }
        this.m_ticketcurrent = null;
    }

    @Override
    public void openDrawer() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void sendHex(byte[] byArray) {
    }

    @Override
    public void playBuzzer() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void estimateLine(String string, double d2) {
        this.m_aLines.add(new EstimateLine(this, string, d2, 0));
    }

    public class EstimateLine {
        private double a;
        private String b;

        private EstimateLine(DevicePrinterKDS devicePrinterKDS, String string, double d2) {
            this.b = string;
            this.a = d2;
        }

        /* synthetic */ EstimateLine(DevicePrinterKDS devicePrinterKDS, String string, double d2, byte by) {
            this(devicePrinterKDS, string, d2);
        }
    }
}

