/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.screen;

import com.posics.pos.config.LAFColors;
import com.posics.pos.forms.AppLocal;
import com.posics.pos.printer.DevicePrinter;
import com.posics.pos.printer.screen.JTicket;
import com.posics.pos.printer.screen.JTicketContainer;
import com.posics.pos.printer.ticket.BasicTicket;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DevicePrinterPanel
extends JPanel
implements DevicePrinter {
    private String m_sName;
    private JTicketContainer m_jTicketContainer;
    private BasicTicket m_ticketcurrent;
    private int receiptColumns = 48;
    private JScrollPane m_jScrollView;

    public DevicePrinterPanel(int n2) {
        this.receiptColumns = n2;
        this.a();
        this.m_sName = AppLocal.getIntString("Printer.Screen");
        this.m_ticketcurrent = null;
        this.m_jTicketContainer = new JTicketContainer();
        this.m_jScrollView.setViewportView(this.m_jTicketContainer);
    }

    public DevicePrinterPanel() {
        this.a();
        this.m_sName = AppLocal.getIntString("Printer.Screen");
        this.m_ticketcurrent = null;
        this.m_jTicketContainer = new JTicketContainer();
        this.m_jScrollView.setViewportView(this.m_jTicketContainer);
    }

    @Override
    public String getPrinterName() {
        return this.m_sName;
    }

    @Override
    public String getPrinterDescription() {
        return null;
    }

    @Override
    public JComponent getPrinterComponent() {
        return this;
    }

    @Override
    public void reset() {
        this.m_ticketcurrent = null;
        this.m_jTicketContainer.removeAllTickets();
        this.m_jTicketContainer.repaint();
    }

    @Override
    public void beginReceipt() {
        this.m_ticketcurrent = new BasicTicket();
    }

    @Override
    public void printImage(BufferedImage bufferedImage) {
        this.m_ticketcurrent.printImage(bufferedImage);
    }

    @Override
    public void printBarCode(String string, String string2, String string3, String string4) {
        this.m_ticketcurrent.printBarCode(string, string2, string3, string4);
    }

    @Override
    public void beginLine(int n2) {
        this.m_ticketcurrent.beginLine(n2);
    }

    @Override
    public void printText(int n2, String string) {
        this.m_ticketcurrent.printText(n2, string);
    }

    @Override
    public void endLine() {
        this.m_ticketcurrent.endLine();
    }

    @Override
    public void endReceipt() {
        JTicket jTicket = new JTicket(this.m_ticketcurrent);
        jTicket.setColumns(this.receiptColumns);
        this.m_jTicketContainer.addTicket(jTicket);
        this.m_ticketcurrent = null;
    }

    @Override
    public void openDrawer() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void sendHex(byte[] byArray) {
        this.m_ticketcurrent.printText(1, new String(byArray, Charset.forName("IBM-437")));
    }

    @Override
    public void playBuzzer() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void setCodepage(int n2) {
    }

    @Override
    public void setTextFont(String string, int n2) {
        this.m_ticketcurrent.setTextFont(string, n2);
    }

    @Override
    public void estimateLine(String string, double d2) {
    }

    private void a() {
        this.m_jScrollView = new JScrollPane();
        this.setBackground(LAFColors.COLOR_PANEL);
        this.setLayout(new BorderLayout());
        DevicePrinterPanel devicePrinterPanel = this;
        devicePrinterPanel.add((Component)devicePrinterPanel.m_jScrollView, "Center");
    }
}

