/*
 * Decompiled with CFR 0.152.
 */
package com.posics.pos.printer.screen;

import com.posics.pos.config.LAFColors;
import com.posics.pos.forms.DataLogicSystem;
import com.posics.pos.printer.screen.JSecondDisplayPanel;
import com.posics.pos.printer.screen.a;
import com.posics.pos.printer.screen.b;
import com.posics.pos.ticket.TicketInfo;
import com.posics.pos.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.Timer;

public class JSecondDisplay
extends JFrame {
    private JSecondDisplayPanel m_second;
    private Timer timer;
    private boolean m_blTimer = false;
    private boolean m_blScale = false;
    private int m_iRefreshAfter = 0;
    GraphicsDevice gd;
    DataLogicSystem m_dlSystem;

    public JSecondDisplay(GraphicsDevice object, DataLogicSystem dataLogicSystem, boolean bl2) {
        this.gd = object;
        this.m_dlSystem = dataLogicSystem;
        this.m_blScale = bl2;
        this.setUndecorated(true);
        this.setResizable(false);
        object = this;
        ((JFrame)object).setDefaultCloseOperation(0);
        ((Window)object).setAutoRequestFocus(false);
        ((Frame)object).setBackground(LAFColors.COLOR_PANEL);
        ((Window)object).setFocusCycleRoot(false);
        ((Component)object).setFocusable(false);
        ((Window)object).setFocusableWindowState(false);
        ((Window)object).addWindowListener(new b((JSecondDisplay)object));
    }

    public void changeImage() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
        this.m_second.showNextImage();
    }

    public void showImage(BufferedImage bufferedImage) {
        this.m_second.showImage(bufferedImage);
        this.timer.restart();
    }

    public void showImage(String string) {
        this.m_second.showImage(string);
        this.timer.restart();
    }

    public void showWeight(String string) {
        this.m_second.showWeight(string);
    }

    public void changeTicket(TicketInfo ticketInfo) {
        this.timer.stop();
        this.m_second.changeTicket(ticketInfo);
    }

    public void clearTicket() {
        this.m_second.clearTicket();
    }

    public void initFrame() {
        this.m_second = new JSecondDisplayPanel(this.m_dlSystem, this.m_blScale);
        JSecondDisplay jSecondDisplay = this;
        jSecondDisplay.add((Component)jSecondDisplay.m_second, "Center");
        this.setTitle("Saleculator Customer Display");
        Object object = new Dimension(this.gd.getDisplayMode().getWidth(), this.gd.getDisplayMode().getHeight());
        this.setBounds(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        JSecondDisplay jSecondDisplay2 = this;
        jSecondDisplay2.setLocation(jSecondDisplay2.gd.getDefaultConfiguration().getBounds().getLocation());
        this.setVisible(true);
        object = StringUtils.config.getProperty("SecondDisplay.RefreshInterval");
        try {
            this.m_iRefreshAfter = Integer.parseInt((String)object) * 1000;
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            this.m_iRefreshAfter = 15000;
        }
        if (this.m_iRefreshAfter > 0) {
            this.timer = new Timer(this.m_iRefreshAfter, new a(this));
            this.timer.start();
        }
    }

    static /* synthetic */ void access$000(JSecondDisplay jSecondDisplay, WindowEvent windowEvent) {
        System.exit(0);
    }

    static /* synthetic */ void access$100(JSecondDisplay jSecondDisplay, WindowEvent windowEvent) {
    }
}

